// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkehub/v1/service.proto

#include "google/cloud/gkehub/v1/gke_hub_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace gkehub_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

GkeHubConnectionIdempotencyPolicy::~GkeHubConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<GkeHubConnectionIdempotencyPolicy>
GkeHubConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<GkeHubConnectionIdempotencyPolicy>(*this);
}

Idempotency GkeHubConnectionIdempotencyPolicy::ListMemberships(
    google::cloud::gkehub::v1::ListMembershipsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::ListFeatures(
    google::cloud::gkehub::v1::ListFeaturesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::GetMembership(
    google::cloud::gkehub::v1::GetMembershipRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::GetFeature(
    google::cloud::gkehub::v1::GetFeatureRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::CreateMembership(
    google::cloud::gkehub::v1::CreateMembershipRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::CreateFeature(
    google::cloud::gkehub::v1::CreateFeatureRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::DeleteMembership(
    google::cloud::gkehub::v1::DeleteMembershipRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::DeleteFeature(
    google::cloud::gkehub::v1::DeleteFeatureRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::UpdateMembership(
    google::cloud::gkehub::v1::UpdateMembershipRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::UpdateFeature(
    google::cloud::gkehub::v1::UpdateFeatureRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GkeHubConnectionIdempotencyPolicy::GenerateConnectManifest(
    google::cloud::gkehub::v1::GenerateConnectManifestRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<GkeHubConnectionIdempotencyPolicy>
MakeDefaultGkeHubConnectionIdempotencyPolicy() {
  return std::make_unique<GkeHubConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkehub_v1
}  // namespace cloud
}  // namespace google
