// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#include "google/cloud/iap/v1/internal/identity_aware_proxy_admin_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace iap_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

IdentityAwareProxyAdminServiceTracingConnection::
    IdentityAwareProxyAdminServiceTracingConnection(
        std::shared_ptr<iap_v1::IdentityAwareProxyAdminServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::iam::v1::Policy>
IdentityAwareProxyAdminServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
IdentityAwareProxyAdminServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
IdentityAwareProxyAdminServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StatusOr<google::cloud::iap::v1::IapSettings>
IdentityAwareProxyAdminServiceTracingConnection::GetIapSettings(
    google::cloud::iap::v1::GetIapSettingsRequest const& request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::GetIapSettings");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIapSettings(request));
}

StatusOr<google::cloud::iap::v1::IapSettings>
IdentityAwareProxyAdminServiceTracingConnection::UpdateIapSettings(
    google::cloud::iap::v1::UpdateIapSettingsRequest const& request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::UpdateIapSettings");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateIapSettings(request));
}

StreamRange<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceTracingConnection::ListTunnelDestGroups(
    google::cloud::iap::v1::ListTunnelDestGroupsRequest request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::ListTunnelDestGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListTunnelDestGroups(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::iap::v1::TunnelDestGroup>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceTracingConnection::CreateTunnelDestGroup(
    google::cloud::iap::v1::CreateTunnelDestGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::"
      "CreateTunnelDestGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateTunnelDestGroup(request));
}

StatusOr<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceTracingConnection::GetTunnelDestGroup(
    google::cloud::iap::v1::GetTunnelDestGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::GetTunnelDestGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTunnelDestGroup(request));
}

Status IdentityAwareProxyAdminServiceTracingConnection::DeleteTunnelDestGroup(
    google::cloud::iap::v1::DeleteTunnelDestGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::"
      "DeleteTunnelDestGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteTunnelDestGroup(request));
}

StatusOr<google::cloud::iap::v1::TunnelDestGroup>
IdentityAwareProxyAdminServiceTracingConnection::UpdateTunnelDestGroup(
    google::cloud::iap::v1::UpdateTunnelDestGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "iap_v1::IdentityAwareProxyAdminServiceConnection::"
      "UpdateTunnelDestGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateTunnelDestGroup(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<iap_v1::IdentityAwareProxyAdminServiceConnection>
MakeIdentityAwareProxyAdminServiceTracingConnection(
    std::shared_ptr<iap_v1::IdentityAwareProxyAdminServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<IdentityAwareProxyAdminServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap_v1_internal
}  // namespace cloud
}  // namespace google
