// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/group_service.proto

#include "google/cloud/monitoring/v3/group_connection.h"
#include "google/cloud/monitoring/v3/group_options.h"
#include "google/cloud/monitoring/v3/internal/group_connection_impl.h"
#include "google/cloud/monitoring/v3/internal/group_option_defaults.h"
#include "google/cloud/monitoring/v3/internal/group_stub_factory.h"
#include "google/cloud/monitoring/v3/internal/group_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GroupServiceConnection::~GroupServiceConnection() = default;

StreamRange<google::monitoring::v3::Group> GroupServiceConnection::ListGroups(
    google::monitoring::v3::
        ListGroupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::monitoring::v3::Group>>();
}

StatusOr<google::monitoring::v3::Group> GroupServiceConnection::GetGroup(
    google::monitoring::v3::GetGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::monitoring::v3::Group> GroupServiceConnection::CreateGroup(
    google::monitoring::v3::CreateGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::monitoring::v3::Group> GroupServiceConnection::UpdateGroup(
    google::monitoring::v3::UpdateGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status GroupServiceConnection::DeleteGroup(
    google::monitoring::v3::DeleteGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::api::MonitoredResource>
GroupServiceConnection::ListGroupMembers(
    google::monitoring::v3::
        ListGroupMembersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::api::MonitoredResource>>();
}

std::shared_ptr<GroupServiceConnection> MakeGroupServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 GroupServicePolicyOptionList>(options,
                                                               __func__);
  options =
      monitoring_v3_internal::GroupServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = monitoring_v3_internal::CreateDefaultGroupServiceStub(
      background->cq(), options);
  return monitoring_v3_internal::MakeGroupServiceTracingConnection(
      std::make_shared<monitoring_v3_internal::GroupServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google
