// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/security/privateca/v1/service.proto

#include "google/cloud/privateca/v1/internal/certificate_authority_option_defaults.h"
#include "google/cloud/privateca/v1/certificate_authority_connection.h"
#include "google/cloud/privateca/v1/certificate_authority_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace privateca_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options CertificateAuthorityServiceDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options),
      "GOOGLE_CLOUD_CPP_CERTIFICATE_AUTHORITY_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_CERTIFICATE_AUTHORITY_SERVICE_AUTHORITY",
      "privateca.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options
           .has<privateca_v1::CertificateAuthorityServiceRetryPolicyOption>()) {
    options.set<privateca_v1::CertificateAuthorityServiceRetryPolicyOption>(
        privateca_v1::CertificateAuthorityServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<
          privateca_v1::CertificateAuthorityServiceBackoffPolicyOption>()) {
    options.set<privateca_v1::CertificateAuthorityServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<
          privateca_v1::CertificateAuthorityServicePollingPolicyOption>()) {
    options.set<privateca_v1::CertificateAuthorityServicePollingPolicyOption>(
        GenericPollingPolicy<
            privateca_v1::CertificateAuthorityServiceRetryPolicyOption::Type,
            privateca_v1::CertificateAuthorityServiceBackoffPolicyOption::Type>(
            options
                .get<privateca_v1::
                         CertificateAuthorityServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          privateca_v1::
              CertificateAuthorityServiceConnectionIdempotencyPolicyOption>()) {
    options.set<
        privateca_v1::
            CertificateAuthorityServiceConnectionIdempotencyPolicyOption>(
        privateca_v1::
            MakeDefaultCertificateAuthorityServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privateca_v1_internal
}  // namespace cloud
}  // namespace google
