// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/user_event_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_USER_EVENT_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_USER_EVENT_TRACING_CONNECTION_H

#include "google/cloud/retail/v2/user_event_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class UserEventServiceTracingConnection
    : public retail_v2::UserEventServiceConnection {
 public:
  ~UserEventServiceTracingConnection() override = default;

  explicit UserEventServiceTracingConnection(
      std::shared_ptr<retail_v2::UserEventServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::retail::v2::UserEvent> WriteUserEvent(
      google::cloud::retail::v2::WriteUserEventRequest const& request) override;

  StatusOr<google::api::HttpBody> CollectUserEvent(
      google::cloud::retail::v2::CollectUserEventRequest const& request)
      override;

  future<StatusOr<google::cloud::retail::v2::PurgeUserEventsResponse>>
  PurgeUserEvents(google::cloud::retail::v2::PurgeUserEventsRequest const&
                      request) override;

  future<StatusOr<google::cloud::retail::v2::ImportUserEventsResponse>>
  ImportUserEvents(google::cloud::retail::v2::ImportUserEventsRequest const&
                       request) override;

  future<StatusOr<google::cloud::retail::v2::RejoinUserEventsResponse>>
  RejoinUserEvents(google::cloud::retail::v2::RejoinUserEventsRequest const&
                       request) override;

 private:
  std::shared_ptr<retail_v2::UserEventServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<retail_v2::UserEventServiceConnection>
MakeUserEventServiceTracingConnection(
    std::shared_ptr<retail_v2::UserEventServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_USER_EVENT_TRACING_CONNECTION_H
