// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#include "google/cloud/speech/v1/adaptation_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace speech_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AdaptationClient::AdaptationClient(
    std::shared_ptr<AdaptationConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AdaptationClient::~AdaptationClient() = default;

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationClient::CreatePhraseSet(
    std::string const& parent,
    google::cloud::speech::v1::PhraseSet const& phrase_set,
    std::string const& phrase_set_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::CreatePhraseSetRequest request;
  request.set_parent(parent);
  *request.mutable_phrase_set() = phrase_set;
  request.set_phrase_set_id(phrase_set_id);
  return connection_->CreatePhraseSet(request);
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationClient::CreatePhraseSet(
    google::cloud::speech::v1::CreatePhraseSetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePhraseSet(request);
}

StatusOr<google::cloud::speech::v1::PhraseSet> AdaptationClient::GetPhraseSet(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::GetPhraseSetRequest request;
  request.set_name(name);
  return connection_->GetPhraseSet(request);
}

StatusOr<google::cloud::speech::v1::PhraseSet> AdaptationClient::GetPhraseSet(
    google::cloud::speech::v1::GetPhraseSetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPhraseSet(request);
}

StreamRange<google::cloud::speech::v1::PhraseSet>
AdaptationClient::ListPhraseSet(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::ListPhraseSetRequest request;
  request.set_parent(parent);
  return connection_->ListPhraseSet(request);
}

StreamRange<google::cloud::speech::v1::PhraseSet>
AdaptationClient::ListPhraseSet(
    google::cloud::speech::v1::ListPhraseSetRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPhraseSet(std::move(request));
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationClient::UpdatePhraseSet(
    google::cloud::speech::v1::PhraseSet const& phrase_set,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::UpdatePhraseSetRequest request;
  *request.mutable_phrase_set() = phrase_set;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePhraseSet(request);
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationClient::UpdatePhraseSet(
    google::cloud::speech::v1::UpdatePhraseSetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePhraseSet(request);
}

Status AdaptationClient::DeletePhraseSet(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::DeletePhraseSetRequest request;
  request.set_name(name);
  return connection_->DeletePhraseSet(request);
}

Status AdaptationClient::DeletePhraseSet(
    google::cloud::speech::v1::DeletePhraseSetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePhraseSet(request);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationClient::CreateCustomClass(
    std::string const& parent,
    google::cloud::speech::v1::CustomClass const& custom_class,
    std::string const& custom_class_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::CreateCustomClassRequest request;
  request.set_parent(parent);
  *request.mutable_custom_class() = custom_class;
  request.set_custom_class_id(custom_class_id);
  return connection_->CreateCustomClass(request);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationClient::CreateCustomClass(
    google::cloud::speech::v1::CreateCustomClassRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCustomClass(request);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationClient::GetCustomClass(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::GetCustomClassRequest request;
  request.set_name(name);
  return connection_->GetCustomClass(request);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationClient::GetCustomClass(
    google::cloud::speech::v1::GetCustomClassRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCustomClass(request);
}

StreamRange<google::cloud::speech::v1::CustomClass>
AdaptationClient::ListCustomClasses(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::ListCustomClassesRequest request;
  request.set_parent(parent);
  return connection_->ListCustomClasses(request);
}

StreamRange<google::cloud::speech::v1::CustomClass>
AdaptationClient::ListCustomClasses(
    google::cloud::speech::v1::ListCustomClassesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCustomClasses(std::move(request));
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationClient::UpdateCustomClass(
    google::cloud::speech::v1::CustomClass const& custom_class,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::UpdateCustomClassRequest request;
  *request.mutable_custom_class() = custom_class;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCustomClass(request);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationClient::UpdateCustomClass(
    google::cloud::speech::v1::UpdateCustomClassRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCustomClass(request);
}

Status AdaptationClient::DeleteCustomClass(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::speech::v1::DeleteCustomClassRequest request;
  request.set_name(name);
  return connection_->DeleteCustomClass(request);
}

Status AdaptationClient::DeleteCustomClass(
    google::cloud::speech::v1::DeleteCustomClassRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCustomClass(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1
}  // namespace cloud
}  // namespace google
