// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#include "google/cloud/speech/v1/adaptation_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace speech_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AdaptationConnectionIdempotencyPolicy::
    ~AdaptationConnectionIdempotencyPolicy() = default;

std::unique_ptr<AdaptationConnectionIdempotencyPolicy>
AdaptationConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AdaptationConnectionIdempotencyPolicy>(*this);
}

Idempotency AdaptationConnectionIdempotencyPolicy::CreatePhraseSet(
    google::cloud::speech::v1::CreatePhraseSetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AdaptationConnectionIdempotencyPolicy::GetPhraseSet(
    google::cloud::speech::v1::GetPhraseSetRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AdaptationConnectionIdempotencyPolicy::ListPhraseSet(
    google::cloud::speech::v1::ListPhraseSetRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AdaptationConnectionIdempotencyPolicy::UpdatePhraseSet(
    google::cloud::speech::v1::UpdatePhraseSetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AdaptationConnectionIdempotencyPolicy::DeletePhraseSet(
    google::cloud::speech::v1::DeletePhraseSetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AdaptationConnectionIdempotencyPolicy::CreateCustomClass(
    google::cloud::speech::v1::CreateCustomClassRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AdaptationConnectionIdempotencyPolicy::GetCustomClass(
    google::cloud::speech::v1::GetCustomClassRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AdaptationConnectionIdempotencyPolicy::ListCustomClasses(
    google::cloud::speech::v1::ListCustomClassesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AdaptationConnectionIdempotencyPolicy::UpdateCustomClass(
    google::cloud::speech::v1::UpdateCustomClassRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AdaptationConnectionIdempotencyPolicy::DeleteCustomClass(
    google::cloud::speech::v1::DeleteCustomClassRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<AdaptationConnectionIdempotencyPolicy>
MakeDefaultAdaptationConnectionIdempotencyPolicy() {
  return std::make_unique<AdaptationConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1
}  // namespace cloud
}  // namespace google
