// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/telcoautomation/v1/telcoautomation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TELCOAUTOMATION_V1_TELCO_AUTOMATION_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TELCOAUTOMATION_V1_TELCO_AUTOMATION_CONNECTION_H

#include "google/cloud/telcoautomation/v1/internal/telco_automation_retry_traits.h"
#include "google/cloud/telcoautomation/v1/telco_automation_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/telcoautomation/v1/telcoautomation.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace telcoautomation_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `TelcoAutomationConnection`.
class TelcoAutomationRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<TelcoAutomationRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `TelcoAutomationConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class TelcoAutomationLimitedErrorCountRetryPolicy
    : public TelcoAutomationRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit TelcoAutomationLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  TelcoAutomationLimitedErrorCountRetryPolicy(
      TelcoAutomationLimitedErrorCountRetryPolicy&& rhs) noexcept
      : TelcoAutomationLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  TelcoAutomationLimitedErrorCountRetryPolicy(
      TelcoAutomationLimitedErrorCountRetryPolicy const& rhs) noexcept
      : TelcoAutomationLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<TelcoAutomationRetryPolicy> clone() const override {
    return std::make_unique<TelcoAutomationLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = TelcoAutomationRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      telcoautomation_v1_internal::TelcoAutomationRetryTraits>
      impl_;
};

/**
 * A retry policy for `TelcoAutomationConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class TelcoAutomationLimitedTimeRetryPolicy
    : public TelcoAutomationRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit TelcoAutomationLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  TelcoAutomationLimitedTimeRetryPolicy(
      TelcoAutomationLimitedTimeRetryPolicy&& rhs) noexcept
      : TelcoAutomationLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  TelcoAutomationLimitedTimeRetryPolicy(
      TelcoAutomationLimitedTimeRetryPolicy const& rhs) noexcept
      : TelcoAutomationLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<TelcoAutomationRetryPolicy> clone() const override {
    return std::make_unique<TelcoAutomationLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = TelcoAutomationRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      telcoautomation_v1_internal::TelcoAutomationRetryTraits>
      impl_;
};

/**
 * The `TelcoAutomationConnection` object for `TelcoAutomationClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `TelcoAutomationClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `TelcoAutomationClient`.
 *
 * To create a concrete instance, see `MakeTelcoAutomationConnection()`.
 *
 * For mocking, see `telcoautomation_v1_mocks::MockTelcoAutomationConnection`.
 */
class TelcoAutomationConnection {
 public:
  virtual ~TelcoAutomationConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::telcoautomation::v1::OrchestrationCluster>
  ListOrchestrationClusters(
      google::cloud::telcoautomation::v1::ListOrchestrationClustersRequest
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>
  GetOrchestrationCluster(
      google::cloud::telcoautomation::v1::GetOrchestrationClusterRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>>
  CreateOrchestrationCluster(
      google::cloud::telcoautomation::v1::
          CreateOrchestrationClusterRequest const& request);

  virtual future<
      StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>
  DeleteOrchestrationCluster(
      google::cloud::telcoautomation::v1::
          DeleteOrchestrationClusterRequest const& request);

  virtual StreamRange<google::cloud::telcoautomation::v1::EdgeSlm> ListEdgeSlms(
      google::cloud::telcoautomation::v1::ListEdgeSlmsRequest request);

  virtual StatusOr<google::cloud::telcoautomation::v1::EdgeSlm> GetEdgeSlm(
      google::cloud::telcoautomation::v1::GetEdgeSlmRequest const& request);

  virtual future<StatusOr<google::cloud::telcoautomation::v1::EdgeSlm>>
  CreateEdgeSlm(
      google::cloud::telcoautomation::v1::CreateEdgeSlmRequest const& request);

  virtual future<
      StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>
  DeleteEdgeSlm(
      google::cloud::telcoautomation::v1::DeleteEdgeSlmRequest const& request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Blueprint>
  CreateBlueprint(
      google::cloud::telcoautomation::v1::CreateBlueprintRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Blueprint>
  UpdateBlueprint(
      google::cloud::telcoautomation::v1::UpdateBlueprintRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Blueprint> GetBlueprint(
      google::cloud::telcoautomation::v1::GetBlueprintRequest const& request);

  virtual Status DeleteBlueprint(
      google::cloud::telcoautomation::v1::DeleteBlueprintRequest const&
          request);

  virtual StreamRange<google::cloud::telcoautomation::v1::Blueprint>
  ListBlueprints(
      google::cloud::telcoautomation::v1::ListBlueprintsRequest request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Blueprint>
  ApproveBlueprint(
      google::cloud::telcoautomation::v1::ApproveBlueprintRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Blueprint>
  ProposeBlueprint(
      google::cloud::telcoautomation::v1::ProposeBlueprintRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Blueprint>
  RejectBlueprint(
      google::cloud::telcoautomation::v1::RejectBlueprintRequest const&
          request);

  virtual StreamRange<google::cloud::telcoautomation::v1::Blueprint>
  ListBlueprintRevisions(
      google::cloud::telcoautomation::v1::ListBlueprintRevisionsRequest
          request);

  virtual StreamRange<google::cloud::telcoautomation::v1::Blueprint>
  SearchBlueprintRevisions(
      google::cloud::telcoautomation::v1::SearchBlueprintRevisionsRequest
          request);

  virtual StreamRange<google::cloud::telcoautomation::v1::Deployment>
  SearchDeploymentRevisions(
      google::cloud::telcoautomation::v1::SearchDeploymentRevisionsRequest
          request);

  virtual StatusOr<
      google::cloud::telcoautomation::v1::DiscardBlueprintChangesResponse>
  DiscardBlueprintChanges(
      google::cloud::telcoautomation::v1::DiscardBlueprintChangesRequest const&
          request);

  virtual StreamRange<google::cloud::telcoautomation::v1::PublicBlueprint>
  ListPublicBlueprints(
      google::cloud::telcoautomation::v1::ListPublicBlueprintsRequest request);

  virtual StatusOr<google::cloud::telcoautomation::v1::PublicBlueprint>
  GetPublicBlueprint(
      google::cloud::telcoautomation::v1::GetPublicBlueprintRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Deployment>
  CreateDeployment(
      google::cloud::telcoautomation::v1::CreateDeploymentRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Deployment>
  UpdateDeployment(
      google::cloud::telcoautomation::v1::UpdateDeploymentRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Deployment>
  GetDeployment(
      google::cloud::telcoautomation::v1::GetDeploymentRequest const& request);

  virtual Status RemoveDeployment(
      google::cloud::telcoautomation::v1::RemoveDeploymentRequest const&
          request);

  virtual StreamRange<google::cloud::telcoautomation::v1::Deployment>
  ListDeployments(
      google::cloud::telcoautomation::v1::ListDeploymentsRequest request);

  virtual StreamRange<google::cloud::telcoautomation::v1::Deployment>
  ListDeploymentRevisions(
      google::cloud::telcoautomation::v1::ListDeploymentRevisionsRequest
          request);

  virtual StatusOr<
      google::cloud::telcoautomation::v1::DiscardDeploymentChangesResponse>
  DiscardDeploymentChanges(
      google::cloud::telcoautomation::v1::DiscardDeploymentChangesRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Deployment>
  ApplyDeployment(
      google::cloud::telcoautomation::v1::ApplyDeploymentRequest const&
          request);

  virtual StatusOr<
      google::cloud::telcoautomation::v1::ComputeDeploymentStatusResponse>
  ComputeDeploymentStatus(
      google::cloud::telcoautomation::v1::ComputeDeploymentStatusRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::Deployment>
  RollbackDeployment(
      google::cloud::telcoautomation::v1::RollbackDeploymentRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
  GetHydratedDeployment(
      google::cloud::telcoautomation::v1::GetHydratedDeploymentRequest const&
          request);

  virtual StreamRange<google::cloud::telcoautomation::v1::HydratedDeployment>
  ListHydratedDeployments(
      google::cloud::telcoautomation::v1::ListHydratedDeploymentsRequest
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
  UpdateHydratedDeployment(
      google::cloud::telcoautomation::v1::UpdateHydratedDeploymentRequest const&
          request);

  virtual StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
  ApplyHydratedDeployment(
      google::cloud::telcoautomation::v1::ApplyHydratedDeploymentRequest const&
          request);
};

/**
 * A factory function to construct an object of type
 * `TelcoAutomationConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of TelcoAutomationClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `TelcoAutomationConnection`. Expected options are any of the types
 * in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::telcoautomation_v1::TelcoAutomationPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `TelcoAutomationConnection` created
 * by this function.
 */
std::shared_ptr<TelcoAutomationConnection> MakeTelcoAutomationConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace telcoautomation_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TELCOAUTOMATION_V1_TELCO_AUTOMATION_CONNECTION_H
