// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/transcoder/v1/services.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_TRANSCODER_V1_TRANSCODER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_TRANSCODER_V1_TRANSCODER_CLIENT_H

#include "google/cloud/video/transcoder/v1/transcoder_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace video_transcoder_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Using the Transcoder API, you can queue asynchronous jobs for transcoding
/// media into various output formats. Output formats may include different
/// streaming standards such as HTTP Live Streaming (HLS) and Dynamic Adaptive
/// Streaming over HTTP (DASH). You can also customize jobs using advanced
/// features such as Digital Rights Management (DRM), audio equalization,
/// content concatenation, and digital ad-stitch ready content generation.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class TranscoderServiceClient {
 public:
  explicit TranscoderServiceClient(
      std::shared_ptr<TranscoderServiceConnection> connection,
      Options opts = {});
  ~TranscoderServiceClient();

  ///@{
  /// @name Copy and move support
  TranscoderServiceClient(TranscoderServiceClient const&) = default;
  TranscoderServiceClient& operator=(TranscoderServiceClient const&) = default;
  TranscoderServiceClient(TranscoderServiceClient&&) = default;
  TranscoderServiceClient& operator=(TranscoderServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(TranscoderServiceClient const& a,
                         TranscoderServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(TranscoderServiceClient const& a,
                         TranscoderServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a job in the specified region.
  ///
  /// @param parent  Required. The parent location to create and process this job.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param job  Required. Parameters for creating transcoding job.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.transcoder.v1.Job])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.CreateJobRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L116}
  /// [google.cloud.video.transcoder.v1.Job]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::video::transcoder::v1::Job> CreateJob(
      std::string const& parent,
      google::cloud::video::transcoder::v1::Job const& job, Options opts = {});

  // clang-format off
  ///
  /// Creates a job in the specified region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.transcoder.v1.CreateJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.transcoder.v1.Job])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.CreateJobRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L116}
  /// [google.cloud.video.transcoder.v1.Job]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::video::transcoder::v1::Job> CreateJob(
      google::cloud::video::transcoder::v1::CreateJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists jobs in the specified region.
  ///
  /// @param parent  Required. Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.transcoder.v1.Job], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.Job]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L31}
  /// [google.cloud.video.transcoder.v1.ListJobsRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L132}
  ///
  // clang-format on
  StreamRange<google::cloud::video::transcoder::v1::Job> ListJobs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists jobs in the specified region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.transcoder.v1.ListJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.transcoder.v1.Job], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.Job]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L31}
  /// [google.cloud.video.transcoder.v1.ListJobsRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L132}
  ///
  // clang-format on
  StreamRange<google::cloud::video::transcoder::v1::Job> ListJobs(
      google::cloud::video::transcoder::v1::ListJobsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the job data.
  ///
  /// @param name  Required. The name of the job to retrieve.
  ///  Format: `projects/{project}/locations/{location}/jobs/{job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.transcoder.v1.Job])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.GetJobRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L158}
  /// [google.cloud.video.transcoder.v1.Job]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::video::transcoder::v1::Job> GetJob(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the job data.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.transcoder.v1.GetJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.transcoder.v1.Job])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.GetJobRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L158}
  /// [google.cloud.video.transcoder.v1.Job]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::video::transcoder::v1::Job> GetJob(
      google::cloud::video::transcoder::v1::GetJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a job.
  ///
  /// @param name  Required. The name of the job to delete.
  ///  Format: `projects/{project}/locations/{location}/jobs/{job}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.DeleteJobRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L168}
  ///
  // clang-format on
  Status DeleteJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.transcoder.v1.DeleteJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.DeleteJobRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L168}
  ///
  // clang-format on
  Status DeleteJob(
      google::cloud::video::transcoder::v1::DeleteJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a job template in the specified region.
  ///
  /// @param parent  Required. The parent location to create this job template.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param job_template  Required. Parameters for creating job template.
  /// @param job_template_id  Required. The ID to use for the job template, which will become the final
  ///  component of the job template's resource name.
  ///  @n
  ///  This value should be 4-63 characters, and valid characters must match the
  ///  regular expression `[a-zA-Z][a-zA-Z0-9_-]*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.transcoder.v1.JobTemplate])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.CreateJobTemplateRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L194}
  /// [google.cloud.video.transcoder.v1.JobTemplate]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L162}
  ///
  // clang-format on
  StatusOr<google::cloud::video::transcoder::v1::JobTemplate> CreateJobTemplate(
      std::string const& parent,
      google::cloud::video::transcoder::v1::JobTemplate const& job_template,
      std::string const& job_template_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a job template in the specified region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.transcoder.v1.CreateJobTemplateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.transcoder.v1.JobTemplate])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.CreateJobTemplateRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L194}
  /// [google.cloud.video.transcoder.v1.JobTemplate]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L162}
  ///
  // clang-format on
  StatusOr<google::cloud::video::transcoder::v1::JobTemplate> CreateJobTemplate(
      google::cloud::video::transcoder::v1::CreateJobTemplateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists job templates in the specified region.
  ///
  /// @param parent  Required. The parent location from which to retrieve the collection of job
  ///  templates. Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.transcoder.v1.JobTemplate], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.JobTemplate]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L162}
  /// [google.cloud.video.transcoder.v1.ListJobTemplatesRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L216}
  ///
  // clang-format on
  StreamRange<google::cloud::video::transcoder::v1::JobTemplate>
  ListJobTemplates(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists job templates in the specified region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.transcoder.v1.ListJobTemplatesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.transcoder.v1.JobTemplate], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.JobTemplate]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L162}
  /// [google.cloud.video.transcoder.v1.ListJobTemplatesRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L216}
  ///
  // clang-format on
  StreamRange<google::cloud::video::transcoder::v1::JobTemplate>
  ListJobTemplates(
      google::cloud::video::transcoder::v1::ListJobTemplatesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the job template data.
  ///
  /// @param name  Required. The name of the job template to retrieve.
  ///  Format:
  ///  `projects/{project}/locations/{location}/jobTemplates/{job_template}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.transcoder.v1.JobTemplate])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.GetJobTemplateRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L243}
  /// [google.cloud.video.transcoder.v1.JobTemplate]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L162}
  ///
  // clang-format on
  StatusOr<google::cloud::video::transcoder::v1::JobTemplate> GetJobTemplate(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the job template data.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.transcoder.v1.GetJobTemplateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.transcoder.v1.JobTemplate])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.GetJobTemplateRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L243}
  /// [google.cloud.video.transcoder.v1.JobTemplate]: @googleapis_reference_link{google/cloud/video/transcoder/v1/resources.proto#L162}
  ///
  // clang-format on
  StatusOr<google::cloud::video::transcoder::v1::JobTemplate> GetJobTemplate(
      google::cloud::video::transcoder::v1::GetJobTemplateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a job template.
  ///
  /// @param name  Required. The name of the job template to delete.
  ///  `projects/{project}/locations/{location}/jobTemplates/{job_template}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.DeleteJobTemplateRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L256}
  ///
  // clang-format on
  Status DeleteJobTemplate(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a job template.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.transcoder.v1.DeleteJobTemplateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.transcoder.v1.DeleteJobTemplateRequest]: @googleapis_reference_link{google/cloud/video/transcoder/v1/services.proto#L256}
  ///
  // clang-format on
  Status DeleteJobTemplate(
      google::cloud::video::transcoder::v1::DeleteJobTemplateRequest const&
          request,
      Options opts = {});

 private:
  std::shared_ptr<TranscoderServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_transcoder_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_TRANSCODER_V1_TRANSCODER_CLIENT_H
