/* LocaleInformation_ro.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_ro extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "ROL";

  private static final String currenciesDisplayNameValues = "ROL";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "ROL";

  private static final String currenciesSymbolValues = "lei";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Ian",
    "Feb",
    "Mar",
    "Apr",
    "Mai",
    "Iun",
    "Iul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
    null,
  };

  private static final String[] months = {
    "ianuarie",
    "februarie",
    "martie",
    "aprilie",
    "mai",
    "iunie",
    "iulie",
    "august",
    "septembrie",
    "octombrie",
    "noiembrie",
    "decembrie",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "D",
    "L",
    "Ma",
    "Mi",
    "J",
    "V",
    "S",
  };

  private static final String[] weekdays = {
    null,
    "duminic\u0103",
    "luni",
    "mar\u0163i",
    "miercuri",
    "joi",
    "vineri",
    "s\u00eemb\u0103t\u0103",
  };

  private static final String[] eras = {
    "d.C.",
    "\u00ee.d.C.",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Timorul de Est|Tokelau|Tadjikistan|Tailanda|Togo|Teritoriile Franceze de Sud|Guyana|Ciad|Insulele Turks \u015fi Caicos|Guineea-Bissau|Guam|Guatemala|Insulele South Georgia \u015fi South Sandwich|Grecia|Guineea Ecuatorial\u0103|Guadeloupe|Swaziland|Siria|Guineea|Gambia|Groenlanda|El Salvador|Sao Tome \u015fi Principe|Gibraltar|Ghana|Surinam|Guyana Francez\u0103|Serbia|Georgia|Somalia|Grenada|Senegal|San Marino|Marea Britanie|Sierra Leone|Gabon|Slovacia|Svalbard \u015fi Jan Mayen|Slovenia|Saint Helena|Singapore|Suedia|Sudan|Seychelles|Insulele Solomon|Arabia Saudit\u0103|Fran\u0163a|Insulele Feroe|Micronezia, Statele Federate|Rwanda|Insulele Falkland|Rusia|Fiji|Finlanda|Rom\u00e2nia|Reunion|Etiopia|Spania|Eritrea|Sahara de Vest|Egipt|Estonia|Ecuador|Algeria|Qatar|Republica Dominican\u0103|Paraguay|Dominica|Palau|Danemarca|Djibouti|Portugalia|Teritoriul Palestinian|Porto Rico|Germania|Pitcairn|Saint Pierre \u015fi Miquelon|Polonia|Pakistan|Filipine|Papua Noua Guinee|Polinezia Francez\u0103|Republica Ceh\u0103|Peru|Cipru|Insula Christmas|Capul Verde|Panama|Cuba|Costa Rica|Columbia|China|Camerun|Chile|Insulele Cook|Coasta de Filde\u015f|Eleve\u0163ia|Congo|Republica Central African\u0103|Congo, Republica Democratic\u0103|Insulele Cocos (Keeling)|Oman|Canada|Belize|Bielorusia|Botswana|Insula Bouvet|Bhutan|Bahamas|Brazilia|Noua Zeeland\u0103|Bolivia|Brunei|Bermuda|Niue|Benin|Burundi|Bahrain|Nauru|Bulgaria|Burkina Faso|Nepal|Belgia|Norvegia|Bangladesh|Barbados|Zimbabwe|Olanda|Bosnia \u015fi Herzegovina|Nicaragua|Nigeria|Insulele Norfolk|Azerbaidjan|Niger|Noua Caledonie|Aruba|Zambia|Namibia|Australia|Austria|Samoa American\u0103|Argentina|Antarctica|Mozambic|Angola|Malaezia|Antilele Olandeze|Mexic|Armenia|Malawi|Albania|Maldive|Africa de Sud|Mauritius|Malta|Anguilla|Montserrat|Mauritania|Antigua \u015fi Barbuda|Martinica|Afganistan|Insulele Northern Mariana|Emiratele Arabe Unite|R.A.S. Macao a Chinei|Andora|Mongolia|Myanmar|Mali|Macedonia|Iugoslavia|Mayotte|Insulele Marshall|Madagascar|Moldova, Republica|Monaco|Maroc|Yemen|Libia, Jamahiriya Arab\u0103|Letonia|Luxemburg|Lituania|Lesotho|Liberia|Sri Lanka|Liechtenstein|Saint Lucia|Liban|Lao, Republica Democratic\u0103 Popular\u0103|Kazahstan|Insulele Cayman|Kuweit|Coreea de Sud|Coreea de Nord|Saint Kitts \u015fi Nevis|Comoros|Kiribati|Samoa|Cambodgia|Kirghizia|Kenya|Wallis \u015fi Futuna|Japonia|Iordania|Jamaica|Vanuatu|Vietnam|Insulele Virgine S.U.A.|Insulele Virgine Britanice|Venezuela|Saint Vincent \u015fi Grenadines|Sf\u00e2ntul Scaun (Statul Vatican)|Italia|Islanda|Iran|Iraq|Uzbekistan|Teritoriile Britanice din Oceanul Indian|Uruguay|India|Israel|Statele Unite|Irlanda|Indonezia|United States Minor Outlying Islands|Uganda|Ucraina|Ungaria|Haiti|Croa\u0163ia|Tanzania|Honduras|Insula Heard \u015fi Insulele McDonald|Taiwan|Tuvalu|R.A.S. Hong Kong a Chinei|Trinidad \u015fi Tobago|Turcia|Tonga|Tunisia|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ja|en|tr|ko|no|el|nl|bg|lv|he|cs|it|lt|fr|zh|ru|ro|fi|ar|sv|pt|pl|sl|sk|de|hu|et|es|hr|da";

  private static final String languagesValues = "Japonez\u0103|Englez\u0103|Turc\u0103|Coreean\u0103|Norvegian\u0103|Greac\u0103|Olandez\u0103|Bulgar\u0103|Leton\u0103|Ebraic\u0103|Ceh\u0103|Italian\u0103|Lituanian\u0103|Francez\u0103|Chinez\u0103|Rus\u0103|Rom\u00e2n\u0103|Finlandez\u0103|Arab\u0103|Suedez\u0103|Portughez\u0103|Polonez\u0103|Sloven\u0103|Slovac\u0103|German\u0103|Maghiar\u0103|Estonian\u0103|Spaniol\u0103|Croat\u0103|Danez\u0103";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd.MM.yyyy" },
    { "mediumDateFormat", "dd.MM.yyyy" },
    { "longDateFormat", "d MMMM yyyy" },
    { "fullDateFormat", "d MMMM yyyy" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
