/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class DSPFReader
extends Input<Object> {
    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.parseDSPFFile(null);
        return null;
    }

    DSPFReader(EditingPreferences ep, DSPFReaderPreferences prefs) {
        super(ep);
    }

    public DSPFData readDSPFFile(String file, Cell cell) {
        URL fileURL = TextUtils.makeURLToFile(file);
        if (this.openTextInput(fileURL)) {
            System.out.println("Cannot open the DSPF file: " + file);
            return null;
        }
        System.out.println("Reading DSPF file: " + file);
        return this.parseDSPFFile(cell);
    }

    public DSPFData parseDSPFFile(Cell cell) {
        this.initKeywordParsing();
        DSPFReader.setProgressValue(0);
        DSPFReader.setProgressNote("Reading DSPF file");
        DSPFData parseData = new DSPFData(cell);
        HashMap<String, DSPFNet> netsMap = new HashMap<String, DSPFNet>();
        HashMap<String, DSPNode> portsMap = new HashMap<String, DSPNode>();
        try {
            String nextToken = null;
            String key = null;
            while (true) {
                if (nextToken != null) {
                    key = nextToken;
                    nextToken = null;
                } else {
                    key = this.getAKeyword();
                }
                if (key != null && !key.toUpperCase().equals(".ENDS")) {
                    String option;
                    if (key.equals("*|DSPF")) {
                        option = this.processOption(key);
                        if (option == null) {
                            return null;
                        }
                        parseData.dspfDesign = option;
                        continue;
                    }
                    if (key.equals("*|DESIGN")) {
                        option = this.processOption(key);
                        if (option == null) {
                            return null;
                        }
                        parseData.dspfVersion = option;
                        continue;
                    }
                    if (key.equals("*|VENDOR")) {
                        option = this.processOption(key);
                        if (option == null) {
                            return null;
                        }
                        parseData.dspfVendor = option;
                        continue;
                    }
                    if (key.equals("*|DIVIDER")) {
                        option = this.processOption(key);
                        if (option == null) {
                            return null;
                        }
                        parseData.dspfDivider = option;
                        continue;
                    }
                    if (key.equals("*|DELIMITER")) {
                        option = this.processOption(key);
                        if (option == null) {
                            return null;
                        }
                        parseData.dspfDelimiter = option;
                        continue;
                    }
                    if (key.equals("*|BUSBIT")) {
                        option = this.processOption(key);
                        if (option == null) {
                            return null;
                        }
                        parseData.dspfBusbit = option;
                        continue;
                    }
                    if (key.equals("*|GROUND_NET")) {
                        option = this.processOption(key);
                        if (option == null) {
                            return null;
                        }
                        parseData.groundNet = parseData.currentSubckt.getNetwork(option);
                        parseData.groundNet.addExport(option, 0.0, PortCharacteristic.GND, null);
                        continue;
                    }
                    if (key.toUpperCase().equals(".SUBCKT")) {
                        nextToken = this.readSubCircuit(parseData, netsMap);
                        continue;
                    }
                    if (key.equals("*|NET")) {
                        nextToken = this.readNetwork(parseData, portsMap);
                        continue;
                    }
                    if (key.equals("+")) continue;
                    if (key.toUpperCase().startsWith("X")) {
                        String instName = key.substring(1, key.length());
                        nextToken = this.readInstance(parseData, instName, portsMap);
                        continue;
                    }
                    if (key.toUpperCase().startsWith(".GLOBAL")) {
                        this.getRestOfLine();
                        continue;
                    }
                    if (key.startsWith("CC")) {
                        String line = this.getRestOfLine();
                        new StringTokenizer(line, " ", false);
                        assert (false);
                        continue;
                    }
                    if (!key.startsWith("*")) assert (key.startsWith("*"));
                    this.getRestOfLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR reading DSPF technology file");
        }
        return parseData;
    }

    private String processOption(String key) throws IOException {
        String option = this.getRestOfLine();
        if (option == null) {
            this.eofDuring(key);
        }
        return option;
    }

    private String readSubCircuit(DSPFData parseData, HashMap<String, DSPFNet> netsMap) throws IOException {
        ArrayList<String> tokens = new ArrayList<String>(10);
        String key;
        while ((key = this.getAKeyword()) != null) {
            if (key.startsWith("+")) continue;
            if (key.startsWith("*")) {
                assert (parseData.currentSubckt == null);
                DSPFSubckt subckt = parseData.addSubCircuit((String)tokens.get(0));
                for (int i = 1; i < tokens.size(); ++i) {
                    String name = (String)tokens.get(i);
                    DSPFNet net = subckt.addNetwork(name);
                    assert (netsMap.get(name) == null);
                    netsMap.put(name, net);
                }
                return key;
            }
            tokens.add(key);
        }
        return key;
    }

    private String readNetwork(DSPFData parseData, HashMap<String, DSPNode> portsMap) throws IOException {
        String key = this.getAKeyword();
        String netName = TextUtils.correctName(key, false, true);
        DSPFNet net = parseData.currentSubckt.getNetwork(netName);
        assert (net != null);
        net.setCap(TextUtils.atof(this.getAKeyword()));
        DSPPort gndPort = parseData.groundNet.getExport(0);
        while (true) {
            if ((key = this.getAKeyword()).equals("*|I")) {
                this.readPinInstance(net, portsMap);
                continue;
            }
            if (key.equals("*|P")) {
                this.readPin(net);
                continue;
            }
            if (key.equals("*|S")) {
                this.readSubnet(net);
                continue;
            }
            if (key.startsWith("CC")) {
                return key;
            }
            if (key.startsWith("C")) {
                this.readParasitic(key, net, ParasiticType.C, gndPort);
                continue;
            }
            if (key.startsWith("R")) {
                this.readParasitic(key, net, ParasiticType.R, gndPort);
                continue;
            }
            if (key.equals("*|NET") || key.startsWith("X") || key.toUpperCase().equals(".ENDS")) {
                return key;
            }
            if (key.startsWith("*")) {
                this.getRestOfLine();
                continue;
            }
            System.out.println("The key here " + key);
            if (Job.getDebug()) assert (false);
            this.getRestOfLine();
        }
    }

    private PortCharacteristic getPortPortCharacteristic(String name) {
        if (name.equals("I")) {
            return PortCharacteristic.IN;
        }
        if (name.equals("O")) {
            return PortCharacteristic.OUT;
        }
        if (name.equals("B")) {
            return PortCharacteristic.BIDIR;
        }
        if (name.equals("X")) {
            return PortCharacteristic.UNKNOWN;
        }
        assert (false);
        return null;
    }

    private void readPinInstance(DSPFNet net, HashMap<String, DSPNode> portsMap) throws IOException {
        String values = this.getRestOfLine();
        StringTokenizer parse = new StringTokenizer(values, "( )", false);
        String instPinName = null;
        String instName = null;
        String pinName = null;
        PortCharacteristic pinType = PortCharacteristic.UNKNOWN;
        double pinCap = 0.0;
        double xCoord = 0.0;
        double yCoord = 0.0;
        int count = 0;
        while (parse.hasMoreTokens()) {
            String value = parse.nextToken();
            switch (count) {
                case 0: {
                    instPinName = TextUtils.correctName(value, false, true);
                    break;
                }
                case 1: {
                    instName = TextUtils.correctName(value, false, true);
                    break;
                }
                case 2: {
                    pinName = value;
                    break;
                }
                case 3: {
                    pinType = this.getPortPortCharacteristic(value);
                    break;
                }
                case 4: {
                    pinCap = TextUtils.atof(value);
                    break;
                }
                case 5: {
                    xCoord = TextUtils.atof(value);
                    break;
                }
                case 6: {
                    yCoord = TextUtils.atof(value);
                }
            }
            ++count;
        }
        DSPFPortInst port = net.addPortInst(instPinName, instName, pinName, pinCap, pinType, EPoint.fromLambda(xCoord, yCoord));
        portsMap.put(instPinName, port);
    }

    private void readPin(DSPFNet net) throws IOException {
        String values = this.getRestOfLine();
        StringTokenizer parse = new StringTokenizer(values, "( )", false);
        String pinName = null;
        PortCharacteristic pinType = PortCharacteristic.UNKNOWN;
        double pinCap = 0.0;
        double xCoord = 0.0;
        double yCoord = 0.0;
        int count = 0;
        while (parse.hasMoreTokens()) {
            String value = parse.nextToken();
            switch (count) {
                case 0: {
                    pinName = value;
                    break;
                }
                case 1: {
                    pinType = this.getPortPortCharacteristic(value);
                    break;
                }
                case 2: {
                    pinCap = TextUtils.atof(value);
                    break;
                }
                case 3: {
                    xCoord = TextUtils.atof(value);
                    break;
                }
                case 4: {
                    yCoord = TextUtils.atof(value);
                }
            }
            ++count;
        }
        net.addExport(pinName, pinCap, pinType, EPoint.fromLambda(xCoord, yCoord));
    }

    private void readParasitic(String name, DSPFNet net, ParasiticType type, DSPPort groundPort) throws IOException {
        String values = this.getRestOfLine();
        StringTokenizer parse = new StringTokenizer(values, " ", false);
        String pin1 = null;
        String pin2 = null;
        double parasitic = 0.0;
        int count = 0;
        while (parse.hasMoreTokens()) {
            String value = parse.nextToken();
            switch (count) {
                case 0: {
                    pin1 = TextUtils.correctName(value, false, true);
                    break;
                }
                case 1: {
                    pin2 = TextUtils.correctName(value, false, true);
                    break;
                }
                case 2: {
                    parasitic = TextUtils.atof(value);
                }
            }
            ++count;
        }
        net.addParasitics(name, pin1, pin2, groundPort, parasitic, type);
    }

    private void readSubnet(DSPFNet net) throws IOException {
        String values = this.getRestOfLine();
        StringTokenizer parse = new StringTokenizer(values, "( )", false);
        String subnodeName = null;
        double xCoord = 0.0;
        double yCoord = 0.0;
        int count = 0;
        while (parse.hasMoreTokens()) {
            String value = parse.nextToken();
            switch (count) {
                case 0: {
                    subnodeName = value;
                    break;
                }
                case 1: {
                    xCoord = TextUtils.atof(value);
                    break;
                }
                case 2: {
                    yCoord = TextUtils.atof(value);
                }
            }
            ++count;
        }
        net.addSubnet(subnodeName, EPoint.fromLambda(xCoord, yCoord));
    }

    private String readInstance(DSPFData parseData, String instName, HashMap<String, DSPNode> portsMap) throws IOException {
        String key;
        DSPFInstance instance = parseData.currentSubckt.addInstance(instName);
        while (true) {
            if ((key = this.getAKeyword()) == null) {
                return key;
            }
            if (key.startsWith("+")) {
                String portName = this.processOption(key);
                DSPNode port = portsMap.get(portName);
                if (port == null) {
                    port = new DSPNode(portName, null);
                    portsMap.put(portName, port);
                }
                instance.addPort(port);
                continue;
            }
            if (key.startsWith("X")) break;
        }
        return key;
    }

    public static class DSPFData {
        Cell cell;
        String dspfDesign;
        String dspfVendor;
        String dspfVersion;
        String dspfDivider;
        String dspfDelimiter;
        String dspfBusbit;
        DSPFNet groundNet;
        DSPFSubckt currentSubckt;
        List<DSPFSubckt> subckts;

        DSPFData(Cell c) {
            this.cell = c;
            this.subckts = new ArrayList<DSPFSubckt>();
        }

        DSPFSubckt addSubCircuit(String name) {
            assert (this.subckts.size() == 0);
            DSPFSubckt tmp = new DSPFSubckt(name);
            this.subckts.add(tmp);
            this.currentSubckt = tmp;
            return tmp;
        }
    }

    static class DSPFSubckt {
        String name;
        List<DSPFNet> nets = new ArrayList<DSPFNet>();
        List<DSPFInstance> instances = new ArrayList<DSPFInstance>();

        DSPFSubckt(String n) {
            this.name = n;
        }

        DSPFNet addNetwork(String netName) {
            assert (this.findNetwork(netName) == null);
            DSPFNet net = new DSPFNet(netName);
            this.nets.add(net);
            return net;
        }

        DSPFNet findNetwork(String netName) {
            for (DSPFNet net : this.nets) {
                if (!net.name.equals(netName)) continue;
                return net;
            }
            return null;
        }

        DSPFNet getNetwork(String netName) {
            for (DSPFNet net : this.nets) {
                if (!net.name.equals(netName)) continue;
                return net;
            }
            return this.addNetwork(netName);
        }

        DSPFInstance addInstance(String instName) {
            DSPFInstance newI = new DSPFInstance(instName);
            this.instances.add(newI);
            return newI;
        }
    }

    static class DSPFNet {
        String name;
        float netCap;
        Map<String, DSPFPortInst> portInstancesN = new HashMap<String, DSPFPortInst>();
        Map<String, DSPPort> portsN = new HashMap<String, DSPPort>();
        Map<String, DSPNode> subnetsN = new HashMap<String, DSPNode>();
        List<DSPFParaElem> parasitics = new ArrayList<DSPFParaElem>();

        DSPFNet(String n) {
            this.name = n;
        }

        public void setCap(double c) {
            this.netCap = (float)c;
        }

        DSPFPortInst addPortInst(String instPinName, String instName, String pinName, double pinCap, PortCharacteristic pinType, EPoint point) {
            DSPFPortInst inst = new DSPFPortInst(instPinName, instName, pinName, pinCap, pinType, point);
            this.portInstancesN.put(instPinName, inst);
            return inst;
        }

        DSPPort getExport(int i) {
            return (DSPPort)this.portsN.values().toArray()[i];
        }

        DSPPort addExport(String pinName, double pinCap, PortCharacteristic pinType, EPoint point) {
            DSPPort port = new DSPPort(pinName, pinCap, pinType, point);
            this.portsN.put(pinName, port);
            return port;
        }

        DSPNode addSubnet(String subnodeName, EPoint point) {
            DSPNode sub = new DSPNode(subnodeName, point);
            this.subnetsN.put(subnodeName, sub);
            return sub;
        }

        DSPNode findNet(String netName, DSPNode groundPort) {
            DSPNode newPa = this.subnetsN.get(netName);
            if (newPa != null) {
                return newPa;
            }
            newPa = this.portInstancesN.get(netName);
            if (newPa != null) {
                return newPa;
            }
            newPa = this.portsN.get(netName);
            if (newPa != null) {
                return newPa;
            }
            if (groundPort.name.equals(this.name)) {
                return groundPort;
            }
            newPa = this.addSubnet(this.name, null);
            return newPa;
        }

        void addParasitics(String paramName, String pin1, String pin2, DSPPort groundPort, double parasitic, ParasiticType type) {
            DSPNode port1 = this.findNet(pin1, groundPort);
            DSPNode port2 = this.findNet(pin2, groundPort);
            DSPFParaElem par = new DSPFParaElem(paramName, port1, port2, parasitic, type);
            this.parasitics.add(par);
        }
    }

    static class DSPPort
    extends DSPNode {
        float cap;
        PortCharacteristic type;

        DSPPort(String n, double c, PortCharacteristic t, EPoint p) {
            super(n, p);
            this.cap = (float)c;
            this.type = t;
        }
    }

    public static enum ParasiticType {
        C,
        R,
        CC;

    }

    static class DSPFPortInst
    extends DSPPort {
        String instName;
        String pinName;

        DSPFPortInst(String n, String i, String p, double c, PortCharacteristic t, EPoint pt) {
            super(n, c, t, pt);
            this.instName = i;
            this.pinName = p;
        }
    }

    static class DSPNode {
        String name;
        EPoint point;

        DSPNode(String n, EPoint p) {
            this.name = n;
            this.point = p;
        }
    }

    static class DSPFInstance {
        String name;
        List<DSPNode> ports = new ArrayList<DSPNode>();

        DSPFInstance(String n) {
            this.name = n;
        }

        void addPort(DSPNode p) {
            this.ports.add(p);
        }
    }

    static class DSPFParaElem {
        DSPNode pin1;
        DSPNode pin2;
        ParasiticType type;

        DSPFParaElem(String n, DSPNode s1, DSPNode s2, double v, ParasiticType t) {
            this.pin1 = s1;
            this.pin2 = s2;
            this.type = t;
        }
    }

    static class DSPFReaderPreferences
    extends Input.InputPreferences {
        public DSPFReaderPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            DSPFReader in = new DSPFReader(ep, this);
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }
    }
}

