/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.parsers.Parser;

public class DoubleParser
implements Parser {
    private final Field targetField;

    public DoubleParser(Field f) {
        this.targetField = f;
    }

    @Override
    public int getSize(Message srcObj) {
        return 8;
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        double d = srcBuf.getDouble();
        try {
            this.targetField.setDouble(dstObj, d);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)"cannot access field (should have been caught in Construct)");
        }
        return 8;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message srcObj) {
        double d;
        try {
            d = this.targetField.getDouble(srcObj);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)"field does not exist (should be caught in Construct)");
        }
        dstBuf.putDouble(d);
        return 8;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
    }

    @Override
    public int getStaticSize() {
        return 8;
    }
}

