# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from i18n import _, _i

import gtk
import GDK

SHORT_WAIT = 700
NORMAL_WAIT = 2000

USE_CHORD = 'chord'
USE_HARMONY = 'harmony'
USE_ID_BY_NAME = 'id-by-name'
USE_DICTATION = 'dictation'
USE_SING_CHORD = 'sing-chord'

# These are the exercises that are available as icons on the toolbar
# and listed on the _File menu. 
# The list should have another name. Also, if the number of exercises
# increase, it should be configurable what exercises are available
# from the toolbar.
exercises = ('chord',
             'harmonic-intervall',
             'melodic-intervall',
             'sing-intervall',
             'identify-scale',
             'id-by-name',
             'dictation',
             'twelve-tone',
             'id-tone',
             'compare-intervalls',
             'sing-chord',
             'rhythm')

exercisedata = {
   # id: prettyname, menulabel, pixmap
    'chord': (_("_Chords"), 'chord24.xpm', GDK.F2, 0),
    'harmonic-intervall': (_("_Harmonic intervalls"),
        'harmonicintervall24.xpm', GDK.F3, 0),
    'melodic-intervall': (_("_Melodic intervalls"),
        'melodicintervall24.xpm', GDK.F4, 0),
    'sing-intervall': (_("_Sing intervall"), 'singintervall24.xpm', GDK.F5, 0),
    'identify-scale': (_("_Identify scale"), 'identifyscale24.xpm', GDK.F6, 0),
    'id-by-name': (_("Identify by _name"), 'idbyname24.xpm', GDK.F7, 0),
    'dictation': (_("_Dictation"), 'dictation24.xpm', GDK.F8, 0),
    'harmonic-progression-dictation': (_("Harmonic _progression dictation"),
        'harmonicprogression24.xpm', GDK.F9, 0),
    'twelve-tone': (_("Sing _twelvetone"), 'twelvetone24.xpm', GDK.F10, 0),
    'id-tone': (_("Id_entify tone"), 'idtone24.xpm', GDK.F2, GDK.CONTROL_MASK),
    'compare-intervalls': (_("C_ompare intervalls"),
        'compareintervalls24.xpm', GDK.F3, GDK.CONTROL_MASK),
    'sing-chord': (_("Sin_g chord"),
        'singchord24.xpm', GDK.F4, GDK.CONTROL_MASK),
    'rhythm': (_("Rh_ythm"), 'rhythm24.xpm', GDK.F5, GDK.CONTROL_MASK),
    'polyrhythm': ("_Polyrhythmic", "", GDK.F6, GDK.CONTROL_MASK),
    'identify-bpm': ("Bpm", "", None, None),
    'intervalls': ("Intervall", "", None, None),
    'tuner': ("Tuner", "", None, None),
}


QSTATUS_NO = 0
QSTATUS_NEW = 1
QSTATUS_WRONG = 2
QSTATUS_SOLVED = 3
QSTATUS_GIVE_UP = 4

int_intervall = (_("unison"), _("minor second"), _("major second"),
                 _("minor third"), _("major third"), _("fourth"),
                 _("diminished fifth"), _("perfect fifth"),
                 _("minor sixth"), _("major sixth"),
                 _("minor seventh"), _("major seventh"),
                 _("perfect octave"),
                 _("minor ninth"), _("major ninth"),
                 _("minor decim"), _("major decim"))

short_intervall_name = (_i("u"), _i("m2"), _i("M2"), _i("m3"), _i("M3"), _i("4"),
                        _i("d5"), _i("5"), _i("m6"), _i("M6"), _i("m7"),
                        _i("M7"), _i("8"), _i("m9"), _i("M9"), _i("m10"),
                        _i("M10"))

