/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal sealed class MergeDtd : Merge
{

private string                     m_mergeFilePath;
private Dictionary<string, string> m_mergeTranslatedPhrases;


public MergeDtd(DtdFile dic) : base(dic)
{
}


protected override string MergeFile(string translatedModule, string path)
{
    DtdFile trans = new DtdFile(translatedModule + path);
    Dictionary<string, string> keysL10n = trans.LoadHashtableQuoted();
    return this.MergeFileCore(keysL10n, path);
}


//MergeFile
private string MergeFileCore(Dictionary<string, string> trans, string path)
{
    m_mergeTranslatedPhrases = trans;
    m_mergeFilePath = path;

    //DtdFile trans = new DtdFile(translatedModule + path);
    //m_translated = trans;
    //m_mergeTranslatedPhrases = trans;



    // merge!
    List<string> m_mergeCommentsLog = new List<string>();
    string txtNew = (m_dic as DtdFile).SanitizeContent(m_mergeCommentsLog);
    MatchEvaluator myDelegate = new MatchEvaluator(this.GetLocalizedEntity);
    txtNew = Regex.Replace(txtNew, DtdFile.m_quotExp, myDelegate);
    txtNew = Regex.Replace(txtNew, DtdFile.m_aposExp, myDelegate);

    // restore comments
    for (int idx = 0; idx < m_mergeCommentsLog.Count; idx++) {
        txtNew = txtNew.Replace("<&SAFEPLACEHOLDER#" + idx.ToString() + "&>", m_mergeCommentsLog[idx]);
    }

    m_mergeCommentsLog.Clear();
    m_mergeFilePath = null;
    return txtNew;
}


private string GetLocalizedEntity(Match match)
{
    GroupCollection groups = match.Groups;
    if (groups.Count < 4) {
        // ???
        return groups[0].Value;
    }

    if (m_mergeTranslatedPhrases.ContainsKey(groups[1].Value)) {
        string original = groups[2].Value;
        string translated = m_mergeTranslatedPhrases[groups[1].Value];
        string test = TestDtdString(original, translated);
        if (test == null) {
            return groups[0].Value.Replace(original, this.Escape(translated));
        } else {
            this.WriteWarning(test + ": " + m_mergeFilePath + " => " + groups[1].Value + ". Using the original value.");
            return groups[0].Value;
        }

    } else {
        // missing localized value: original value will remain
        this.WriteWarning("Missing key " + m_mergeFilePath + " => " + groups[1].Value + ". Using the original value.");
        //return this.Escape(groups[0].Value);
        return groups[0].Value;
    }
}


private static string TestDtdString(string o, string t)
{
    string err;
    err = MalformedEntityTest.CompareCore(o, t);
    if (err != null) {
        return err;
    }
    err = EntityTest.CompareCore(o, t);
    if (err != null) {
        return err;
    }
    err = PlaceholderExpressionsTest.CompareCore(o, t);
    if (err != null) {
        return err;
    }
    return err;
}


protected override string MergeFileEx(Dictionary<string, string> trans, string path)
{
    Dictionary<string, string> trans2 = new Dictionary<string, string>(trans.Count);

    //
    string quote = @"""";
    Dictionary<string, string>.Enumerator transEnum = trans.GetEnumerator();
    while (transEnum.MoveNext()) {
        string val = transEnum.Current.Value;

        // sanitize quote
        if (val.IndexOf('"') == -1) {
            val = quote + val + quote;
        } else if (val.IndexOf('\'') == -1) {
            val = "'" + val + "'";
        } else {
            val = quote + val.Replace(quote, "&quote;") + quote;
        }

        trans2.Add(transEnum.Current.Key, val);
    }

    return this.MergeFileCore(trans2, path);
}


// http://www.mozilla.org/projects/l10n/mlp_chrome.html#text
private string Escape(string txt)
{
    if (txt.Length == 0) {
        return txt;
    }


    txt = txt.Replace("\n", m_dic.Eol);

    // ["nonono"] or [nonono]
    int idxLower = 0;
    int idxUpper = txt.Length - 1;
    switch (txt[0]) {
        case '\'':
        case '"':
            idxUpper--;
            idxLower++;
            break;
    }
    System.Text.StringBuilder buffer = new System.Text.StringBuilder(txt);
    for (int idx = idxUpper; idx >= idxLower; idx--) {
        char ch = buffer[idx];
        switch (ch) {
        /*
            case '<':
                buffer[idx] = '&';
                buffer.Insert(idx + 1, "lt;");
                break;
            case '"':
                buffer[idx] = '&';
                buffer.Insert(idx + 1, "quote;");
                break;
        */
            case '%':
                buffer[idx] = '&';
                buffer.Insert(idx + 1, "#037;");
                break;
         }
    }

    return buffer.ToString();
}

}//class
}//ns
