/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Clippings extension for Mozilla Firefox.
 *
 * The Initial Developer of the Original Code is 
 * Alex Eng <ateng@users.sourceforge.net>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** */



function AppUtils() {}

AppUtils.prototype = {
  // Application-specific constants
  DEBUG:   true
};


AppUtils.prototype.alertEx = function (aTitle, aMessage)
{
  var prmpt = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                        .getService(Components.interfaces.nsIPromptService);
  prmpt.alert(null, aTitle, aMessage);
};


AppUtils.prototype.confirmEx = function (aTitle, aMessage)
{
  var rv;
  var prmpt = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                        .getService(Components.interfaces.nsIPromptService);
  rv = prmpt.confirm(null, aTitle, aMessage);
  return rv;
};


AppUtils.prototype.getTextFromClipboard = function () 
{
  var rv;
  var clipbd = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
  var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
  trans.addDataFlavor("text/unicode");
  clipbd.getData(trans, clipbd.kGlobalClipboard);

  var str = {};
  var strLen = {};
  try {
    trans.getTransferData("text/unicode", str, strLen);
  } 
  catch (e) {
    // Failed because there's nothing on the clipboard or the clipboard
    // contents isn't textual data
    return rv;
  }

  if (str) {
    str = str.value.QueryInterface(Components.interfaces.nsISupportsString);
  }
  if (str) {
    rv = str.data.substring(0, strLen.value / 2);
  }

  return rv;
};


AppUtils.prototype.copyTextToClipboard = function (aText) 
{
  var clipbd = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
  clipbd.copyString(aText);
};


AppUtils.prototype.getPref = function (aPrefName)
{
  var pref = Components.classes["@mozilla.org/preferences-service;1"]
  .getService(Components.interfaces.nsIPrefBranch);
  try {
    var prefType = pref.getPrefType(aPrefName);
  } catch (e) {
    this.log(e);
  }
  var rv;
  switch (prefType) {
  case pref.PREF_STRING:
    rv = pref.getCharPref(aPrefName);
    break;

  case pref.PREF_INT:
    rv = pref.getIntPref(aPrefName);
    break;

  case pref.PREF_BOOL:
    rv = pref.getBoolPref(aPrefName);
    break;

  default:
    break;
  }
  return rv;
};

  
AppUtils.prototype.setPref = function (aPrefName, aPrefValue)
{
  var pref = Components.classes["@mozilla.org/preferences-service;1"]
  .getService(Components.interfaces.nsIPrefBranch);
  try {
    var prefType = pref.getPrefType(aPrefName);
  } catch (e) {
    this.log(e);
  }

  switch (prefType) {
    case pref.PREF_STRING:
    pref.setCharPref(aPrefName, aPrefValue);
    break;

    case pref.PREF_INT:
    pref.setIntPref(aPrefName, aPrefValue);
    break;

    case pref.PREF_BOOL:
    pref.setBoolPref(aPrefName, aPrefValue);
    break;

    default:
    break;
  }
};


AppUtils.prototype.resetPref = function (aPrefName)
{
  var pref = Components.classes["@mozilla.org/preferences-service;1"]
  .getService(Components.interfaces.nsIPrefBranch);
  pref.clearUserPref(aPrefName);
};


AppUtils.prototype.getCurrentProfileURL = function ()  
{
  var profileDir = this.getCurrentProfileDir();
  var fph = Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler);
  return fph.getURLSpecFromFile(profileDir);
};


AppUtils.prototype.getCurrentProfileDir = function ()
  // Throws an exception if profile directory retrieval failed.
{
  var dirProp = Components.classes["@mozilla.org/file/directory_service;1"]
                          .getService(Components.interfaces.nsIProperties);
  var profileDir = dirProp.get("ProfD", Components.interfaces.nsIFile);
  if (! profileDir) {
    throw "Failed to retrieve current profile directory path";
  }

  return profileDir;
};


AppUtils.prototype.beep = function () 
{
  var sound = Components.classes["@mozilla.org/sound;1"].createInstance(Components.interfaces.nsISound);
  sound.beep();
};


AppUtils.prototype.log = function (aMessage) 
{
  if (this.DEBUG) {
    var consoleSvc = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);
    consoleSvc.logStringMessage(aMessage);
  }
};
