
const READYSTATE_UNINITIALIZED = 0;
const READYSTATE_LOADING = 1;
const READYSTATE_LOADED = 2;
const READYSTATE_INTERACTIVE = 3;
const READYSTATE_COMPLETED = 4;
const HTTP_OK = 200;
const HTTP_UNAUTHORIZED = 401;
const HTTP_FORBIDDEN = 403;
const HTTP_NOT_FOUND = 404;
const HTTP_INTERNAL_SERVER_ERROR = 500;
const HTTP_SERVICE_UNAVAILABLE = 503;
const METHODURL_GET = "https://api.del.icio.us/v1/tags/get";
// Old URL was "http://del.icio.us/api/tags/get" (discontinued July 1 2006)
const LINEBREAK = "\r\n";

var gAppUtils;
var gRequest;  // An instance of the XMLHttpRequest object.
var gStatusBar;
var gTagList;
var gCopyCmd;
var gTagText = "";
var gFirstTimeRetrieval = true;
var gIsLoading;
var gUsername, gPswd;


function init()
{
  gAppUtils = new AppUtils();

  gTagList = document.getElementById("tag-list");
  gStatusBar = document.getElementById("app-status");
  gCopyCmd = document.getElementById("cmd_copy");

  gTagList.setAttribute("disabled", "true");
  window.setTimeout("login()", 100);  // Allow main window to display in bkgrd.
}


function login()
{
  var dlgArgs = {
    rememberPswd: gAppUtils.getPref("xulicious.login.rememberPswd"),
    username:   gAppUtils.getPref("xulicious.login.username"),
    pswd:       gAppUtils.getPref("xulicious.login.pswd"),
    userCancel: null 
  };
  var dlg = window.openDialog("chrome://xulicious/content/login.xul", "delicious_login_dlg", "modal,centerscreen", dlgArgs);
  if (dlgArgs.userCancel) {
    window.close();
  }

  gTagList.setAttribute("disabled", "false");
  gUsername = dlgArgs.username;
  gPswd = dlgArgs.pswd;
  gAppUtils.setPref("xulicious.login.username", dlgArgs.username);
  gAppUtils.setPref("xulicious.login.rememberPswd", dlgArgs.rememberPswd);
  if (dlgArgs.rememberPswd) {
    gAppUtils.setPref("xulicious.login.pswd", dlgArgs.pswd);
  }
  else {
    gAppUtils.setPref("xulicious.login.pswd", "");
  }

  gRequest = new XMLHttpRequest();
  gRequest.overrideMimeType("text/xml");

  setLoadState(true);
  getTags();
}


function getTags()
{
  gStatusBar.label = "retrieving...";
  gRequest.onreadystatechange = handleResponse;

  try {
    if (gFirstTimeRetrieval) {
      gAppUtils.log("first time retrieving tags");
      gRequest.open("GET", METHODURL_GET, true, gUsername, gPswd);
      gFirstTimeRetrieval = false;
    }
    else {
      // Firefox caches userid/pswd.
      gAppUtils.log("retrieving tags again");
      gRequest.open("GET", METHODURL_GET, true);
    }
    
    gRequest.send(null);
  }
  catch (e) {
    gAppUtils.log(e);
    gStatusBar.label = "unable to send request";
    return;
  }
}


function handleResponse()
{
  if (gRequest.readyState == READYSTATE_COMPLETED) {
    gAppUtils.log("ready state is 'complete'");
    setLoadState(false);

    try {
      var status = gRequest.status;
    }
    catch (e) {
      gStatusBar.label = "unable to connect to server";
      return;
    }
    
    if (status == HTTP_OK) {
      var xmlDoc = gRequest.responseXML;

      if (! xmlDoc) {
	gStatusBar.label = "no data";
	return;
      }
      
      var tagNodes = xmlDoc.getElementsByTagName("tags").item(0).childNodes;
      var count = 0;

      for (var i = 0; i < tagNodes.length; i++) {
	if (tagNodes[i].nodeName != "tag") {
	  continue;
	}

	var listitem = document.createElement("listitem");
	var tagData = tagNodes[i].getAttribute("tag") + " (" + tagNodes[i].getAttribute("count") + ")";
	listitem.setAttribute("label", tagData);
	gTagList.appendChild(listitem);
	gTagText += tagData + LINEBREAK;

	count++;
      }

      document.title = gUsername + "'s tags";
      gStatusBar.label = "" + count + " tags";
      gCopyCmd.setAttribute("disabled", "false");
    }
    else if (status == HTTP_UNAUTHORIZED) {
      gStatusBar.label = "login failed; click reload to retry";
    }
    else if (status == HTTP_FORBIDDEN) {
      gStatusBar.label = "forbidden (403)";
    }
    else if (status == HTTP_NOT_FOUND) {
      gStatusBar.label = "not found (404)";
    }
    else if (status == HTTP_INTERNAL_SERVER_ERROR) {
      gStatusBar.label = "internal server error (500)";
    }
    else if (status == HTTP_SERVICE_UNAVAILABLE) {
      gStatusBar.label = "service unavailable (503)";
    }
    else {
      gStatusBar.label = "there was a problem with the request:  status=" + status + "; readyState=" + gRequest.readyState;
    }
  }
}


function clearList()
{
  gTagText = "";
  gCopyCmd.setAttribute("disabled", "true");

  while (gTagList.hasChildNodes()) {
    gTagList.removeChild(gTagList.firstChild);
  }
}


function doCopy()
{
  gAppUtils.copyTextToClipboard(gTagText);
}


function doReload()
{
  if (gIsLoading) {
    gAppUtils.log("don't interrupt the load/reload in progress!");
    return;
  }

  setLoadState(true);
  clearList();
  getTags();
}


function setLoadState(aLoadState)
{
  gIsLoading = aLoadState;
  var throbber = document.getElementById("throbber");
  var wnd = document.getElementById("xulicious-window");

  if (gIsLoading) {
    throbber.setAttribute("active", "true");
    wnd.style.cursor = "progress";
  }
  else {
    throbber.removeAttribute("active");
    wnd.style.cursor = "default";
  }
}


function unload() 
{
  var readyState = gRequest.readyState;
  gAppUtils.log("exiting: readyState = " + readyState);

  if (readyState != READYSTATE_COMPLETED) {
    gRequest.abort();
    gStatusBar.label = "aborted";
    gAppUtils.log("exiting: send aborted");
  }
}
