/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License. 
 *
 * The Original Code is ChatZilla
 * 
 * The Initial Developer of the Original Code is
 * Samuel Sieb
 * Portions created by Samuel Sieb are Copyright (C) 2005 Samuel Sieb.
 *
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU Public License (the "GPL"), in which case the
 * provisions of the GPL are applicable instead of those above.
 * If you wish to allow use of your version of this file only
 * under the terms of the GPL and not to allow others to use your
 * version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL.  If you do not delete
 * the provisions above, a recipient may use your version of this
 * file under either the MPL or the GPL.
 *
 * Contributor(s):
 *  Samuel Sieb, <samuel@sieb`net>, original author
 */

plugin.id = "country-flags";

var IPList;
var CList;
var FList;

plugin.init =
function init(glob)
{
    /* This function will be called when chatzilla first loads the plugin.
     * We initialize some of the plugin object's properties, define a new
     * command and some new prefs, and print out a message.
     */     
    plugin.major = 1;
    plugin.minor = 3;
    plugin.version = plugin.major + "." + plugin.minor;
    plugin.description = "Displays a country flag in front of messages."

    loadCountries();
    loadFlags();
    loadIPs();

    return "Country flags loading, please wait";
}

var loading;
var next;
var stream;
var IPFile;
var wantToEnable = false;

function loadIPs()
{
    try
    {
        var count = 0;
        if (!loading)
        {
            IPFile = fopen(getFileFromURLSpec(plugin.cwd + "ipc.csv"), "<");
            stream = IPFile.baseInputStream.QueryInterface(Components.interfaces.nsILineInputStream);
            IPList = new Array();
            loading = true;
            next = 0;
            count = 8000;
        }
        var line = new Object();
        var ary;
        var more;
        while (more = stream.readLine(line))
        {
            ary = line.value.split(/,/);
            if (ary[0] > next)
                IPList.push(new Array(next, ary[0] - 1, "??"));
            IPList.push(new Array(ary[0] * 1, ary[1] * 1, ary[2]));
            next = ary[1] * 1 + 1;
            if (count++ > 10000)
                break;
        }
        if (more)
        {
            setTimeout(loadIPs, 500);
        }
        else
        {
            IPList.push(new Array(next, 0xffffffff, "??"));
            IPFile.close();
            loading = false;
            client.display("loaded "+IPList.length+" IP ranges");
            if (wantToEnable)
                dispatch("enable-plugin country-flags");
        }
    }
    catch (e)
    {
        IPList = false;
        loading = false;
        wantToEnable = false;
        display("unable to load IP list","ERROR");
        display(e.toString(),"ERROR");
    }
}

function loadCountries()
{
    var CFile;
    CList = new Array();
    try
    {
        CFile = fopen(getFileFromURLSpec(plugin.cwd + "countries.csv"), "<");
        stream = CFile.baseInputStream.QueryInterface(Components.interfaces.nsILineInputStream);
        var line = new Object();
        var ary;
        while (stream.readLine(line))
        {
            ary = line.value.split(/,/);
            CList[ary[0]] = ary[1];
        }
        ary = line.value.split(/,/);
        CList[ary[0]] = ary[1];
        CList["??"] = "Unknown";
        CList["XX"] = "Host doesn't resolve";
        CFile.close();
    }
    catch (e)
    {
        display("unable to load country list","ERROR");
        display(e.toString(),"ERROR");
    }
}

function loadFlags()
{
    var FFile;
    FList = new Array();
    try
    {
        FFile = fopen(getFileFromURLSpec(plugin.cwd + "flags.csv"), "<");
        stream = FFile.baseInputStream.QueryInterface(Components.interfaces.nsILineInputStream);
        var line = new Object();
        var ary;
        while (stream.readLine(line))
        {
            ary = line.value.split(/,/);
            FList[ary[0]] = ary[1];
        }
        ary = line.value.split(/,/);
        FList[ary[0]] = ary[1];
        FFile.close();
    }
    catch (e)
    {
        display("unable to load flag list","ERROR");
        display(e.toString(),"ERROR");
    }
}

var oldHistory;
var queueComp = Components.classes["@mozilla.org/event-queue-service;1"];
var queueSvc = queueComp.getService(Components.interfaces.nsIEventQueueService);
var myQueue = queueSvc.getSpecialEventQueue(queueSvc.CURRENT_THREAD_EVENT_QUEUE);
var dnsComp = Components.classes["@mozilla.org/network/dns-service;1"];
var dnsSvc = dnsComp.getService(Components.interfaces.nsIDNSService);

plugin.disable =
function disable()
{
    addHistory = oldHistory;
    return true;
}

function ip2cc(ip)
{
    var min = 0, max = IPList.length - 1;
    var cur;
    if (ip == 0)
        return "XX";
    while (min <= max)
    {
        cur = Math.floor((min + max) / 2);
        if (ip < IPList[cur][0])
            max = cur - 1;
        else if (ip > IPList[cur][1])
            min = cur + 1;
        else
            break;
    }
    return IPList[cur][2];
}

function updateSpan(s, cc, doc)
{
    if (cc in FList)
    {
        var i = doc.createElement("img");
        i.src = plugin.cwd + "/flag/" + FList[cc];
        s.firstChild.nodeValue = " ";
        s.insertBefore(i, s.firstChild);
    }
    else
    {
        s.firstChild.nodeValue = "[" + cc + "] ";
    }
    if (cc in CList)
        s.setAttribute("title", CList[cc]);
}

function DNSL(user)
{
    this.user = user;
}

DNSL.prototype.onLookupComplete =
function lookup_complete(request, record, status)
{
    var user = this.user;
    var ary;
    delete user.request;
    if (!record)
    {
        user.ip = 0;
        if ((ary = user.host.toUpperCase().match(/\.([A-Z][A-Z])$/)) &&
            (ary[1] in CList))
        {
            user.cc = ary[1];
        }
        else
            user.cc = "XX";
    }
    else
    {
        ary = record.getNextAddrAsString().match(/(\d+)\.(\d+)\.(\d+)\.(\d+)/);
        user.ip = (ary[1] * 0x1000000) + (ary[2] << 16) + (ary[3] << 8) + ary[4] * 1;
        user.cc = ip2cc(user.ip);
    }
    for (var s in user.sList)
        updateSpan(user.sList[s], user.cc, user.sList[s].ownerDocument);
    delete user.sList;
}

function newHistory(source, obj, mergeData)
{
    var el = obj.getElementsByTagName("td")[1];
    var nick = obj.getAttribute("msg-user");
    if ((source.TYPE == "IRCChannel") && nick && (!nick.match(/ME!/)))
    {
        var user = source.parent.getUser(nick);
        if (user)
        {
            el = obj.getElementsByTagName("td")[2];
            var cc = '??';
            var s = newInlineText(" ");
            if (!("cc" in user))
            {
                if (!("request" in user))
                {
                    if (!("sList" in user))
                        user.sList = new Array();
                    user.request = dnsSvc.asyncResolve(user.host, 0, new DNSL(user), myQueue);
                }
                user.sList.push(s);
            }
            else
            {
                cc = user.cc;
            }
            updateSpan(s, cc, source.messages.ownerDocument);
            el.insertBefore(s, el.firstChild);
        }
    }
    oldHistory(source, obj, mergeData);
}

plugin.enable =
function enable()
{
    if (loading)
    {
        wantToEnable = true;
        display("still loading IP ranges, will enable plugin when finished loading");
    }

    if (!IPList || loading)
        return false;

    oldHistory = addHistory;
    addHistory = newHistory;

    return true;
}

