/*-*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

  ***** BEGIN LICENSE BLOCK *****
* Version: MPL 1.1/GPL 2.0/LGPL 2.1
*
* The contents of this file are subject to the Mozilla Public License Version
* 1.1 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
* for the specific language governing rights and limitations under the
* License.
*
* The Original Code is:
* ChattyTunes - a ChatZilla Media Player plugin utilizing the FoxyTunes
* Firefox Extension by Alex Sirota (alex@elbrus.com)
*
* The Initial Developers of the Original Code are:
* David Corry <dmcorry@gmail.com> and Gijs Kruitbosch <gk1987@gmail.com>.
*
* Portions created by David Corry and Gijs Kruitbosch are Copyright (C) 2004
* David Corry and Gijs Kruitbosch. All Rights Reserved.
*
* Contributor(s): David Corry & Gijs Kruitbosch
*
* Alternatively, the contents of this file may be used under the terms of
* either the GNU General Public License Version 2 or later (the "GPL"), or
* the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
* in which case the provisions of the GPL or the LGPL are applicable instead
* of those above. If you wish to allow use of your version of this file only
* under the terms of either the GPL or the LGPL, and not to allow others to
* use your version of this file under the terms of the MPL, indicate your
* decision by deleting the provisions above and replace them with the notice
* and other provisions required by the LGPL or the GPL. If you do not delete
* the provisions above, a recipient may use your version of this file under
* the terms of any one of the MPL, the GPL or the LGPL.
*
*
* FoxyTunes Extension and Engine - Copyright (C) 2004 Alex Sirota <alex@elbrus.com>.
* All Rights Reserved.
* FoxyTunes Home Page - http://www.foxytunes.org/
*
* FoxyTunes extension is used with written permission from its author.
*
*
* A big "thank you" to the chatzilla irc channel members, for helping us
* whenever we needed it :-).
****** END LICENSE BLOCK ***** */
plugin.id = "ChattyTunes";

// FoxyTunes implementation goes here:
var foxyTunesInstalled = true;
var CTCurrentPlayerClass; // Object to check if we're still using an up to date player selection
var foxyTunesPrefService;
var foxyTunesPref;
var foxyTunes;

function InitFoxyTunesObjects() {
       var c = 0; for (var i in Components.classes) { if (i.match(/^@foxytunes.org\/FoxyTunes/)) { c++; } }
       if (c == 0) {
               client.display(GetMsg('plugin.ChattyTunes.NoFoxyTunesInstalled'));
               foxyTunesInstalled = false;
       }

       if (foxyTunesInstalled == true) {
               CTCurrentPlayerClass // Object to check if we're still using an up to date player selection
               foxyTunesPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                                  .getService(Components.interfaces.nsIPrefService);
               foxyTunesPref = foxyTunesPrefService.getBranch("foxytunes.");
               foxyTunes = null; }
       else {
               plugin.enabled = false
       }
}

// Locale and Help stuff goes here:
const __default_locale = 'en-US';
var pluginURL = String(this.plugin.url).replace(/\/[^\/]*$/,'/');
var localeURL = pluginURL + 'locale/' + localeName() + ".properties";
var fallbackLocaleURL = pluginURL + 'locale/' + __default_locale + ".properties";
var defaultBundle;
var fallbackBundle;

function localeName () {
   try {
       var cls = '@mozilla.org/chrome/chrome-registry;1';
       var service = Components.interfaces.nsIXULChromeRegistry;
       return Components.classes[cls].getService(service).getSelectedLocale('global');
   } catch (e) {
       return __default_locale;
   }
}

function loadLocale() {
   try {
       fallbackBundle = client.messageManager.addBundle (fallbackLocaleURL);
   } catch (e) {
       display (__id + ' plugin: '+ __default_locale +
                ' locale file required, but not found',MT_ERROR);
       plugin.enabled = false;
       return;
   }
   if (localeURL == fallbackLocaleURL) {
       defaultBundle = fallbackBundle;
       return;
   }
   try {
       defaultBundle = client.messageManager.addBundle (localeURL);
   } catch (e) {
       defaultBundle = fallbackBundle;
   }
}

// Let's get that plugin rolling:
plugin.init =
function initPlugin(glob) {
       loadLocale();
       InitFoxyTunesObjects();

       plugin.major = 0;  // Major version number.
       plugin.minor = 6;  // Minor version number.
       plugin.version = plugin.major + "." + plugin.minor;
       plugin.description = GetMsg('plugin.ChattyTunes.PluginDescription')
       var myprefs = [
               ["NPFormat", GetMsg('plugin.ChattyTunes.DefaultNPFormat'), ""],
               ["InfoFormat", GetMsg('plugin.ChattyTunes.DefaultInfoFormat'), ""],
               ["IdleString", GetMsg('plugin.ChattyTunes.DefaultIdleString'), ""],
               ["MaxDoubleTakes", 20, ""],
               ["MaxSearchErrors", 10, ""]
       ];

       plugin.prefary = plugin.prefary.concat(myprefs);
       client.responseCodeMap["tunes"] = "[TUNES]";
       client.responseCodeMap["tunes-error"] = "[TUNES]";
       client.responseCodeMap["tunes-play"] = "[TUNES]";
       client.responseCodeMap["tunes-pause"] = "[TUNES]";
       client.responseCodeMap["tunes-stop"] = "[TUNES]";
}

plugin.enable =
function enable() {
       plugin.cmdlist = [
               ["np", cmdNowPlaying, CMD_CONSOLE | CMD_NEED_CHAN],
               ["ctplay", cmdCTPlay, CMD_CONSOLE, "[<rest>]"],
               ["ctsearch", cmdCTSearch, CMD_CONSOLE],
               ["ctpause", cmdCTPause, CMD_CONSOLE],
               ["ctstop", cmdCTStop, CMD_CONSOLE],
               ["ctplaying", cmdCTPlaying, CMD_CONSOLE],
               ["ctnext", cmdCTNext, CMD_CONSOLE],
               ["ctprev", cmdCTPrev, CMD_CONSOLE],
               ["ctmute", cmdCTMute, CMD_CONSOLE],
               ["ctshowplayer", cmdCTShowPlayer, CMD_CONSOLE],
               ["cthideplayer", cmdCTHidePlayer, CMD_CONSOLE],
               ["ctplayfile", cmdCTPlayFile, CMD_CONSOLE],
               ["ctinsertsong", insertSong, 0]
       ];
       plugin.cmdlist.stringBundle = defaultBundle; // Apply help
       plugin.cmdlist = client.commandManager.defineCommands(plugin.cmdlist);
       
	   var input_node = document.getElementById("input");
	   input_node.addEventListener("keypress", onCTKeypress, false);
	   
       /*  client.prefManager.addPrefs(plugin.prefAry);
               commentized when switching to new plugin api, this is no longer necessary.
               all we need to do now is use plugin.prefs to get to our preferences. Smart, eh? ;-) */
       var chattymenupresent = client.menuManager.menuSpecs["mainmenu:chatty"]

       client.menuManager.menuSpecs["mainmenu:chatty"] = {
               label: "T&unes",
               getContext: getFoxyContext,
               items: [
                       ["ctplay",      {label: GetMsg('plugin.ChattyTunes.Play')}],
                       ["ctstop",      {label: GetMsg('plugin.ChattyTunes.Stop')}],
                       ["ctpause",     {label: GetMsg('plugin.ChattyTunes.Pause')}],
               ["ctnext",      {label: GetMsg('plugin.ChattyTunes.Next')}],
                       ["ctprev",  {label: GetMsg('plugin.ChattyTunes.Previous')}],
                       ["-"],
                       ["ctsearch", {label: GetMsg('plugin.ChattyTunes.Search')}],
                       ["-",          {visibleif: "cx.currentSong != null"}],
                       ["ctinsertsong",  {format: "$currentSong", style: "font-weight: bold;", label: "ChattyTunes", visibleif: "cx.currentSong != null"}]
               ]
       };
       if (!("outputFilters" in client))
               client.outputFilters = new Object();
       client.outputFilters["chattytunes"] = { func: textFilter, enabled: true };
       if (!chattymenupresent && client.initialized)
               /* Make sure we don't double the menu's. If the menu is not there, we put it there,
                * unless we're starting up, because plugins are loaded BEFORE menu's are actually created. */
       {
               client.menuManager.createMenu(document.getElementById("mainmenu"), null, "mainmenu:chatty", "mainmenu:chatty");
       }
       display(plugin.id+' plugin enabled');
       return "OK";
}

plugin.disable =
function disable() {
       client.commandManager.removeCommands(plugin.cmdlist);
       var input_node = document.getElementById("input");
	   input_node.removeEventListener("keypress", onCTKeypress, false);
       display(plugin.id+' plugin disabled');
       return true;
       // Uhh, yeah. Well. Anything else? :s
       	   
}

function getFoxyContext(){
       cx = new Object();
       InitCTObjectIfNeeded()
       var song = foxyTunes.GetCurrentTrackTitle();
       if(song === "" || foxyTunes == null)
         var song = null;
       cx.currentSong = song;
       return cx;
}

function InitCTObjectIfNeeded(){
       if (foxyTunes!=null && CTCurrentPlayerClass == foxyTunesPref.getCharPref("player_class")) {return 0;}
       // bail out already because we have an up-to-date object

       // test message:
       if (foxyTunes!=null) {display(GetMsg('plugin.ChattyTunes.ChangedMediaPlayer'),"TUNES");}

       CTCurrentPlayerClass = foxyTunesPref.getCharPref("player_class");
       try {
               foxyTunes = Components.classes[CTCurrentPlayerClass].getService();
               foxyTunes = foxyTunes.QueryInterface(Components.interfaces.mozIFoxyTunes);
       } catch(e) {
               display(GetMsg('plugin.ChattyTunes.ErrorLoading') + e, "tunes-error")
       }
}

function cmdNowPlaying() {
       InitCTObjectIfNeeded();

       var nowplayingmsg = plugin.prefs["NPFormat"];
       var titleExp = new RegExp ("\\$T", "gi");
       var lengthExp = new RegExp ("\\$L", "gi");
       var positionExp = new RegExp ("\\$P", "gi");
       try {
               var song = foxyTunes.GetCurrentTrackTitle();
       } catch (e) {
               song = null
       }
       try {
               var length = CTSeconds2TimeString(foxyTunes.GetCurrentTrackLength());
       } catch (e) {
               length = "0:00"
       }
       try {
               var pos = CTSeconds2TimeString(foxyTunes.GetCurrentTrackPosition());
       } catch (e) {
               pos = "0:00"
       }
       if (song == null) { song = plugin.prefs["IdleString"] }

       // replace variables:
       nowplayingmsg = nowplayingmsg.replace(titleExp, song);
       nowplayingmsg = nowplayingmsg.replace(lengthExp, length);
       nowplayingmsg = nowplayingmsg.replace(positionExp, pos);
       dispatch(replaceColorCodes(nowplayingmsg));
}

function cmdCTPlay(e) {
       InitCTObjectIfNeeded();
       var searcherrors = 0;     // errors when executing commands within the search loop. > 10 --> abort.
       if (e.rest == null) {
           DispatchCTCommand('Play');
               setTimeout(DisplayInfoString,1500) }
       else {
               DispatchCTCommand('Stop'); // Tries to make sure that even on slow players, you're not going to hear part of the songs that come by.
               var searchexpression = new RegExp(e.rest, "gi") // make search case insensitive
               display(GetMsg('plugin.ChattyTunes.Searching'),"tunes");

               // here goes the clever stuff. Watch and see, hopefully everything will go as planned.
               var oldtitle
               try {
                       oldtitle = foxyTunes.GetCurrentTrackTitle();
               } catch (e) {
                       display(GetMsg('plugin.ChattyTunes.ErrorOriginalTitle')+ " " + e,"tunes-error")
                       oldtitle = null
                       return 0;
               }
               // We need that to return to the old spot in case we find nothing.
               // The script skips the current song when searching.
               var searchfailed = false; // will be true if we reach the old spot without finding anything,

               var currenttitle = "";
               var lasttitle = oldtitle;       // Use this to see if we're actually still getting further using the next command...
               searcherrors = 0;         // count the number of errors we take the same song title. If there are too many, stop searching.
               doubletakes = 0;          // count the number of times we double out. If we get stuck, we don't want to crash CZ now, do we?

               do {
                       DispatchCTSearchCommand('Next');
                       try {
                               currenttitle = foxyTunes.GetCurrentTrackTitle();
                       } catch (e) {
                               searcherrors++
                               currenttitle = null
                       }
                       while (currenttitle == null || currenttitle == lasttitle) {
                               doubletakes++
                               try {
                                       currenttitle = foxyTunes.GetCurrentTrackTitle();
                               } catch (e) {
                                       currenttitle = null
                                       searcherrors++
                                       if (searcherrors >= plugin.prefs["MaxSearchErrors"]) {
                                               display(GetMsg('plugin.ChattyTunes.SearchMaxErrors'),"tunes-error")
                                               searcherrors = 0;
                                               return 0;
                                       }
                               }
                               if (doubletakes >= plugin.prefs["MaxDoubleTakes"]) {
                                       display(GetMsg('plugin.ChattyTunes.ErrorDoubleTakes'),"tunes-error")
                                       return 0;
                               }
                       }
                       doubletakes = 0;
                       if (currenttitle == oldtitle) {
                               searchfailed = true;
                               var playvar = "Play"
                               setTimeout(DispatchCTSearchCommand,2000, playvar);
                               // we're back where we came from, playing again.
                       }
                       else {
                               if (currenttitle.match(searchexpression) != null) {
                                       // We have a match!
                                       display(GetMsg('plugin.ChattyTunes.Found') + " " + currenttitle, "tunes-play");
                                       var playvar = "Play"
                                       setTimeout(DispatchCTSearchCommand,2000, playvar);

                                       return 0;
                               }

                               lasttitle = currenttitle
                               if (searcherrors > plugin.prefs["MaxSearchErrors"]) {
                                       display(GetMsg('plugin.ChattyTunes.SearchMaxErrors'),"tunes-error")
                                       searcherrors = 0;
                                       return 0;
                               }
                       }
               }
               while (!searchfailed)
               // if we are here we bailed out of the loop without finding anything. Let the user know:
               display(GetMsg('plugin.ChattyTunes.NotFound'),"tunes")
       }

       function DispatchCTSearchCommand(commandname) {
               try {
               eval('foxyTunes.' + commandname + '();');
               }
               catch (err) {
               display(GetMsg('plugin.ChattyTunes.SearchErrorCommand') + " " + commandname + ": " + err, "tunes-error");
                       searcherrors++;
               }
               return 0;
       }
}

function cmdCTPause() {
       InitCTObjectIfNeeded();
       DispatchCTCommand('Pause');
       display("Paused.", "tunes-pause");
}

function cmdCTStop() {
       InitCTObjectIfNeeded();
       DispatchCTCommand('Stop');
       display("Stopped.", "tunes-stop");
}

function cmdCTPlaying() {
       InitCTObjectIfNeeded();
       DisplayInfoString();
}

function cmdCTNext() {
       InitCTObjectIfNeeded();
       DispatchCTCommand('Next');
       setTimeout(DisplayInfoString,1500)
}

function cmdCTPrev() {
       InitCTObjectIfNeeded();
       DispatchCTCommand('Previous');
       setTimeout(DisplayInfoString,1500)
}

function cmdCTMute() {
       InitCTObjectIfNeeded();
       DispatchCTCommand('ToggleMute');
}

function cmdCTShowPlayer() {
       InitCTObjectIfNeeded();
       DispatchCTCommand('ShowPlayer');
}

function cmdCTHidePlayer() {
       InitCTObjectIfNeeded();
       DispatchCTCommand('HidePlayer');
}

function cmdCTPlayFile() {
       InitCTObjectIfNeeded();
       DispatchCTCommand('PlayFile');
}

function CTSeconds2TimeString(seconds) {
       if (!parseInt(seconds, 10)) {
               return "0:00";
       }
       seconds = parseInt(seconds)

       if (seconds == 4294967) {
               seconds = 0; // winamp
       }

       if (seconds == 4294967295) {
               seconds = 0; // QCD
       }

       var time_hours = Math.floor(seconds / 3600)
       var time_seconds = seconds % 60
       var time_minutes = ((seconds % 3600) - time_seconds) / 60
       if (time_seconds < 10) {
               time_seconds = '0' + time_seconds;
       }
       var timeStr = time_minutes + ':' + time_seconds;
       if (time_hours > 0) {
               if (time_minutes < 10) { timeStr = '0' + timeStr}
               timeStr = time_hours + ':' + timeStr;
       }
       return timeStr;
}

function DisplayInfoString() {
       var titleExp = new RegExp("\\$T", "gi");
       var lengthExp = new RegExp("\\$L", "gi");
       var positionExp = new RegExp("\\$P", "gi");
       var playinginfomsg = plugin.prefs['InfoFormat'];
       try {
               var song = foxyTunes.GetCurrentTrackTitle();
       } catch (e) {
               song = null;
       }
       try {
               var length = CTSeconds2TimeString(foxyTunes.GetCurrentTrackLength());
       } catch (e) {
               length = "0:00";
       }
       try {
               var pos = CTSeconds2TimeString(foxyTunes.GetCurrentTrackPosition());
       } catch (e) {
               pos = "0:00";
       }
       var typestr;
       if (song === "" || song == null) {
          song = plugin.prefs['IdleString'];
          typestr = "tunes";}
       else {
          typestr = "tunes-play";
       }
       playinginfomsg = playinginfomsg.replace(titleExp, song);
       playinginfomsg = playinginfomsg.replace(lengthExp, length);
       playinginfomsg = playinginfomsg.replace(positionExp, pos);
       display(playinginfomsg, typestr);
}

function cmdCTSearch() {
       searchStr = prompt("Enter your search parameters here:","")
       if (searchStr !=null && searchStr != "")
               dispatch("ctplay " + searchStr)
}

function DispatchCTCommand(commandname) {
       try {
               eval('foxyTunes.' + commandname + '();');
       }
       catch (err) {
               display(GetMsg('plugin.ChattyTunes.ErrorCommand') + " " + commandname + ": " + err, "tunes-error");
       }
}

function GetMsg (name) {
   var msg = client.messageManager.getMsgFrom (defaultBundle, name, null);
   if (msg == name || msg == null) {
       msg = client.messageManager.getMsgFrom (fallbackBundle, name, null);
   }
   return msg;
}
function insertSong (e) {
    InitCTObjectIfNeeded();
    var song = foxyTunes.GetCurrentTrackTitle();
    if (song == "") { song = plugin.prefs["IdleString"]; }
    var input = document.getElementById("input");
    var text = input.value;
    if(!text) {
      input.value = song;
      return;
    }
    var selStart = input.selectionStart;
    var selEnd = input.selectionEnd;
    if(selStart != selEnd){
      textBeginning = text.substring(0, selStart);
      textEnd = text.substring(selEnd);
      textBeginning += song;
      input.value = textBeginning + textEnd;
      input.selectionEnd = input.selectionStart+(selEnd-selStart);
    } else {
      textBeginning = text.substring(0, selStart);
      textEnd = text.substring(selEnd);
      if(textBeginning.match(/\s$/) ){
         textBeginning += song;
      } else if(textBeginning.match(/\"$/)) {
         var quoteNumber = textBeginning.split("\"");
         quoteNumber = quoteNumber.length-1;
         if(Math.floor(quoteNumber/2) == quoteNumber/2){
	    textBeginning += " " + song;
	 } else {
	    textBeginning += song + "\"";
	 }
      } else {
         textBeginning += " " + song;
      }
      if(!textEnd.match(/^\s/)){
         textEnd = " " + textEnd;
      }
      input.value = textBeginning + textEnd;
    }
}
function onCTKeypress(e){
    if (e.charCode === 116 && e.ctrlKey){
        InitCTObjectIfNeeded();
	var song = foxyTunes.GetCurrentTrackTitle();
        if (song == "") { song = plugin.prefs["IdleString"]; }
        var input = document.getElementById("input");
        var text = input.value;
        if(!text) {
          input.value = song;
          return;
        }
        var selStart = input.selectionStart;
        var selEnd = input.selectionEnd;
   
        if(selStart != selEnd){
          textBeginning = text.substring(0, selStart);
          textEnd = text.substring(selEnd);
          textBeginning += song;
          input.value = textBeginning + textEnd;
          input.selectionEnd = input.selectionStart+(selEnd-selStart);
        } else {
          textBeginning = text.substring(0, selStart);
          textEnd = text.substring(selEnd);
          if(textBeginning.match(/\s$/) ){
             textBeginning += song;
          } else if(textBeginning.match(/\"$/)) {
            var quoteNumber = textBeginning.split("\"");
            quoteNumber = quoteNumber.length-1;
            if(Math.floor(quoteNumber/2) == quoteNumber/2){
		textBeginning += " " + song;
	    } else {
		textBeginning += song + "\"";
	    }
          } else {
             textBeginning += " " + song;
          }
          if(!textEnd.match(/^\s/)){
             textEnd = " " + textEnd;
          }
          input.value = textBeginning + textEnd;
       }
    }
}
function textFilter(msg, msgtype){
       InitCTObjectIfNeeded();
       try {
               var song = foxyTunes.GetCurrentTrackTitle();
       } catch (e) {
               song = null;
       }
       if (song == "") { song = plugin.prefs["IdleString"]; }
       try {
               var length = CTSeconds2TimeString(foxyTunes.GetCurrentTrackLength());
       } catch (e) {
               length = "0:00";
       }
       try {
               var pos = CTSeconds2TimeString(foxyTunes.GetCurrentTrackPosition());
       } catch (e) {
               pos = "0:00";
       }
       var typestr;
       msg = msg.replace(/\$\(T\)/g, song);
       msg = msg.replace(/\$\(L\)/g, length);
       msg = msg.replace(/\$\(P\)/g, pos);
       return msg;
}