var client;

var plugin;

var replaceColorCodes;

var prefs;

var nickname;

var errNoPreview;



function onLoad() 

{

    client = window.arguments[0];

    plugin = window.arguments[1];

    replaceColorCodes = window.arguments[2];

    prefs = window.arguments[3];

    nickname = window.arguments[4];

    errNoPreview = window.arguments[5];



    //Insert values.

    var npformat = prefs.NPFormat.split(" ");

    var command = npformat.shift();

    npformat = npformat.join(" ");

    document.getElementById("CommandList").value = command;

    document.getElementById("NPFormatString").value = npformat;

    document.getElementById("IdleString").value = prefs.idleString;

    document.getElementById("InfoFormat").value = prefs.infoFormat;

    document.getElementById("SearchTriesInteger").value = prefs.maxDoubleTakes;

    document.getElementById("ErrorTriesInteger").value = prefs.maxSearchErrors;

    var nick = document.createElementNS("http://www.w3.org/1999/xhtml", "html:span");

    nick.appendChild(document.createTextNode(nickname));

    document.getElementById("nickname").appendChild(nick);

    onBoxInput();

}



function onBoxInput () 

{

    var NPFormat = document.getElementById("NPFormatString").value;

    var command = document.getElementById("CommandList").value;

    var ev = plugin.newEvent("chattytunes", "replacevalues", plugin.scope,

                             "replaceLiveEditVars");

    ev.message = NPFormat;

    ev.command = command;

    client.eventPump.addEvent(ev);

}



function fillInVars (e)

{

    var liveEdit = document.getElementById("LiveEdit");

    var liveEditRow = document.getElementById("LiveEditRow");

    var liveEditTable = document.getElementById("LiveEditTable");

    var span = document.createElementNS("http://www.w3.org/1999/xhtml", 

                                        "html:span");

    var munged = client.munger.munge(replaceColorCodes(e.message), span, {});

    var height = liveEditTable.offsetHeight;



    if (liveEdit.childNodes.length != 0)

        liveEdit.removeChild(liveEdit.childNodes[0]);



    if(e.command == "me") 

    {

        liveEditRow.setAttribute("msg-type", "ACTION");

    } 

    else if (e.command == "say")

    {

        liveEditRow.setAttribute("msg-type", "PRIVMSG");

    }

    else

    {

        var txtNode = document.createTextNode(errNoPreview);

        span = document.createElementNS("http://www.w3.org/1999/xhtml",

                                        "html:span");

        span.appendChild(txtNode);

        munged = span;

        liveEditRow.setAttribute("msg-type", "PRIVMSG");

    }

    liveEdit.appendChild(munged);



    height = liveEditTable.offsetHeight - height;

    window.outerHeight = window.outerHeight + height;

}



function doOK(event) 

{

    var ev = plugin.newEvent("chattytunes", "setprefs", plugin.scope, 

                             "setPrefs");

    ev.NPFormat = document.getElementById("CommandList").value + " " + 

                  document.getElementById("NPFormatString").value;



    ev.idleString = document.getElementById("IdleString").value;

    ev.infoFormat = document.getElementById("InfoFormat").value;

    ev.maxDoubleTakes = document.getElementById("SearchTriesInteger").value;

    ev.maxSearchErrors = document.getElementById("ErrorTriesInteger").value;

    client.eventPump.addEvent(ev);

    window.close();

}



function doCancel(event) 

{

    window.close();

}