/* -*- Mode: C++; tab-width: 4;
    dogear plugin for ChatZilla, for marking positions in chat views.
    Copyright (C) 2004  John J Foerch

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*
  About this plugin.

    This plugin provides two commands: /dogear and /de.  They both do
  the same thing.  They display a row of msg-type "DOGEAR" in the
  current view.  This row can be styled in your motif with a rule
  for |.msg[msg-type="DOGEAR"]|.


  Room for improvement.

    It would be convenient to also have a command to scroll back to the
  previous dogear.  The command could also accept an index for which
  dogear to scroll back to.  I optimistically defer that task to anyone
  interested in further developing this plugin.
*/
function initPlugin () {
    plugin.id = 'dogear';
    plugin.major = 0;
    plugin.minor = 1;
    plugin.version = plugin.major +'.'+ plugin.minor;
    plugin.description = 'for marking positions in chat views.';

    plugin.cmdlist = [
	['dogear',cmdDogEar,CMD_CONSOLE,''],
	['de',cmdDogEar,CMD_CONSOLE,'']
	];
    client.commandManager.defineCommands(plugin.cmdlist);

    client.commandManager.commands.dogear.help = dogearHelp();
    client.commandManager.commands.de.help = dogearHelp();
}

function cmdDogEar (e) {
    display (String.fromCharCode(160),'DOGEAR');
}

function dogearHelp () {
    return 'Commands /dogear and /de display a row of class "DOGEAR" '+
	'in the current view.  Style the dogear in your motif with the rule '+
	'|.msg[msg-type="DOGEAR"]|.  Please encourage motif authors to '+
	'include such a rule in their styles.';
}
