/****************************************************************************
**  DerTandemBrowser - Synchronized browsing add-on for Mozilla
**  Copyright (c) 2003  Charles Melhorn
**
**  Portions created by New Dimensions Consulting, Inc. are
**  Copyright (C) 1999 New Dimenstions Consulting
**
**  This file is part of DerTandemBrowser.
**
**  DerTandemBrowser is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  DerTandemBrowser is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
**  Or see the GNU web site at: http://www.gnu.org
**
**  Contributor(s):
**  Robert Ginda, rginda@ndcico.com, original author
**  Peter Van der Beken, peter.vanderbeken@pandora.be, necko-only version
**  Jeremie Miller, jer@jeremie.com, generalized into js socket lib (for Jabber)
**
***************************************************************************** 
***************************************************************************** 

  FILE: dtbSocket.js

  PURPOSE: Contains networking classes.

  CLASSES:

  Socket - network socket class.
  StreamListener - used to process data from asynchronous input streams.
  StreamProvider - used to supply data to asynchronous output streams.

****************************************************************************/ 


var jsenv = new Object();
jsenv.HAS_STREAM_PROVIDER = ("nsIStreamProvider" in Components.interfaces);


function toScriptableInputStream (i)
{
    var si = Components.classes["@mozilla.org/scriptableinputstream;1"];
    
    si = si.createInstance();
    si = si.QueryInterface(Components.interfaces.nsIScriptableInputStream);
    si.init(i);

    return si;
    
}


function Socket ()
{
    var sockServiceClass =
        Components.classes["@mozilla.org/network/socket-transport-service;1"];
    
    if (!sockServiceClass)
        throw ("Couldn't get socket service class.");
    
    var sockService = sockServiceClass.getService();
    if (!sockService)
        throw ("Couldn't get socket service.");

    this._sockService = sockService.QueryInterface
        (Components.interfaces.nsISocketTransportService);

    // to preserve ourselves within necko/async
    this.wrappedJSObject = this;

}


Socket.prototype.open = function(host, port, sl_observer, sp_observer)
{
    this.host = host.toLowerCase();
    this.port = port;


    if (jsenv.HAS_STREAM_PROVIDER)
     {
       this._transport = this._sockService.createTransport (host, port, null,
                                                       0, 0);
       if (!this._transport)
           throw ("Error creating transport.");  

       this._streamProvider = new StreamProvider (sp_observer);
       this._write_req = this._transport.asyncWrite (this._streamProvider, this,
                                                  0, -1, 0);
      
       this._transport.asyncRead (new StreamListener (sl_observer), this, 0, -1, 0);
     }
    else
     {
       /* use new necko interfaces */
       this._transport = this._sockService.createTransport(null, 0, host, port, null);
       if (!this._transport)
         throw ("Error creating transport.");

       var openFlags = 0;  // assumes environment has NSPR EVENT Queue
                           // so we can use non-blocking i/o
 
       /* no limit on the output stream buffer */
       this._outputStream =  this._transport.openOutputStream(openFlags, 4096, -1);
       if (!this._outputStream)
         throw "Error getting output stream.";

       this._inputStream = this._transport.openInputStream(openFlags, 0, 0);
       if (!this._inputStream)
         throw "Error getting input stream.";

       var cls = Components.classes["@mozilla.org/network/input-stream-pump;1"];
       var pump = cls.createInstance(Components.interfaces.nsIInputStreamPump);
       pump.init(this._inputStream, -1, -1, 0, 0, false);
       pump.asyncRead(new StreamListener(sl_observer), this);
     }


    this.isConnected = true;

    return this.isConnected;
  
}


Socket.prototype.close = function()
{
    
    if (this.isConnected)
     {
        this.isConnected = false;

        if ("_inputStream" in this && this._inputStream)
          this._inputStream.close();

        if ("_outputStream" in this && this._outputStream)
           this._outputStream.close();

        if ("_streamProvider" in this && this._streamProvider)
          this._streamProvider.close();
     }

}

Socket.prototype.sendData = function (str)
{
    if (!this.isConnected)
        throw "Not Connected.";

    str += "\n";  // DEBUG - Needs to be moved to higher level

    if (jsenv.HAS_STREAM_PROVIDER)
      this.asyncWrite(str);
    else
      this.sendDataNow(str);
}


Socket.prototype.asyncWrite = function (str)
{
    this._streamProvider.pendingData += str;
    if (this._streamProvider.isBlocked)
    {
        this._streamProvider.isBlocked = false;
        this._write_req.resume();
    }
}


Socket.prototype.sendDataNow =
function bc_senddatanow(str)
{
    var rv = false;
     
    try
    {
       this._outputStream.write(str, str.length);
       rv = true;
    }
    catch (ex)
    {
       //dd ("*** Caught " + ex + " while sending.")
       this.isConnected = false;
       throw (ex);
    }
     
    return rv;
 }

 
Socket.prototype.hasPendingWrite = function ()
{
    return (this._streamProvider.pendingData != "");
}


Socket.prototype.readData = function(count)
{
    if (!this.isConnected)
        throw "Not Connected.";

    var rv;

    try
    {
        rv = this._scriptableInputStream.read(count);
    }
    catch (ex)
    {
        this.isConnected = false;
        throw (ex);
    }
    
    return rv;
}

// util
Socket.prototype.toScriptableInputStream = toScriptableInputStream;



function StreamListener(observer)
{
    this._observer = observer;
}

StreamListener.prototype.onStartRequest = function (request, ctxt)
{
    //dd ("StreamListener::onStartRequest: " + request + ", " + ctxt);
}

StreamListener.prototype.onStopRequest = function (request, ctxt, status)
{
    //dd ("StreamListener::onStopRequest: " + request + ", " + ctxt + ", " +
    //status);
    if (this._observer)
        this._observer.onStreamClose(status);
}

StreamListener.prototype.onDataAvailable = function (request, ctxt, inStr,
                                                     sourceOffset, count)
{
    ctxt = ctxt.wrappedJSObject;
    if (!ctxt)
    {
        dd ("*** Can't get wrappedJSObject from ctxt in " +
            "StreamListener.onDataAvailable ***");
        return;
    }

    if (!("_scriptableInputStream" in ctxt))
      ctxt._scriptableInputStream = ctxt.toScriptableInputStream(inStr);

    if (this._observer)
      this._observer.onMsgReceived(ctxt.readData(count));
}


    
function StreamProvider(observer)
{
    this._observer = observer;
}

StreamProvider.prototype.pendingData = "";
StreamProvider.prototype.isBlocked = true;

StreamProvider.prototype.close =
function sp_close ()
{
    this.isClosed = true;
}
    
StreamProvider.prototype.onDataWritable =
function sp_datawrite (request, ctxt, ostream, offset, count)
{
    //dd ("StreamProvider.prototype.onDataWritable");
 
    if (this.isClosed)
        throw Components.results.NS_BASE_STREAM_CLOSED;
    
    if (!this.pendingData)
    {
        this.isBlocked = true;
        throw Components.results.NS_BASE_STREAM_WOULD_BLOCK;
    }
    
    var len = ostream.write (this.pendingData, this.pendingData.length);
    this.pendingData = this.pendingData.substr (len);
}

StreamProvider.prototype.onStartRequest =
function sp_startreq (request, ctxt)
{
    //dd ("StreamProvider::onStartRequest: " + request + ", " + ctxt);
}


StreamProvider.prototype.onStopRequest =
function sp_stopreq (request, ctxt, status)
{
    //dd ("StreamProvider::onStopRequest: " + request + ", " + ctxt + ", " +
    //    status);
    if (this._observer)
        this._observer.onStreamClose(status);
}


