//
//  $Id: growl.js,v 1.2 2008/12/02 22:28:10 mrtech Exp $
//
//  Copyright 2007 The Growl Project. All rights reserved.
//
// This file is under the BSD License, refer to license.txt for details

////////////////////////////////////////////////////////////////////////////////
//// Global Variables

const GROWL_EXTENSION_ID    = "growl@growl.info";
const GROWL_FRAMEWORK_NAME  = "Growl.framework";

var gGrowl;

////////////////////////////////////////////////////////////////////////////////
//// Ininilization/Destruction

window.addEventListener("load", Growl_init, false);

function Growl_init()
{
  gGrowl = new GrowlNotifications();
  gGrowl.init();
}

////////////////////////////////////////////////////////////////////////////////
//// Class GrowlNotifications

function GrowlNotifications()
{
  const nsIObserverService = Components.interfaces.nsIObserverService;
  const nsIStringBundleService = Components.interfaces.nsIStringBundleService;

  this.mObserverService = Components.classes["@mozilla.org/observer-service;1"]
                                    .getService(nsIObserverService);
}
GrowlNotifications.prototype =
{
  //////////////////////////////////////////////////////////////////////////////
  //// Methods

  /**
   * Sets up our environment to ensure that everything will work.
   */
  init: function init()
  {
    // check for mac first!
    if (!/Mac/.test(navigator.platform)) {
      Components.utils.reportError("Growl Notifications only works on OSX!");
      return;
    }

    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);
    var init = prefs.getBoolPref("extensions.growl.initialized.notifications");
    if (init) return; // we already did this, so exit gracefully

    this.mObserverService.addObserver(this, "quit-application-granted", false);

    if (Components.classes["@growl.info/application-bridge;1"]) {
      var gab = Components.classes["@growl.info/application-bridge;1"]
                          .getService(Components.interfaces.grIApplicationBridge);
      if (!gab.growlInstalled) {
        return;
      }
    }

    prefs.setBoolPref("extensions.growl.initialized.notifications", true);
  },

  observe: function observe(aSubject, aTopic, aData)
  {
    switch (aTopic) {
      case "quit-application-granted":
        var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                              .getService(Components.interfaces.nsIPrefBranch);
        prefs.setBoolPref("extensions.growl.initialized.notifications", false);

        this.mObserverService.removeObserver(this, "quit-application-granted");
        break;
      default:
        Components.utils.reportError("Unexpected topic for growl - " + aTopic);
    }
  }
};
