/* *****************************************************************************
 *******************************************************************************
 *
 * Copyright (c) 2007 eMusic.com Inc.
 *
 *   This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.  The GNU Lesser General Public License can be
 * viewed by clicking on the following link:
 *
 *   http://www.gnu.org/licenses/lgpl.html#SEC4 . 
 *
 *   This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the
 *
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor,
 *   Boston, MA  02110-1301  USA
 *
 *******************************************************************************
 *
 * Javascript source for the DLM sync services.
 *
 *******************************************************************************
 ******************************************************************************/

/*******************************************************************************
 *******************************************************************************
 *
 * DLM sync configuration.
 *
 *******************************************************************************
 ******************************************************************************/

/*
 * syncCompName                 DLM sync component name.
 * syncAppName                  DLM sync application name.
 * testSyncDir                  Directory to use for sync testing.
 */

var DLMSyncConfig = {}

DLMSyncConfig.syncCompName = "";
DLMSyncConfig.syncAppName = ""

//DLMSyncConfig.syncCompName = "@emusic.com/DLM/iTunes;1";
//DLMSyncConfig.syncAppName = "iTunes"

//DLMSyncConfig.syncCompName = "@emusic.com/DLM/WMP;1";
//DLMSyncConfig.syncAppName = "WMP"

//DLMSyncConfig.syncCompName = "@emusic.com/DLM/Winamp;1";
//DLMSyncConfig.syncAppName = "Winamp"

/*******************************************************************************
 *******************************************************************************
 *
 * DLM sync services.
 *
 *******************************************************************************
 ******************************************************************************/

var DLMSync =
{
    /***************************************************************************
     *
     * DLM sync services fields.
     *
     **************************************************************************/

    /*
     * mDLMSync                 DLM sync component object.
     * mFileProtocolHandler     nsIFileProtocolHandler object.
     */

    mDLMSync: null,
    mFileProtocolHandler: null,


    /***************************************************************************
     *
     * DLM sync services functions.
     *
     **************************************************************************/

    /*
     * initialize
     *
     *   This function initializes the DLM sync services.
     */

    initialize: function() {
        try { this.initialize1(); }
        catch (err) { edebug ("Exception", err); }
    },

    initialize1: function() {
        /* Get an instance of the DLM sync component and initialize it. */
        this.mDLMSync = Cc[DLMSyncConfig.syncCompName].
                            createInstance(Ci.emIDLMSync);
        this.mDLMSync.initialize();

        /* Do nothing if sync target application is not present. */
        if (!this.mDLMSync.isAppPresent()) {
            edebug(DLMSyncConfig.syncAppName, " not present.");
            return;
        }

        /* Get an nsIFileProtocolHandler. */
        this.mFileProtocolHandler = Cc["@mozilla.org/network/protocol;1?name=file"].
                                      createInstance(Ci.nsIFileProtocolHandler);

    },


    /*
     * addMedia
     *
     *   --> mediaList              List of media file paths to add.
     *
     *   This function adds the media items whose file paths are contained in
     * the list specified by mediaPathList.
     *   The paths may either be individual file paths or whole directory paths,
     * in which case all of the media files within the directory will be added.
     */

    addMedia: function(mediaList, trackGenre, albumArt) {
        var                         exMediaList = [];
        var                         i;
        var                         result;

        /* Expand the media list. */
        for (i = 0; i < mediaList.length; i++) {
          result = this.expandMediaList(exMediaList, mediaList[i]);
        }

        /* Add the media. */
        try {
          if (mediaManagers[eMediaSync].observerInitialized == false) {
            mediaManagers[eMediaSync].initObserver();
          };
        } catch(ex) {
          edebug(ex);
        }

        try {
          this.mDLMSync.addMedia(exMediaList.length, exMediaList, DLMSync, trackGenre, albumArt);
        } catch (ex) {
          eMuNotifier("emusic-download-next", null);          
          edebug(ex);

          eShowAlerts = true
          gHadDownloadErrorsMsg = "Syncing Error: please reinstall " + mediaManagers[eMediaSync].appName;
          gHadDownloadErrors = true
        }
    },

    createPlaylist: function(mediaList) {
        var                         exMediaList = [];
        var                         i;
        var                         result;

        /* Expand the media list. */
        for (i = 0; i < mediaList.length; i++) {
          result = this.expandMediaList(exMediaList, mediaList[i]);
        }

        /* Add the media. */
        // if (eMusicPlatform.ident == "WINNT") {
          // var th = new addMediaThread({run: function() { DLMSync.mDLMSync.createPlaylist(exMediaList.length, exMediaList, DLMSync); }});
        // } else {
        try {
          this.mDLMSync.createPlaylist(exMediaList.length, exMediaList, DLMSync);
          ePlaylistQueue = new Array;
        } catch (ex) {
          edebug(ex);
        }
        // }
    },    
    /***************************************************************************
     *
     * DLM sync services emIDLMSyncListener functions.
     *
     **************************************************************************/

    /*
     * addMediaCompleted
     *
     *   --> mediaPath              File path of added media.
     *   --> status                 Status of added media.
     *
     *   This function is called when addition of the media with the file path
     * specified by mediaPath completes, successfully or not.  The final status
     * is specified by status and is set to one of the values in the add media
     * completion status definition set.
     */

    addMediaCompleted: function(mediaPath, status) {
        if (mediaPath == "playlist") {
          if (status == Ci.emIDLMSyncListener.STATUS_SUCCEEDED) {
            edebug(  "Track added to Playlist in " + DLMSyncConfig.syncAppName);
          } else {
            edebug(  "Track not added to Playlist in " + DLMSyncConfig.syncAppName);
          }

          eMuNotifier("emusic-refresh-list", null);
          reselectTrack();
        } else {
          var thisMediaSync = nsPreferences.copyUnicharPref("eMusic.defaultMediaSync");

          var emusicDatabase = Cc["@emusic.com/emusic/database;1"].getService(Ci.nsIEmusicDatabase);
          emusicDatabase.updateDownloadState(mediaPath, 1);
          emusicDatabase.updateDownloadProgress(mediaPath, 100);

          if (status == Ci.emIDLMSyncListener.STATUS_SUCCEEDED || thisMediaSync == "Winamp") {
            edebug("Synced \"" + mediaPath + "\" to " + DLMSyncConfig.syncAppName + "\n");
          } else {
            eShowAlerts = true
            gHadDownloadErrorsMsg = "Error Syncing to " + mediaManagers[eMediaSync].appName;
            gHadDownloadErrors = true
            edebug("Failed to Sync \"" + mediaPath + "\" to " + DLMSyncConfig.syncAppName + "\n");
          }

          toggleTotalProgress(true)
          //var mainWindow = dlm_base.mostRecentWindow("emusic:window");
          if (eActiveDownloadCount == 0) {
            toggleTotalProgress(false);
          } else{
            eMuNotifier("emusic-download-next", null);
          }
          reselectTrack(mediaPath);
        }
    },

    /***************************************************************************
     *
     * Private DLM sync services functions.
     *
     **************************************************************************/

    /*
     * expandMediaList
     *
     *   --> mediaList              Media list into which to expand.
     *   --> mediaPath              Media file path.
     *
     *   This function expands the media list specified by mediaList with the
     * media whose file path is specified by mediaPath.  If the media file path
     * is for a file, it is simply added to the media list.  If the media file
     * path is a directory, its media content is added to the media list.
     */

    expandMediaList: function(mediaList, mediaPath) {
        var                         mediaFile;
        var                         mediaSubFile;
        var                         fileEnum;
        /* Get the media file object. */
        mediaFile = Cc["@mozilla.org/file/local;1"].
                            createInstance(Ci.nsILocalFile);
        mediaFile.initWithPath(mediaPath);

        /* If the media file path is a directory, expand its contents. */
        /* Otherwise, add it to the list if it's not already present.  */
        if (mediaFile.isDirectory()) {
            fileEnum = mediaFile.directoryEntries;
            while (fileEnum.hasMoreElements()) {
                mediaSubFile = fileEnum.getNext().
                                QueryInterface(Ci.nsIFile);
                this.expandMediaList(mediaList, mediaSubFile.path);
            }
        } else {
            if (this.isMediaFile(mediaFile)
                  && !this.mDLMSync.isMediaPresent(mediaPath)) {
                mediaList.push(mediaPath);
            }
        }
    },


    /*
     * isMediaFile
     *
     *   --> mediaFile              Media nsIFile object.
     *
     *   <--                        True if the file is a media file.
     *
     *   This function checks if the file specified by mediaFile is a media
     * file.  If it is, this function returns true; otherwise, it returns false.
     */

    isMediaFile: function(mediaFile) {
        var                         mediaURI;
        var                         mediaURL;
        var                         fileExt;
        var                         isMediaFile = false;

        /* Get a media nsIURL object. */
        mediaURI = this.mFileProtocolHandler.newFileURI(mediaFile);
        mediaURL = Cc["@mozilla.org/network/standard-url;1"].
                        createInstance(Ci.nsIStandardURL);
        mediaURL.init(Ci.nsIStandardURL.URLTYPE_STANDARD,
                      0,
                      null,
                      null,
                      mediaURI);
        mediaURL = mediaURL.QueryInterface(Ci.nsIURL);

        /* Check the file extension for a media type. */
        fileExt = mediaURL.fileExtension.toLowerCase();

        if (fileExt == "mp3") {
          isMediaFile = true;
        }

        return (isMediaFile);
    }
};

//http://www.koders.com/javascript/fid0A884B116CE1EBD8E4C76F9FFE2AB99FFC6D7019.aspx?s=nsIThread
//http://mb.eschew.org/16#listing_16.5
//http://groups.google.pl/group/mozilla.dev.extensions/browse_thread/thread/6f92a518f201ae25
