#include <stdio.h>
#include <io.h>
#include <sys/stat.h>
#include "nsLinkSaver.h"
#include "nsMemory.h"
#include "nsCOMPtr.h"
#include "nsString2.h"

// include any of the other classes we reference
#include "nsIDocument.h"
#include "nsIDOMHTMLAnchorElement.h"
#include "nsIDomNodeList.h"

// Macro that expands to the implementation of AddRef, Release, and
// QueryInterface, as well as some of the support classes needed
// by the module registration macros. The "1" in ISUPPORTS1 means
// we only implement one interface (nsISupports is impliclit).
NS_IMPL_ISUPPORTS1_CI(nsLinkSaverImpl, nsILinkSaver);

//
// nsLinkeSaverImpl ctor
//
nsLinkSaverImpl::nsLinkSaverImpl()
{
 NS_INIT_ISUPPORTS();
}

//
// nsSimpleImpl dtor
//
nsLinkSaverImpl::~nsLinkSaverImpl()
{
  // nothing
}

//
// SaveLinks
//
// Implementation of the saveLinks() method on nsILinkSaver. Note that the return
// value in the IDL becomes an "out" parameter. The actual C++ return value 
// of all XPCOM methods is an error code. XPConnect massages things so
// that to javascript it appears as declared in the IDL. Another reason
// why it's easier to work in JavaScript.
//
NS_IMETHODIMP
nsLinkSaverImpl::SaveLinks(nsIDOMDocument* inDoc, PRBool* outSuccess)
{
  // the same object that implements nsIDOMDocument also implements the
  // (non-scriptable) nsIDocument interface. We use QueryInterface to
  // go from one to the other.
	
	nsCOMPtr<nsIDocument> doc ( do_QueryInterface(inDoc) );
 
	nsAutoString sTitle;
	//get the title of the page
	if (doc) {
	  doc->GetDocumentTitle( sTitle );
	}
  
	// Sanitize the title of all illegal characters
	sTitle.CompressWhitespace();     // Remove whitespace from the ends
	sTitle.StripChars("\\*|:\"><?"); // Strip illegal characters
	sTitle.ReplaceChar('.', L'_');   // Dots become underscores
	sTitle.ReplaceChar('/', L'-');   // Forward slashes become hyphens
	sTitle.ReplaceChar(' ', L'_');   // Spaces become underscores

	//convert title to c string
	char tmpTitle[128] = {'\0'};
	sTitle.ToCString(tmpTitle, sizeof(tmpTitle));

	//check to see if file already exists
	struct stat my_stat;
	if(stat(tmpTitle, &my_stat) == 0)
	{
		*outSuccess = PR_FALSE;
		return NS_OK;
	}
	//open file with that name
	FILE* linksFile = fopen(tmpTitle, "w");

	//node list counter
	PRUint32 count; 
	
	nsCOMPtr<nsIDOMNodeList> nodeList;
	
	//get elements 
	inDoc->GetElementsByTagName(NS_LITERAL_STRING("a"), getter_AddRefs(nodeList));

	//get number of nodes count
	nodeList->GetLength(&count);

	//no links than error
	if (count < 1)
	{
		fprintf(linksFile, "no links");
	}
	else
	{
		//iterate through node list
		PRUint32 i = 0;
		nsresult res;
		
		nsAutoString sUrl;
		char tmpUrl[128] = {'\0'};
		for(i=0; i < count; i++)
		{ 
			nsCOMPtr<nsIDOMNode> curr;
			res = nodeList->Item(i, getter_AddRefs(curr));
  		
       		PRUint16 nodeType = 0;
     		curr->GetNodeType(&nodeType);
     		if ( nodeType == nsIDOMNode::ELEMENT_NODE ) 
			{
       			
       			nsCOMPtr<nsIDOMHTMLAnchorElement> a(do_QueryInterface(curr));
       			if (a) {
       				//found an anchor
					a->GetHref(sUrl);
					sUrl.ToCString(tmpUrl, sizeof(tmpUrl));
					fprintf(linksFile, "%s\n", tmpUrl);
    			}
			}
		
		}
	}
    //close file 
	fclose(linksFile);


  // set the boolean return result to true
  *outSuccess = PR_TRUE;

  // return success to XPCOM. Returning failure here indicates an error
  // and XPConnect will throw an exception in JavaScript. 
  return NS_OK;
}


//***************************************************************
//***************************************************************

//
// Module info
//
// Most examples have the module in a separate file, but there's no
// need to do that. Change the macros and class names to reference
// your own class.
//

#include "nsIGenericFactory.h"

NS_GENERIC_FACTORY_CONSTRUCTOR(nsLinkSaverImpl)

NS_DECL_CLASSINFO(nsLinkSaverImpl)
static nsModuleComponentInfo components[] =
{
  { "LinkSaver component",        // description, for us humans
    NS_LINKSAVER_CID,             // in nsSimple.h
    NS_LINKSAVER_PROG_ID,         // in nsSimple.h
    nsLinkSaverImplConstructor,
    NULL,                      // registration proc, unused
    NULL,                      // unreg proc, unused
    NULL,
    NS_CI_INTERFACE_GETTER_NAME(nsLinkSaverImpl),
    NULL,
    &NS_CLASSINFO_NAME(nsLinkSaverImpl)
  }
};
NS_IMPL_NSGETMODULE(nsLinkSaverModule, components)
