/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.mozilla.jrex.JRexFactory;
import org.mozilla.jrex.dom.JRexDocumentImpl;
import org.mozilla.jrex.event.context.ContextMenuEvent;
import org.mozilla.jrex.event.context.ContextMenuListener;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.ui.JRexPopupMenu;
import org.mozilla.jrex.ui.JRexResource;
import org.mozilla.jrex.window.JRexWindowManager;

public class JRexPopupMenuImpl
implements JRexPopupMenu,
ActionListener,
ContextMenuListener {
    private static final String className = (class$org$mozilla$jrex$ui$JRexPopupMenuImpl == null ? (class$org$mozilla$jrex$ui$JRexPopupMenuImpl = JRexPopupMenuImpl.class$("org.mozilla.jrex.ui.JRexPopupMenuImpl")) : class$org$mozilla$jrex$ui$JRexPopupMenuImpl).getName();
    private static final String PM_BACK = JRexResource.getString("TL_BACK");
    private static final String PM_FORWARD = JRexResource.getString("TL_FORWARD");
    private static final String PM_RELOAD = JRexResource.getString("TL_RELOAD");
    private static final String PM_STOP = JRexResource.getString("TL_STOP");
    private static final String PM_BOOK_MARK = JRexResource.getString("PM_BOOK_MARK");
    private static final String PM_SAVE_PAGE = JRexResource.getString("FL_SAVE_PAGE");
    private static final String PM_SEND_PAGE = JRexResource.getString("FL_SEND_PAGE");
    private static final String PM_PAGE_SRC = JRexResource.getString("VW_PAGE_SRC");
    private static final String PM_VIEW_BG_IMG = JRexResource.getString("PM_VIEW_BG_IMG");
    private static final String PM_PAGE_INFO = JRexResource.getString("TOOL_PAGE_INFO");
    private static final String PM_OPEN_WIN = JRexResource.getString("PM_OPEN_WIN");
    private static final String PM_OPEN_TAB = JRexResource.getString("PM_OPEN_TAB");
    private static final String PM_SAVE_LINK = JRexResource.getString("PM_SAVE_LINK");
    private static final String PM_SEND_LINK = JRexResource.getString("PM_SEND_LINK");
    private static final String PM_CPY_LINK_LOC = JRexResource.getString("PM_CPY_LINK_LOC");
    private static final String PM_UNDO = JRexResource.getString("ED_UNDO");
    private static final String PM_REDO = JRexResource.getString("ED_REDO");
    private static final String PM_CUT = JRexResource.getString("ED_CUT");
    private static final String PM_COPY = JRexResource.getString("ED_COPY");
    private static final String PM_PASTE = JRexResource.getString("ED_PASTE");
    private static final String PM_DELETE = JRexResource.getString("ED_DELETE");
    private static final String PM_SELECT_ALL = JRexResource.getString("ED_SELECT_ALL");
    private static final String PM_VIEW_IMG = JRexResource.getString("PM_VIEW_IMG");
    private static final String PM_CPY_IMG_LOC = JRexResource.getString("PM_CPY_IMG_LOC");
    private static final String PM_CPY_IMG_CONT = JRexResource.getString("PM_CPY_IMG_CONT");
    private static final String PM_SAVE_IMG = JRexResource.getString("PM_SAVE_IMG");
    private static final String PM_SEND_IMG = JRexResource.getString("PM_SEND_IMG");
    private static final String PM_SET_WAL_PPER = JRexResource.getString("PM_SET_WAL_PPER");
    private static final String PM_BLOCK_IMG = JRexResource.getString("PM_BLOCK_IMG");
    private static final String PM_PROPERTIES = JRexResource.getString("PM_PROPERTIES");
    private ArrayList linkPopupItems;
    private ArrayList imgPopupItems;
    private ArrayList docPopupItems;
    private ArrayList textPopupItems;
    private JPopupMenu mainPopup = new JPopupMenu("Context Menu");
    private JRexCanvas browser;
    private ContextMenuEvent event;
    private int mode;
    private JRexWindowManager windowManager = (JRexWindowManager)JRexFactory.getInstance().getImplInstance("WindowManager");
    static /* synthetic */ Class class$org$mozilla$jrex$ui$JRexPopupMenuImpl;

    public synchronized void setBrowser(JRexCanvas browser) {
        if (this.browser != null) {
            this.browser.removeContextMenuListener(this);
        }
        this.browser = browser;
        browser.addContextMenuListener(this);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    private final JMenuItem createMenuItem(String itemCmd) {
        JMenuItem menuItem = new JMenuItem(itemCmd);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(itemCmd));
        menuItem.addActionListener(this);
        return menuItem;
    }

    private final void addLinkPopupMenu() {
        if (this.linkPopupItems == null) {
            this.linkPopupItems = new ArrayList(9);
            this.linkPopupItems.add(this.createMenuItem(PM_OPEN_WIN));
            this.linkPopupItems.add(this.createMenuItem(PM_OPEN_TAB));
            this.linkPopupItems.add(this.createMenuItem(PM_BOOK_MARK));
            this.linkPopupItems.add(this.createMenuItem(PM_SAVE_LINK));
            this.linkPopupItems.add(this.createMenuItem(PM_SEND_LINK));
            this.linkPopupItems.add(this.createMenuItem(PM_CPY_LINK_LOC));
            this.linkPopupItems.add(this.createMenuItem(PM_PROPERTIES));
        }
        int len = this.linkPopupItems.size();
        int i = 0;
        while (i < len) {
            if (i == 2 || i == 6) {
                this.mainPopup.addSeparator();
            }
            this.mainPopup.add((JMenuItem)this.linkPopupItems.get(i));
            ++i;
        }
    }

    private final void addDocumentPopupMenu(boolean isBGImg) {
        if (this.docPopupItems == null) {
            this.docPopupItems = new ArrayList(9);
            this.docPopupItems.add(this.createMenuItem(PM_BACK));
            this.docPopupItems.add(this.createMenuItem(PM_FORWARD));
            this.docPopupItems.add(this.createMenuItem(PM_RELOAD));
            this.docPopupItems.add(this.createMenuItem(PM_STOP));
            this.docPopupItems.add(this.createMenuItem(PM_BOOK_MARK));
            this.docPopupItems.add(this.createMenuItem(PM_SAVE_PAGE));
            this.docPopupItems.add(this.createMenuItem(PM_SEND_PAGE));
            this.docPopupItems.add(this.createMenuItem(PM_VIEW_BG_IMG));
            this.docPopupItems.add(this.createMenuItem(PM_PAGE_SRC));
            this.docPopupItems.add(this.createMenuItem(PM_PAGE_INFO));
        }
        int len = this.docPopupItems.size();
        int i = 0;
        while (i < len) {
            if (i == 4 || i == 7 || i == 8) {
                this.mainPopup.addSeparator();
            }
            this.mainPopup.add((JMenuItem)this.docPopupItems.get(i));
            ++i;
        }
        ((JMenuItem)this.docPopupItems.get(7)).setEnabled(isBGImg);
    }

    private final void addImagePopupMenu() {
        if (this.imgPopupItems == null) {
            this.imgPopupItems = new ArrayList(10);
            this.imgPopupItems.add(this.createMenuItem(PM_VIEW_IMG));
            this.imgPopupItems.add(this.createMenuItem(PM_CPY_IMG_LOC));
            this.imgPopupItems.add(this.createMenuItem(PM_CPY_IMG_CONT));
            this.imgPopupItems.add(this.createMenuItem(PM_SAVE_IMG));
            this.imgPopupItems.add(this.createMenuItem(PM_SEND_IMG));
            this.imgPopupItems.add(this.createMenuItem(PM_SET_WAL_PPER));
            this.imgPopupItems.add(this.createMenuItem(PM_BLOCK_IMG));
            this.imgPopupItems.add(this.createMenuItem(PM_PROPERTIES));
        }
        int len = this.imgPopupItems.size();
        int i = 0;
        while (i < len) {
            if (i == 3 || i == 7) {
                this.mainPopup.addSeparator();
            }
            this.mainPopup.add((JMenuItem)this.imgPopupItems.get(i));
            ++i;
        }
    }

    private final void addTextAreaPopupMenu() {
        if (this.textPopupItems == null) {
            this.textPopupItems = new ArrayList(9);
            this.textPopupItems.add(this.createMenuItem(PM_UNDO));
            this.textPopupItems.add(this.createMenuItem(PM_REDO));
            this.textPopupItems.add(this.createMenuItem(PM_CUT));
            this.textPopupItems.add(this.createMenuItem(PM_COPY));
            this.textPopupItems.add(this.createMenuItem(PM_PASTE));
            this.textPopupItems.add(this.createMenuItem(PM_DELETE));
            this.textPopupItems.add(this.createMenuItem(PM_SELECT_ALL));
        }
        int len = this.textPopupItems.size();
        int i = 0;
        while (i < len) {
            if (i == 2 || i == 6) {
                this.mainPopup.addSeparator();
            }
            this.mainPopup.add((JMenuItem)this.textPopupItems.get(i));
            ++i;
        }
    }

    public void showContextMenu(ContextMenuEvent ce) {
        if (JRexL.on) {
            JRexL.log(className, "**** showContextMenu() -->ce <" + ce + "> ****");
        }
        this.event = ce;
        int ctxtFlags = this.event.getContextFlags();
        if (JRexL.on) {
            JRexL.log(className, "**** showContextMenu() -->ctxtFlags <" + ctxtFlags + "> ****");
        }
        if (this.mainPopup.isVisible() || ctxtFlags == 0) {
            return;
        }
        this.mainPopup.removeAll();
        if ((ctxtFlags & 1) == 1) {
            if (JRexL.on) {
                JRexL.log(className, "**** showContextMenu() -->CONTEXT_LINK ****");
            }
            this.addLinkPopupMenu();
        }
        if ((ctxtFlags & 2) == 2) {
            if (JRexL.on) {
                JRexL.log(className, "**** showContextMenu() -->CONTEXT_IMAGE ****");
            }
            this.addImagePopupMenu();
        }
        if ((ctxtFlags & 4) == 4) {
            boolean isBGImg;
            boolean bl = isBGImg = (ctxtFlags & 0x20) == 32;
            if (JRexL.on) {
                JRexL.log(className, "**** showContextMenu() --> isBGImg <" + isBGImg + "> CONTEXT_DOCUMENT ****");
            }
            this.addDocumentPopupMenu(isBGImg);
        }
        if ((ctxtFlags & 8) == 8) {
            if (JRexL.on) {
                JRexL.log(className, "**** showContextMenu() -->CONTEXT_TEXT ****");
            }
            this.addTextAreaPopupMenu();
        }
        if ((ctxtFlags & 0x10) == 16) {
            if (JRexL.on) {
                JRexL.log(className, "**** showContextMenu() -->CONTEXT_INPUT ****");
            }
            this.addDocumentPopupMenu(false);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JRexPopupMenuImpl.this.mainPopup.show(JRexPopupMenuImpl.this.browser, JRexPopupMenuImpl.this.event.getClientX(), JRexPopupMenuImpl.this.event.getClientY());
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
        if (JRexL.on) {
            JRexL.log(className, "**** actionPerformed() -->action <" + action + "> event<" + this.event + "> ****");
        }
        try {
            if (action.equals(PM_BACK)) {
                this.browser.getNavigator().goBack();
                return;
            }
            if (action.equals(PM_FORWARD)) {
                this.browser.getNavigator().goForward();
                return;
            }
            if (action.equals(PM_RELOAD)) {
                this.browser.getNavigator().reload(0);
                return;
            }
            if (action.equals(PM_STOP)) {
                this.browser.getNavigator().stop(3);
                return;
            }
            if (action.equals(PM_BOOK_MARK)) return;
            if (action.equals(PM_SAVE_PAGE)) {
                if (JRexL.on) {
                    JRexL.log(className, "**** actionPerformed() -->DOC <" + this.browser.getNavigator().getDocument() + "> ****");
                }
                if (!JRexL.on) return;
                JRexL.log(className, "**** actionPerformed() -->RANGE <" + ((JRexDocumentImpl)this.browser.getNavigator().getDocument()).getDocumentRange() + "> ****");
                return;
            }
            if (action.equals(PM_SEND_PAGE)) {
                if (JRexL.on) {
                    JRexL.log(className, "**** actionPerformed() -->MouseEvents <" + ((JRexDocumentImpl)this.browser.getNavigator().getDocument()).getDocumentEvent().createEvent("MouseEvents") + "> ****");
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** actionPerformed() -->MutationEvents <" + ((JRexDocumentImpl)this.browser.getNavigator().getDocument()).getDocumentEvent().createEvent("MutationEvents") + "> ****");
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** actionPerformed() -->Events <" + ((JRexDocumentImpl)this.browser.getNavigator().getDocument()).getDocumentEvent().createEvent("Events") + "> ****");
                }
                if (!JRexL.on) return;
                JRexL.log(className, "**** actionPerformed() -->View <" + ((JRexDocumentImpl)this.browser.getNavigator().getDocument()).getDocumentView() + "> ****");
                return;
            }
            if (action.equals(PM_PAGE_SRC) || action.equals(PM_VIEW_BG_IMG)) return;
            if (action.equals(PM_OPEN_WIN)) {
                this.windowManager.openNewWindow(this.browser.getJRexPeer(), this.event != null ? this.event.getURI() : "", 0);
                return;
            }
            if (action.equals(PM_OPEN_TAB)) {
                this.windowManager.openNewTab(this.browser.getJRexPeer(), this.event != null ? this.event.getURI() : "", 0);
                return;
            }
            if (action.equals(PM_SAVE_LINK)) return;
            if (action.equals(PM_SEND_LINK)) {
                String data = this.event != null ? this.event.getURI() : "";
                this.browser.getNavigator().loadURI("mailto:?subject=" + data + "&body=" + data, 0, null, null, null);
                return;
            }
            if (action.equals(PM_CPY_LINK_LOC)) {
                this.browser.copyLinkLocation();
                return;
            }
            if (action.equals(PM_UNDO)) {
                this.browser.undo();
                return;
            }
            if (action.equals(PM_REDO)) {
                this.browser.redo();
                return;
            }
            if (action.equals(PM_CUT)) {
                this.browser.cut();
                return;
            }
            if (action.equals(PM_COPY)) {
                this.browser.copy();
                return;
            }
            if (action.equals(PM_PASTE)) {
                this.browser.paste();
                return;
            }
            if (action.equals(PM_DELETE)) {
                this.browser.delete();
                return;
            }
            if (action.equals(PM_SELECT_ALL)) {
                this.browser.selectAll();
                return;
            }
            if (action.equals(PM_VIEW_IMG)) {
                this.browser.copyLinkLocation();
                return;
            }
            if (action.equals(PM_CPY_IMG_LOC)) {
                this.browser.copyImageLocation();
                return;
            }
            if (!action.equals(PM_SAVE_IMG) && !action.equals(PM_SEND_IMG) && !action.equals(PM_SET_WAL_PPER) && !action.equals(PM_BLOCK_IMG) && !action.equals(PM_PROPERTIES)) return;
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

