/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.mozilla.jrex.event.history.HistoryEvent;
import org.mozilla.jrex.event.history.HistoryListener;
import org.mozilla.jrex.event.history.IntegerEventParam;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.navigation.History;
import org.mozilla.jrex.navigation.HistoryEntry;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.ui.JRexResource;
import org.mozilla.jrex.ui.JRexToolBar;

public class JRexToolBarImpl
implements JRexToolBar,
ActionListener,
HistoryListener {
    private static final String className = (class$org$mozilla$jrex$ui$JRexToolBarImpl == null ? (class$org$mozilla$jrex$ui$JRexToolBarImpl = JRexToolBarImpl.class$("org.mozilla.jrex.ui.JRexToolBarImpl")) : class$org$mozilla$jrex$ui$JRexToolBarImpl).getName();
    private static final String homeUrl = "about:blank";
    private static final String TL_BACK;
    private static final String TL_FORWARD;
    private static final String TL_RELOAD;
    private static final String TL_STOP;
    private static final String TL_HOME;
    private static final String TL_PRINT;
    private static final String TL_GO;
    private static final String LOC_ACT_CMD = "LOC_ACT_CMD";
    private JButton back;
    private JButton forward;
    private JButton reload;
    private JButton stop;
    private JButton home;
    private JButton print;
    private JButton go;
    private JComboBox locationCombo;
    private JTextComponent locComboEditor;
    private JRexCanvas browser;
    private long chromeFlags;
    private JComponent toolBar;
    private boolean toolBarCreated = false;
    static /* synthetic */ Class class$org$mozilla$jrex$ui$JRexToolBarImpl;

    public void setModeAndChrome(int mode, long chromeFlags) {
        this.chromeFlags = chromeFlags;
    }

    public synchronized void setBrowser(JRexCanvas browser) {
        if (this.browser != null) {
            this.browser.removeHistoryListener(this);
        }
        this.browser = browser;
        if (this.locationCombo != null) {
            this.locationCombo.removeActionListener(this);
            History his = null;
            try {
                his = browser.getNavigator().getSessionHistory();
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
            if (JRexL.on) {
                JRexL.log(className, "**** setBrowser() -->his <" + his + ">****");
            }
            if (his != null) {
                Iterator iterator = his.elements().iterator();
                while (iterator.hasNext()) {
                    HistoryEntry item = (HistoryEntry)iterator.next();
                    if (JRexL.on) {
                        JRexL.log(className, "**** setBrowser() -->item <" + item + ">****");
                    }
                    if (((DefaultComboBoxModel)this.locationCombo.getModel()).getIndexOf(item.getURI()) >= 0) continue;
                    this.locationCombo.addItem(item.getURI());
                }
            }
            String currURI = "";
            try {
                URI temp = browser.getNavigator().getCurrentURI();
                currURI = temp == null ? "" : temp.toString();
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
            if (JRexL.on) {
                JRexL.log(className, "**** setBrowser() -->currURI <" + currURI + ">****");
            }
            this.locationCombo.setSelectedItem(currURI);
            this.locationCombo.addActionListener(this);
        }
        browser.addHistoryListener(this);
    }

    public JComponent getToolBar() {
        if (!this.toolBarCreated) {
            this.createToolBar();
        }
        return this.toolBar;
    }

    private void createToolBar() {
        this.toolBarCreated = true;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(gbl);
        panel.setPreferredSize(new Dimension(200, 32));
        int i = 0;
        Insets inset = new Insets(0, 6, 0, 0);
        if ((0x20L & this.chromeFlags) == 32L) {
            this.back = this.createButton(TL_BACK);
            JRexToolBarImpl.addCompToGridBag(this.back, panel, gbc, gbl, i++, 0, 1, 1, 0.0, 0.0, 17, 0, inset, 0, 0);
            this.forward = this.createButton(TL_FORWARD);
            JRexToolBarImpl.addCompToGridBag(this.forward, panel, gbc, gbl, i++, 0, 1, 1, 0.0, 0.0, 17, 0, inset, 0, 0);
            this.reload = this.createButton(TL_RELOAD);
            JRexToolBarImpl.addCompToGridBag(this.reload, panel, gbc, gbl, i++, 0, 1, 1, 0.0, 0.0, 17, 0, inset, 0, 0);
            this.stop = this.createButton(TL_STOP);
            JRexToolBarImpl.addCompToGridBag(this.stop, panel, gbc, gbl, i++, 0, 1, 1, 0.0, 0.0, 17, 0, inset, 0, 0);
            this.home = this.createButton(TL_HOME);
            JRexToolBarImpl.addCompToGridBag(this.home, panel, gbc, gbl, i++, 0, 1, 1, 0.0, 0.0, 17, 0, inset, 0, 0);
            this.print = this.createButton(TL_PRINT);
            JRexToolBarImpl.addCompToGridBag(this.print, panel, gbc, gbl, i++, 0, 1, 1, 0.0, 0.0, 17, 0, inset, 0, 0);
        }
        if ((0x40L & this.chromeFlags) == 64L) {
            this.locationCombo = new JComboBox();
            this.locComboEditor = (JTextComponent)this.locationCombo.getEditor().getEditorComponent();
            this.locationCombo.setEditable(true);
            this.locationCombo.setPreferredSize(new Dimension(200, 22));
            this.locationCombo.addActionListener(this);
            this.locationCombo.setActionCommand(LOC_ACT_CMD);
            Insets cinset = new Insets(10, 10, 0, 0);
            JRexToolBarImpl.addCompToGridBag(this.locationCombo, panel, gbc, gbl, i++, 0, 1, 1, 1.0, 0.0, 17, 2, cinset, 0, 0);
            this.go = this.createButton(TL_GO);
            Insets ginset = new Insets(10, 2, 0, 2);
            this.go.setPreferredSize(new Dimension(22, 22));
            JRexToolBarImpl.addCompToGridBag(this.go, panel, gbc, gbl, i++, 0, 1, 1, 0.0, 0.0, 17, 0, ginset, 0, 0);
        }
        if ((0x100L & this.chromeFlags) == 256L) {
            // empty if block
        }
        this.toolBar = panel.getComponentCount() < 1 ? null : panel;
    }

    private JButton createButton(String name) {
        JButton b = new JButton(JRexResource.getIcon(name));
        b.setActionCommand(name);
        b.setToolTipText(name);
        b.setPreferredSize(new Dimension(30, 30));
        b.setBorderPainted(false);
        b.setFocusable(false);
        b.addActionListener(this);
        return b;
    }

    private static final void addCompToGridBag(Component comp, JPanel panel, GridBagConstraints gbc, GridBagLayout gbl, int gx, int gy, int gw, int gh, double wx, double wy, int anchor, int fill, Insets i, int ix, int iy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.insets = i;
        gbc.ipadx = ix;
        gbc.ipady = iy;
        gbl.setConstraints(comp, gbc);
        panel.add(comp);
    }

    private final void processRequest() throws JRexException {
        block4: {
            String url = this.locComboEditor.getText();
            if (JRexL.on) {
                JRexL.log(className, "**** processRequest() -->url <" + url + ">****");
            }
            if ((url = url.trim()) == "") {
                return;
            }
            try {
                URI myURI = new URI(url);
                this.browser.getNavigator().loadURI(myURI.toASCIIString(), 0, null, null, null);
            }
            catch (URISyntaxException uex) {
                if (!JRexL.on) break block4;
                JRexL.printStackTrace(uex);
            }
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
        if (JRexL.on) {
            JRexL.log(className, "**** actionPerformed() -->action <" + action + ">****");
        }
        try {
            if (action.equals(TL_BACK)) {
                this.browser.getNavigator().goBack();
            } else if (action.equals(TL_FORWARD)) {
                this.browser.getNavigator().goForward();
            } else if (action.equals(TL_RELOAD)) {
                this.browser.getNavigator().reload(0);
            } else if (action.equals(TL_STOP)) {
                this.browser.getNavigator().stop(3);
            } else if (action.equals(TL_HOME)) {
                this.browser.getNavigator().loadURI(homeUrl, 0, null, null, null);
            } else if (action.equals(TL_PRINT)) {
                this.browser.print(true, true);
            } else if (action.equals(TL_GO)) {
                this.processRequest();
            } else if (action.equals(LOC_ACT_CMD)) {
                this.processRequest();
            }
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void addEntry(HistoryEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** addEntry() -->event<" + event + "> param<" + event.getEventParam() + ">****");
        }
        if (this.locationCombo != null) {
            this.locationCombo.removeActionListener(this);
            String url = event.getEventParam().toString().trim();
            if (((DefaultComboBoxModel)this.locationCombo.getModel()).getIndexOf(url) < 0) {
                this.locationCombo.addItem(url);
            }
            this.locationCombo.setSelectedItem(url);
            this.locationCombo.addActionListener(this);
        }
    }

    public boolean goBack(HistoryEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** goBack() -->event<" + event + "> param<" + event.getEventParam() + ">****");
        }
        if (this.locComboEditor != null) {
            this.locComboEditor.setText((String)event.getEventParam());
        }
        return true;
    }

    public boolean goForward(HistoryEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** goForward() -->event<" + event + "> param<" + event.getEventParam() + ">****");
        }
        if (this.locComboEditor != null) {
            this.locComboEditor.setText((String)event.getEventParam());
        }
        return true;
    }

    public boolean reload(HistoryEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** reload() -->event<" + event + "> param<" + event.getEventParam() + ">****");
        }
        IntegerEventParam param = (IntegerEventParam)event.getEventParam();
        if (this.locComboEditor != null) {
            this.locComboEditor.setText(param.getStringData());
        }
        return true;
    }

    public boolean goToIndex(HistoryEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** goToIndex() -->event<" + event + "> param<" + event.getEventParam() + ">****");
        }
        IntegerEventParam param = (IntegerEventParam)event.getEventParam();
        if (this.locComboEditor != null) {
            this.locComboEditor.setText(param.getStringData());
        }
        return true;
    }

    public boolean purge(HistoryEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** purge() -->event<" + event + "> param<" + event.getEventParam() + ">****");
        }
        IntegerEventParam param = (IntegerEventParam)event.getEventParam();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        homeUrl = homeUrl;
        TL_BACK = JRexResource.getString("TL_BACK");
        TL_FORWARD = JRexResource.getString("TL_FORWARD");
        TL_RELOAD = JRexResource.getString("TL_RELOAD");
        TL_STOP = JRexResource.getString("TL_STOP");
        TL_HOME = JRexResource.getString("TL_HOME");
        TL_PRINT = JRexResource.getString("TL_PRINT");
        TL_GO = JRexResource.getString("TL_GO");
        LOC_ACT_CMD = LOC_ACT_CMD;
    }
}

