/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.mozilla.jrex.JRexFactory;
import org.mozilla.jrex.event.window.WindowListener;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.ui.JRexMenuBar;
import org.mozilla.jrex.ui.JRexPopupMenu;
import org.mozilla.jrex.ui.JRexStatusBar;
import org.mozilla.jrex.ui.JRexToolBar;
import org.mozilla.jrex.window.JRexBrowserData;

public abstract class JRexBaseBrowser {
    protected static final String className;
    protected static final String JREXBROWSER = "JRex - ";
    protected final Hashtable windowTable = new Hashtable();
    protected final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    protected JComponent rootComponent = null;
    protected Window rootWindow = null;
    protected boolean rootCreated = false;
    protected WindowListener jrexWinListener = null;
    static /* synthetic */ Class class$org$mozilla$jrex$window$JRexBaseBrowser;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected JRexBaseBrowser() {
    }

    public void init(JComponent comp) {
        if (JRexL.on) {
            JRexL.log(className, "**** init()-->comp<" + comp + ">");
        }
    }

    public void openNewWindow(int parentPeer, String uri, int loadFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** openNewWindow()-->parentPeer<" + parentPeer + "> uri<" + uri + "> loadFlags<" + loadFlags + ">");
        }
    }

    public void openNewTab(int parentPeer, String uri, int loadFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** openNewTab()-->parentPeer<" + parentPeer + "> uri<" + uri + "> loadFlags<" + loadFlags + ">");
        }
    }

    public JRexBrowserData addWindow(JRexCanvas browser, Container parent, Container rootParent, Window window, long chromeFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** addWindow()-->browser<" + browser + "> parent<" + parent + "> chromeFlags<" + chromeFlags + ">");
        }
        JRexBrowserData browserData = new JRexBrowserData(browser, parent, rootParent, window, chromeFlags);
        this.windowTable.put(new Integer(browser.getJRexPeer()), browserData);
        if (this.jrexWinListener != null) {
            this.jrexWinListener.windowCreated(browser.getJRexPeer());
        }
        return browserData;
    }

    public void removeWindow(int browserPeer) {
        if (JRexL.on) {
            JRexL.log(className, "**** removeWindow()-->browserPeer<" + browserPeer + ">");
        }
        if (this.windowTable.remove(new Integer(browserPeer)) != null && this.jrexWinListener != null) {
            this.jrexWinListener.windowDisposing(browserPeer);
        }
    }

    protected JRexBrowserData setupBrowser(JComponent browserContainer, JComponent rootContainer, Window window, long chromeFlags, JRexCanvas browser) {
        browserContainer.setLayout(new BorderLayout());
        browserContainer.setBorder(BorderFactory.createEmptyBorder());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.add(browser);
        browserContainer.add(panel);
        if (window instanceof Frame && !window.isDisplayable()) {
            ((Frame)window).setUndecorated((0x400L & chromeFlags) != 1024L);
        }
        window.pack();
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Iterator itr;
                if (JRexL.on) {
                    JRexL.log(className, "**** setupBrowser()-->windowClosing AWTWindowEvent<" + we + ">****");
                }
                if ((itr = JRexBaseBrowser.this.getBrowserForWindow(we.getWindow())).hasNext()) {
                    JRexBaseBrowser.this.destroyWindow(((JRexCanvas)itr.next()).getJRexPeer());
                }
            }
        });
        return this.addWindow(browser, browserContainer, rootContainer, window, chromeFlags);
    }

    protected void dressUP(JComponent mainPanel, JRexBrowserData browserData, int mode) {
        JRexCanvas browser = browserData.getBrowser();
        long chromeFlags = browserData.getChromeFlags();
        if (JRexL.on) {
            JRexL.log(className, "**** dressUP() --> Adding Menubar ****");
        }
        JPanel menuPanel = new JPanel(new BorderLayout());
        if ((0x10L & chromeFlags) == 16L) {
            JRexMenuBar menuBar = (JRexMenuBar)JRexFactory.getInstance().getImplNewInstance("JRexMenuBar");
            menuBar.setMode(mode);
            menuBar.setBrowser(browser);
            menuPanel.add((Component)menuBar.getMenuBar(), "North");
        }
        if (JRexL.on) {
            JRexL.log(className, "**** dressUP() --> Adding toolBar ****");
        }
        if ((0x20L & chromeFlags) == 32L) {
            JRexToolBar toolBar = (JRexToolBar)JRexFactory.getInstance().getImplNewInstance("JRexToolBar");
            toolBar.setModeAndChrome(mode, chromeFlags);
            toolBar.setBrowser(browser);
            JComponent myToolBar = toolBar.getToolBar();
            if (myToolBar != null) {
                menuPanel.add(myToolBar);
            }
        }
        if (menuPanel.getComponentCount() > 0) {
            mainPanel.add((Component)menuPanel, "North");
        }
        if (JRexL.on) {
            JRexL.log(className, "**** dressUP() --> Adding StatusBar ****");
        }
        if ((0x80L & chromeFlags) == 128L) {
            JRexStatusBar statusBar = (JRexStatusBar)JRexFactory.getInstance().getImplNewInstance("JRexStatusBar");
            statusBar.setMode(mode);
            statusBar.setBrowser(browser);
            mainPanel.add((Component)statusBar.getStatusBar(), "South");
        }
        if (JRexL.on) {
            JRexL.log(className, "**** dressUP() --> Adding PopupMenu ****");
        }
        JRexPopupMenu popupMenu = (JRexPopupMenu)JRexFactory.getInstance().getImplNewInstance("JRexPopupMenu");
        popupMenu.setMode(mode);
        popupMenu.setBrowser(browser);
    }

    public void createWindow(int parentPeer, long chromeFlags, int waitKey) {
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()-->parentPeer<" + parentPeer + "> chromeFlags<" + chromeFlags + "> waitKey<" + waitKey + ">");
        }
    }

    protected void makeDialog(int parentPeer, long chromeFlags, boolean modal, int waitKey) {
        JDialog dialog;
        Window parent;
        if (JRexL.on) {
            JRexL.log(className, "**** makeDialog()--> parentPeer<" + parentPeer + "> chromeFlags<" + chromeFlags + "> ****");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(parentPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** makeDialog()-->parentWindow browserData <" + browserData + ">");
        }
        Window window = parent = browserData != null ? browserData.getWindow() : this.rootWindow;
        if (JRexL.on) {
            JRexL.log(className, "**** makeDialog()--> parent <" + parent + ">");
        }
        JDialog jDialog = dialog = parent instanceof JDialog ? new JDialog((Dialog)parent, JREXBROWSER, modal) : new JDialog((Frame)parent, modal);
        if (JRexL.on) {
            JRexL.log(className, "**** makeDialog()-->JDialog created ****");
        }
        final JRexCanvas browser = JRexCanvas.createBrowserComponent(false, waitKey);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(browser);
        dialog.setContentPane(panel);
        if (!dialog.isDisplayable()) {
            dialog.setUndecorated((0x400L & chromeFlags) != 1024L);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                if (JRexL.on) {
                    JRexL.log(className, "**** makeDialog()-->windowClosing AWTWindowEvent<" + we + ">****");
                }
                JRexBaseBrowser.this.destroyWindow(browser.getJRexPeer());
            }
        });
        this.addWindow(browser, panel, panel, dialog, chromeFlags);
        if (JRexL.on) {
            JRexL.log(className, "**** makeDialog()-->Done ****");
        }
    }

    public void setModal(int browserPeer, final boolean modal) {
        if (JRexL.on) {
            JRexL.log(className, "**** setModal()-->browserPeer<" + browserPeer + "> modal<" + modal + ">");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** setModal()-->browserData <" + browserData + ">");
        }
        if (!$assertionsDisabled && browserData == null) {
            throw new AssertionError();
        }
        JRexCanvas browser = browserData.getBrowser();
        final Dialog d = (Dialog)browserData.getWindow();
        if (modal && d.isModal()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (JRexL.on) {
                    JRexL.log(className, "**** setModal()-->Setting Modal...");
                }
                d.setModal(modal);
                if (d.isVisible()) {
                    d.setVisible(false);
                    d.setVisible(true);
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** setModal()-->Setting Modal done!!!");
                }
            }
        });
        if (JRexL.on) {
            JRexL.log(className, "**** returning from  setModal()");
        }
    }

    public void setSize(int browserPeer, Dimension dim) {
        if (JRexL.on) {
            JRexL.log(className, "**** setSize()-->browserPeer<" + browserPeer + "> dim<" + dim + ">");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** setSize()-->browserData <" + browserData + ">");
        }
        if (!$assertionsDisabled && browserData == null) {
            throw new AssertionError();
        }
        JRexCanvas browser = browserData.getBrowser();
        final Window window = browserData.getWindow();
        Insets in = window.getInsets();
        window.setSize(new Dimension(dim.width + in.left + in.right + 1, dim.height + in.top + in.bottom + 1));
        if (window instanceof Dialog) {
            window.setLocationRelativeTo(window.getOwner());
        } else {
            int x = this.screenSize.width / 2 - dim.width / 2;
            int y = this.screenSize.height / 2 - dim.height / 2;
            window.setLocation(x < 0 ? 0 : x, y < 0 ? 0 : y);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** setSize()--> Setting size and location done!!!!.");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                window.validate();
                if (JRexL.on) {
                    JRexL.log(className, "**** setSize()--> isVisible<" + window.isVisible() + ">");
                }
                if (!window.isVisible()) {
                    window.setVisible(true);
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** setSize()--> Set cvisible done");
                }
            }
        });
    }

    public void setTitle(int browserPeer, String title) {
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->browserPeer<" + browserPeer + "> title<" + title + ">");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->browserData <" + browserData + ">");
        }
        if (!$assertionsDisabled && browserData == null) {
            throw new AssertionError();
        }
        JRexCanvas browser = browserData.getBrowser();
        Window window = browserData.getWindow();
        if (window instanceof Frame) {
            ((Frame)window).setTitle(JREXBROWSER + title);
        } else if (window instanceof Dialog) {
            ((Dialog)window).setTitle(JREXBROWSER + title);
        }
        window.validate();
    }

    public void setChromeFlags(int browserPeer, long chromeFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** setChromeFlags()-->browserPeer<" + browserPeer + "> chromeFlags<" + chromeFlags + ">");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** setChromeFlags()-->browserData <" + browserData + ">");
        }
        if (browserData != null) {
            browserData.setChromeFlags(chromeFlags);
        }
    }

    public void setRealized(int browserPeer) {
        if (JRexL.on) {
            JRexL.log(className, "**** setRealized()-->browserPeer<" + browserPeer + ">");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** setRealized()-->browserData <" + browserData + ">");
        }
        if (!$assertionsDisabled && browserData == null) {
            throw new AssertionError();
        }
        browserData.getBrowser().browserRealized();
        if (JRexL.on) {
            JRexL.log(className, "**** setRealized Done !!!");
        }
    }

    public void destroyTab(int browserPeer) {
        this.destroyWindow(browserPeer);
    }

    public void destroyWindow(final int browserPeer) {
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->browserPeer<" + browserPeer + ">");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->browserData <" + browserData + ">");
        }
        if (!$assertionsDisabled && browserData == null) {
            throw new AssertionError();
        }
        JRexCanvas browser = browserData.getBrowser();
        final Window window = browserData.getWindow();
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->window <" + window + ">");
        }
        if (EventQueue.isDispatchThread()) {
            this.destroyWindowInternal(window, browserPeer);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JRexBaseBrowser.this.destroyWindowInternal(window, browserPeer);
                }
            });
        }
    }

    protected void destroyWindowInternal(Window window, int browserPeer) {
        this.removeWindow(browserPeer);
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindowInternal()-->removed browserPeer <" + browserPeer + ">");
        }
        window.dispose();
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindowInternal()-->dispose done");
        }
        if (window == this.rootWindow && JRexFactory.getInstance().getAutoShutdown()) {
            try {
                JRexFactory.getInstance().shutdownEngine();
            }
            catch (Exception ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public JRexCanvas getBrowser(int browserPeer) {
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowser()-->browserData <" + browserData + ">");
        }
        if (browserData != null) {
            return browserData.getBrowser();
        }
        return null;
    }

    public Iterator getBrowserForWindow(Window window) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserForWindow()-->window <" + window + ">");
        }
        ArrayList<JRexCanvas> list = new ArrayList<JRexCanvas>();
        Iterator itr = this.windowTable.values().iterator();
        while (itr.hasNext()) {
            JRexBrowserData browserData = (JRexBrowserData)itr.next();
            if (browserData.getWindow() != window) continue;
            list.add(browserData.getBrowser());
        }
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserForWindow()-->size <" + list.size() + ">");
        }
        return list.iterator();
    }

    public Iterator getBrowserForRootParent(Container rootParent) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserRootParent()-->rootParent <" + rootParent + ">");
        }
        ArrayList<JRexCanvas> list = new ArrayList<JRexCanvas>();
        Iterator itr = this.windowTable.values().iterator();
        while (itr.hasNext()) {
            JRexBrowserData browserData = (JRexBrowserData)itr.next();
            if (browserData.getRootParent() != rootParent) continue;
            list.add(browserData.getBrowser());
        }
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserRootParent()-->size <" + list.size() + ">");
        }
        return list.iterator();
    }

    public JRexCanvas getBrowserForParent(Container parent) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserForParent()-->parent <" + parent + ">");
        }
        Iterator itr = this.windowTable.values().iterator();
        while (itr.hasNext()) {
            JRexBrowserData browserData = (JRexBrowserData)itr.next();
            if (browserData.getParent() != parent) continue;
            if (JRexL.on) {
                JRexL.log(className, "**** getBrowserForParent()-->MATCHED!!!");
            }
            return browserData.getBrowser();
        }
        return null;
    }

    public Container getBrowserParent(int browserPeer) {
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserParent()-->browserData <" + browserData + ">");
        }
        if (browserData != null) {
            return browserData.getParent();
        }
        return null;
    }

    public Container getBrowserRootParent(int browserPeer) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserRootParent()-->browserPeer <" + browserPeer + ">");
        }
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserRootParent()-->browserData <" + browserData + ">");
        }
        if (browserData != null) {
            return browserData.getRootParent();
        }
        return null;
    }

    public Window getBrowserWindow(int browserPeer) {
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserWindow()-->browserData <" + browserData + ">");
        }
        if (browserData != null) {
            return browserData.getWindow();
        }
        return null;
    }

    public JRexBrowserData getBrowserData(int browserPeer) {
        JRexBrowserData browserData = (JRexBrowserData)this.windowTable.get(new Integer(browserPeer));
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserData()-->browserData <" + browserData + ">");
        }
        return browserData;
    }

    public void addJRexWindowListener(WindowListener wl) {
        this.jrexWinListener = wl;
    }

    public void removeJRexWindowListener() {
        this.jrexWinListener = null;
    }

    private void disposeInternal() {
        if (JRexL.on) {
            JRexL.log(className, "**** disposeInternal()-->");
        }
        Iterator windows = this.windowTable.values().iterator();
        while (windows.hasNext()) {
            JRexBrowserData browserData = (JRexBrowserData)windows.next();
            if (JRexL.on) {
                JRexL.log(className, "**** disposeInternal()-->browserData <" + browserData + ">");
            }
            Window temp = browserData.getWindow();
            if (!this.rootCreated && temp == this.rootWindow) {
                this.rootComponent.removeAll();
                continue;
            }
            temp.removeAll();
            temp.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            if (JRexL.on) {
                JRexL.log(className, "**** dispose()--> I AM HERE");
            }
            if (!JRexFactory.getInstance().isShutdownHook()) {
                if (JRexL.on) {
                    JRexL.log(className, "**** dispose()--> not isShutdownHook");
                }
                if (EventQueue.isDispatchThread()) {
                    this.disposeInternal();
                } else {
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            public void run() {
                                if (JRexL.on) {
                                    JRexL.log(className, "**** dispose()--> doing invokeAndWait  disposeInternal() ");
                                }
                                JRexBaseBrowser.this.disposeInternal();
                                if (JRexL.on) {
                                    JRexL.log(className, "****dispose()--> invokeAndWait disposeInternal done!!!");
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                    }
                }
            }
            Object var3_2 = null;
            this.windowTable.clear();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.windowTable.clear();
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$org$mozilla$jrex$window$JRexBaseBrowser == null ? (class$org$mozilla$jrex$window$JRexBaseBrowser = JRexBaseBrowser.class$("org.mozilla.jrex.window.JRexBaseBrowser")) : class$org$mozilla$jrex$window$JRexBaseBrowser).desiredAssertionStatus();
        className = (class$org$mozilla$jrex$window$JRexBaseBrowser == null ? (class$org$mozilla$jrex$window$JRexBaseBrowser = JRexBaseBrowser.class$("org.mozilla.jrex.window.JRexBaseBrowser")) : class$org$mozilla$jrex$window$JRexBaseBrowser).getName();
        JREXBROWSER = JREXBROWSER;
    }
}

