/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.event;

import org.mozilla.jrex.event.JRexEvent;

class JRexEventQueue {
    int length = 0;
    EventQueueItem head = null;
    EventQueueItem tail = null;

    JRexEventQueue() {
    }

    public synchronized void enqueue(JRexEvent event) {
        EventQueueItem newEvent = new EventQueueItem(event);
        if (this.head == null) {
            this.head = this.tail = newEvent;
            this.length = 1;
        } else {
            this.tail.next = newEvent;
            this.tail = newEvent;
            ++this.length;
        }
        this.notify();
    }

    public synchronized JRexEvent dequeue() throws InterruptedException {
        while (this.head == null) {
            this.wait();
        }
        EventQueueItem temp = this.head;
        this.head = temp.next;
        --this.length;
        return temp.getEvent();
    }

    public synchronized boolean noEvents() {
        return this.head == null;
    }

    public int getLength() {
        return this.length;
    }

    private static class EventQueueItem {
        EventQueueItem next;
        JRexEvent event;

        EventQueueItem(JRexEvent event) {
            this.event = event;
        }

        JRexEvent getEvent() {
            return this.event;
        }
    }
}

