/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.ui.JRexPrintPreviewToolBar;
import org.mozilla.jrex.ui.JRexResource;

public class JRexPrintPreviewToolBarImpl
implements JRexPrintPreviewToolBar {
    private static final String className = (class$org$mozilla$jrex$ui$JRexPrintPreviewToolBarImpl == null ? (class$org$mozilla$jrex$ui$JRexPrintPreviewToolBarImpl = JRexPrintPreviewToolBarImpl.class$("org.mozilla.jrex.ui.JRexPrintPreviewToolBarImpl")) : class$org$mozilla$jrex$ui$JRexPrintPreviewToolBarImpl).getName();
    private static final String PRINT = JRexResource.getString("PT_PRINT");
    private static final String PAGE_SETUP = JRexResource.getString("PT_PAGE_SETUP");
    private static final String PORTRAIT = JRexResource.getString("PT_PORTRAIT");
    private static final String LANDSCAPE = JRexResource.getString("PT_LANDSCAPE");
    private static final String CLOSE = JRexResource.getString("PT_CLOSE");
    private static final String NO_OF_PAGES = JRexResource.getString("PT_NO_OF_PAGES");
    private Hashtable table = new Hashtable();
    static /* synthetic */ Class class$org$mozilla$jrex$ui$JRexPrintPreviewToolBarImpl;

    public synchronized void show(JRexCanvas browser, Container browserContainer, Window window) {
        JRexPrintPreviewToolBarUI impl = (JRexPrintPreviewToolBarUI)this.table.get(window);
        if (impl == null) {
            impl = new JRexPrintPreviewToolBarUI();
        }
        impl.setBrowserInfo(browser, browserContainer);
        this.table.put(window, impl);
        impl.showUI();
    }

    public synchronized void hide(Window window) {
        JRexPrintPreviewToolBarUI impl = (JRexPrintPreviewToolBarUI)this.table.get(window);
        if (impl != null) {
            impl.hideUI();
            this.table.remove(window);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JRexPrintPreviewToolBarUI
    extends JPanel
    implements ActionListener {
        private JButton printBtn;
        private JButton pageSetupBtn;
        private JButton lpBtn;
        private JButton closeBtn;
        private JLabel label;
        private JRexCanvas browser;
        private Container browserContainer;
        private Component northComp;
        private boolean isShowing = false;

        JRexPrintPreviewToolBarUI() {
            this.createPrintToolBar();
        }

        void setBrowserInfo(JRexCanvas browser, Container browserContainer) {
            this.browser = browser;
            this.browserContainer = browserContainer;
        }

        private final void createPrintToolBar() {
            Dimension dim = new Dimension(100, 25);
            this.printBtn = new JButton(PRINT);
            this.printBtn.setPreferredSize(dim);
            this.printBtn.addActionListener(this);
            this.pageSetupBtn = new JButton(PAGE_SETUP);
            this.pageSetupBtn.setPreferredSize(dim);
            this.pageSetupBtn.addActionListener(this);
            this.lpBtn = new JButton(LANDSCAPE);
            this.lpBtn.setPreferredSize(dim);
            this.lpBtn.addActionListener(this);
            this.closeBtn = new JButton(CLOSE);
            this.closeBtn.setPreferredSize(dim);
            this.closeBtn.addActionListener(this);
            this.label = new JLabel();
            this.label.setPreferredSize(dim);
            this.add(this.printBtn);
            this.add(this.pageSetupBtn);
            this.add(this.lpBtn);
            this.add(this.label);
            this.add(this.closeBtn);
        }

        void showUI() {
            if (this.isShowing) {
                return;
            }
            try {
                this.label.setText(NO_OF_PAGES + ":" + Integer.toString(this.browser.getPrintPreviewNumPages()));
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
            this.northComp = this.browserContainer.getComponent(1);
            this.browserContainer.remove(1);
            this.browserContainer.add(this, "North", 1);
            this.browserContainer.validate();
            this.paintImmediately(this.getBounds());
            this.isShowing = true;
        }

        void hideUI() {
            if (this.isShowing) {
                try {
                    this.browser.cancelPrintPreview();
                }
                catch (JRexException ex) {
                    JRexL.printStackTrace(ex);
                }
                this.browserContainer.remove(this);
                if (this.northComp != null) {
                    this.browserContainer.add(this.northComp, "North", 1);
                    this.browserContainer.validate();
                    this.northComp.repaint();
                }
            }
            this.isShowing = false;
        }

        public void actionPerformed(ActionEvent ae) {
            String action = ae.getActionCommand();
            if (JRexL.on) {
                JRexL.log(className, "**** actionPerformed() -->action <" + action + "> ****");
            }
            try {
                if (action.equals(PRINT)) {
                    this.browser.print(true, true);
                } else if (action.equals(PAGE_SETUP)) {
                    this.browser.pageSetup();
                } else if (action.equals(PORTRAIT)) {
                    this.lpBtn.setText(LANDSCAPE);
                    this.browser.printPreview(true, false);
                } else if (action.equals(LANDSCAPE)) {
                    this.lpBtn.setText(PORTRAIT);
                    this.browser.printPreview(true, true);
                } else if (action.equals(CLOSE)) {
                    this.hideUI();
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }
}

