/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

	#include "JRexDOMGlobals.h"

	jclass 		JRexDOMGlobals::attrCls=0;
	jclass 		JRexDOMGlobals::cDATASectionCls=0;
	jclass 		JRexDOMGlobals::commentCls=0;
	jclass 		JRexDOMGlobals::documentFragmentCls=0;
	jclass 		JRexDOMGlobals::documentCls=0;
	jclass 		JRexDOMGlobals::documentTypeCls=0;
	jclass 		JRexDOMGlobals::domImplCls=0;
	jclass 		JRexDOMGlobals::elementCls=0;
	jclass 		JRexDOMGlobals::entityCls=0;
	jclass 		JRexDOMGlobals::entityRefCls=0;
	jclass 		JRexDOMGlobals::nodeMapCls=0;
	jclass 		JRexDOMGlobals::nodeCls=0;
	jclass 		JRexDOMGlobals::nodeListCls=0;
	jclass 		JRexDOMGlobals::notationCls=0;
	jclass 		JRexDOMGlobals::processingInstCls=0;
	jclass 		JRexDOMGlobals::textCls=0;
	jclass 		JRexDOMGlobals::domExpCls=0;
	jclass 		JRexDOMGlobals::rangeExpCls=0;
	jclass  	JRexDOMGlobals::rangeCls=0;
	jclass  	JRexDOMGlobals::docRangeCls=0;
	jclass  	JRexDOMGlobals::evtExpCls=0;
	jclass  	JRexDOMGlobals::evtTargetCls=0;
	jclass  	JRexDOMGlobals::docEventCls=0;
	jclass  	JRexDOMGlobals::domEventCls=0;
	jclass  	JRexDOMGlobals::domUIEventCls=0;
	jclass  	JRexDOMGlobals::domMouseEventCls=0;
	jclass  	JRexDOMGlobals::domMutEventCls=0;
	jclass  	JRexDOMGlobals::abstractViewCls=0;
	jclass  	JRexDOMGlobals::documentViewCls=0;
	jclass  	JRexDOMGlobals::docTravCls=0;
	jclass  	JRexDOMGlobals::nodeItrCls=0;
	jclass  	JRexDOMGlobals::treeWkrCls=0;

	jmethodID 	JRexDOMGlobals::nodeCID=0;
	jmethodID 	JRexDOMGlobals::nodeMapCID=0;
	jmethodID 	JRexDOMGlobals::nodeListCID=0;
	jmethodID 	JRexDOMGlobals::domImplCID=0;
	jmethodID 	JRexDOMGlobals::domExpCID=0;
	jmethodID 	JRexDOMGlobals::rangeExpCID=0;
	jmethodID 	JRexDOMGlobals::rangeCID=0;
	jmethodID 	JRexDOMGlobals::docRangeCID=0;
	jmethodID 	JRexDOMGlobals::evtTargetCID=0;
	jmethodID 	JRexDOMGlobals::evtExpCID=0;
	jmethodID 	JRexDOMGlobals::docEventCID=0;
	jmethodID 	JRexDOMGlobals::docTravCID=0;
	jmethodID 	JRexDOMGlobals::domEventCID=0;
	jmethodID 	JRexDOMGlobals::evtListnHndlEvtMID=0;
	jmethodID 	JRexDOMGlobals::abstractViewCID=0;
	jmethodID 	JRexDOMGlobals::documentViewCID=0;
	jmethodID 	JRexDOMGlobals::nodeItrCID=0;
	jmethodID 	JRexDOMGlobals::treeWkrCID=0;
	jmethodID 	JRexDOMGlobals::nodeFilterAcptMID=0;

	jfieldID 	JRexDOMGlobals::nodePeerID=0;
	jfieldID 	JRexDOMGlobals::nodeListPeerID=0;
	jfieldID 	JRexDOMGlobals::domImplPeerID=0;
	jfieldID 	JRexDOMGlobals::nodeMapPeerID=0;
	jfieldID 	JRexDOMGlobals::rangePeerID=0;
	jfieldID 	JRexDOMGlobals::docRangePeerID=0;
	jfieldID 	JRexDOMGlobals::evtTargetPeerID=0;
	jfieldID 	JRexDOMGlobals::docEventPeerID=0;
	jfieldID 	JRexDOMGlobals::domEventPeerID=0;
	jfieldID 	JRexDOMGlobals::abstractViewPeerID=0;
	jfieldID 	JRexDOMGlobals::documentViewPeerID=0;
	jfieldID 	JRexDOMGlobals::docTravPeerID=0;
	jfieldID 	JRexDOMGlobals::nodeItrPeerID=0;
	jfieldID 	JRexDOMGlobals::treeWkrPeerID=0;

	PRBool		JRexDOMGlobals::sIntialized=PR_FALSE;

	const char* const JRexDOMGlobals::DOM_EXP_CODE_MESSAGE[]={
		"UNKNOWN DOM Error code '0'",
		"Index or size is negative, or greater than the allowed value.",
		"Specified range of text does not fit into a DOMString.",
		"Node is inserted somewhere it doesn't belong.",
		"Node is used in a different document than the one that created it(that doesn't support it).",
		"Invalid or illegal character is specified, such as in a name.",
		"Data specified for a node which does not support data.",
		"Attempt is made to modify an object where modifications are not allowed.",
		"Aempt is made to reference a node in a context where it does not exist.",
		"Implementation does not support the requested type of object or operation.",
		"Attempt is made to add an attribute that is already in use elsewhere.",
		"Attempt is made to use an object that is not, or is no longer usable.",
		"Invalid or illegal string is specified.",
		"Attempt is made to modify the type of the underlying object.",
		"Attempt is made to create or change an object in a way which is incorrect with regard to namespaces.",
		"Parameter or an operation is not supported by the underlying object."
	};

	const char* const JRexDOMGlobals::RANGE_EXP_CODE_MESSAGE[]={
		"UNKNOWN Range Error code '0'",
		"Boundary-points of a Range do not meet specific requirements.",
		"Invalid Node type Or Invalid Ancestor Node type"
	};

	const char* const JRexDOMGlobals::EVENT_EXP_CODE_MESSAGE="UNKNOWN Event type specified";

	jboolean JRexDOMGlobals::Intialize(JNIEnv* env){
		JREX_LOGLN("**** Intialize() env<"<<env<<"> ****")

		if(JRexDOMGlobals::sIntialized){
			JREX_LOGLN("**** Intialize() Already Intialized ****")
			return JNI_TRUE;
		}

		jclass tempCls = env->FindClass("org/mozilla/jrex/dom/JRexAttrImpl");
		attrCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() attrCls<"<<attrCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexCDATASectionImpl");
		cDATASectionCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() cDATASectionCls<"<<cDATASectionCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexCommentImpl");
		commentCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() commentCls<"<<commentCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexDocumentFragmentImpl");
		documentFragmentCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() documentFragmentCls<"<<documentFragmentCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexDocumentImpl");
		documentCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() documentCls<"<<documentCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexDocumentTypeImpl");
		documentTypeCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() documentTypeCls<"<<documentTypeCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexDOMImplementationImpl");
		domImplCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() domImplCls<"<<domImplCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		domImplPeerID= env->GetFieldID(domImplCls, "peerDOMImpl", "I");
		domImplCID = env->GetMethodID(domImplCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() domImplPeerID<"<<domImplPeerID<<"> domImplCID<"<<domImplCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexElementImpl");
		elementCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() elementCls<"<<elementCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexEntityImpl");
		entityCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() entityCls<"<<entityCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexEntityReferenceImpl");
		entityRefCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() entityRefCls<"<<entityRefCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexNamedNodeMapImpl");
		nodeMapCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() nodeMapCls<"<<nodeMapCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		nodeMapPeerID = env->GetFieldID(nodeMapCls, "peerNodeMap", "I");
		nodeMapCID = env->GetMethodID(nodeMapCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() nodeMapPeerID<"<<nodeMapPeerID<<"> nodeMapCID<"<<nodeMapCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexNodeImpl");
		nodeCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() nodeCls<"<<nodeCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		nodePeerID = env->GetFieldID(nodeCls, "peerNode", "I");
		nodeCID = env->GetMethodID(nodeCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() nodePeerID<"<<nodePeerID<<"> nodeCID<"<<nodeCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexNodeListImpl");
		nodeListCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() nodeListCls<"<<nodeListCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		nodeListPeerID = env->GetFieldID(nodeListCls, "peerNodeList", "I");
		nodeListCID = env->GetMethodID(nodeListCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() nodeListPeerID<"<<nodeListPeerID<<"> nodeListCID<"<<nodeListCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexNotationImpl");
		notationCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() notationCls<"<<notationCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexProcessingInstructionImpl");
		processingInstCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() processingInstCls<"<<processingInstCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/JRexTextImpl");
		textCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() textCls<"<<textCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/w3c/dom/DOMException");
		domExpCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() domExpCls<"<<domExpCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		domExpCID = env->GetMethodID(domExpCls, "<init>", "(SLjava/lang/String;)V");
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/w3c/dom/ranges/RangeException");
		rangeExpCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() rangeExpCls<"<<rangeExpCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		rangeExpCID = env->GetMethodID(rangeExpCls, "<init>", "(SLjava/lang/String;)V");
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/ranges/JRexDOMRangeImpl");
		rangeCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() rangeCls<"<<rangeCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		rangePeerID = env->GetFieldID(rangeCls, "peerRange", "I");
		rangeCID = env->GetMethodID(rangeCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() rangePeerID<"<<rangePeerID<<"> rangeCID<"<<rangeCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/ranges/JRexDocumentRangeImpl");
		docRangeCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() docRangeCls<"<<docRangeCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		docRangePeerID = env->GetFieldID(docRangeCls, "peerDocRange", "I");
		docRangeCID = env->GetMethodID(docRangeCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() docRangePeerID<"<<docRangePeerID<<"> docRangeCID<"<<docRangeCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/events/JRexEventTargetImpl");
		evtTargetCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() evtTargetCls<"<<evtTargetCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		evtTargetPeerID = env->GetFieldID(evtTargetCls, "peerEvtTarget", "I");
		evtTargetCID = env->GetMethodID(evtTargetCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() evtTargetPeerID<"<<evtTargetPeerID<<"> evtTargetCID<"<<evtTargetCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/events/JRexDocumentEventImpl");
		docEventCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() docEventCls<"<<docEventCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		docEventPeerID = env->GetFieldID(docEventCls, "peerDocEvent", "I");
		docEventCID = env->GetMethodID(docEventCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() docEventPeerID<"<<docEventPeerID<<"> docEventCID<"<<docEventCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/traversal/JRexDocumentTraversalImpl");
		docTravCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() docTravCls<"<<docTravCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		docTravPeerID = env->GetFieldID(docTravCls, "peerDocTrav", "I");
		docTravCID = env->GetMethodID(docTravCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() docTravPeerID<"<<docTravPeerID<<"> docTravCID<"<<docTravCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/traversal/JRexNodeIteratorImpl");
		nodeItrCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() nodeItrCls<"<<nodeItrCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		nodeItrPeerID = env->GetFieldID(nodeItrCls, "peerNodeItr", "I");
		nodeItrCID = env->GetMethodID(nodeItrCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() nodeItrPeerID<"<<nodeItrPeerID<<"> nodeItrCID<"<<nodeItrCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/traversal/JRexTreeWalkerImpl");
		treeWkrCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() treeWkrCls<"<<treeWkrCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		treeWkrPeerID = env->GetFieldID(treeWkrCls, "peerTreeWkr", "I");
		treeWkrCID = env->GetMethodID(treeWkrCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() treeWkrPeerID<"<<treeWkrPeerID<<"> treeWkrCID<"<<treeWkrCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/w3c/dom/events/EventException");
		evtExpCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() evtExpCls<"<<evtExpCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		evtExpCID = env->GetMethodID(evtExpCls, "<init>", "(SLjava/lang/String;)V");
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/events/JRexEventImpl");
		domEventCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() domEventCls<"<<domEventCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		domEventPeerID = env->GetFieldID(domEventCls, "peerEvent", "I");
		domEventCID = env->GetMethodID(domEventCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() domEventPeerID<"<<domEventPeerID<<"> domEventCID<"<<domEventCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/events/JRexUIEventImpl");
		domUIEventCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() domUIEventCls<"<<domUIEventCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/events/JRexMouseEventImpl");
		domMouseEventCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() domMouseEventCls<"<<domMouseEventCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/events/JRexMutationEventImpl");
		domMutEventCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() domMutEventCls<"<<domMutEventCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/w3c/dom/events/EventListener");
		evtListnHndlEvtMID = env->GetMethodID(tempCls, "handleEvent", "(Lorg/w3c/dom/events/Event;)V");
		JREX_LOGLN("**** Intialize() evtListnHndlEvtMID<"<<evtListnHndlEvtMID<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/w3c/dom/traversal/NodeFilter");
		nodeFilterAcptMID = env->GetMethodID(tempCls, "acceptNode", "(Lorg/w3c/dom/Node;)S");
		JREX_LOGLN("**** Intialize() nodeFilterAcptMID<"<<nodeFilterAcptMID<<"> ****")
		env->DeleteLocalRef(tempCls);
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/views/JRexAbstractViewImpl");
		abstractViewCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() abstractViewCls<"<<abstractViewCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		abstractViewPeerID = env->GetFieldID(abstractViewCls, "peerAbstractView", "I");
		abstractViewCID = env->GetMethodID(abstractViewCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() abstractViewPeerID<"<<abstractViewPeerID<<"> abstractViewCID<"<<abstractViewCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		tempCls = env->FindClass("org/mozilla/jrex/dom/views/JRexDocumentViewImpl");
		documentViewCls = (jclass) env->NewGlobalRef(tempCls);
		JREX_LOGLN("**** Intialize() documentViewCls<"<<documentViewCls<<"> ****")
		env->DeleteLocalRef(tempCls);
		documentViewPeerID = env->GetFieldID(documentViewCls, "peerDocView", "I");
		documentViewCID = env->GetMethodID(documentViewCls, "<init>", "()V");
		JREX_LOGLN("**** Intialize() documentViewPeerID<"<<documentViewPeerID<<"> documentViewCID<"<<documentViewCID<<"> ****")
		if (env->ExceptionOccurred())goto FAILED;

		JRexDOMGlobals::sIntialized=PR_TRUE;
		return JNI_TRUE;
FAILED:
		env->ExceptionDescribe();
		env->ExceptionClear();
		UnIntialize(env);
		return JNI_FALSE;
	}

	void JRexDOMGlobals::UnIntialize(JNIEnv* env){
		JREX_LOGLN("**** UnIntialize() sIntialized<"<<JRexDOMGlobals::sIntialized<<"> env<"<<env<<"> attrCls<"<<attrCls<<"> ****")
		JRexDOMGlobals::sIntialized=PR_FALSE;
		if(attrCls)env->DeleteGlobalRef(attrCls);
		attrCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() cDATASectionCls<"<<cDATASectionCls<<"> ****")
		if(cDATASectionCls)env->DeleteGlobalRef(cDATASectionCls);
		cDATASectionCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() commentCls<"<<commentCls<<"> ****")
		if(commentCls)env->DeleteGlobalRef(commentCls);
		commentCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() documentFragmentCls<"<<documentFragmentCls<<"> ****")
		if(documentFragmentCls)env->DeleteGlobalRef(documentFragmentCls);
		documentFragmentCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() documentCls<"<<documentCls<<"> ****")
		if(documentCls)env->DeleteGlobalRef(documentCls);
		documentCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() documentTypeCls<"<<documentTypeCls<<"> ****")
		if(documentTypeCls)env->DeleteGlobalRef(documentTypeCls);
		documentTypeCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() domImplCls<"<<domImplCls<<"> ****")
		if(domImplCls)env->DeleteGlobalRef(domImplCls);
		domImplCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() elementCls<"<<elementCls<<"> ****")
		if(elementCls)env->DeleteGlobalRef(elementCls);
		elementCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() entityCls<"<<entityCls<<"> ****")
		if(entityCls)env->DeleteGlobalRef(entityCls);
		entityCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() entityRefCls<"<<entityRefCls<<"> ****")
		if(entityRefCls)env->DeleteGlobalRef(entityRefCls);
		entityRefCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() nodeMapCls<"<<nodeMapCls<<"> ****")
		if(nodeMapCls)env->DeleteGlobalRef(nodeMapCls);
		nodeMapCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() nodeCls<"<<nodeCls<<"> ****")
		if(nodeCls)env->DeleteGlobalRef(nodeCls);
		nodeCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() nodeListCls<"<<nodeListCls<<"> ****")
		if(nodeListCls)env->DeleteGlobalRef(nodeListCls);
		nodeListCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() notationCls<"<<notationCls<<"> ****")
		if(notationCls)env->DeleteGlobalRef(notationCls);
		notationCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() processingInstCls<"<<processingInstCls<<"> ****")
		if(processingInstCls)env->DeleteGlobalRef(processingInstCls);
		processingInstCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() textCls<"<<textCls<<"> ****")
		if(textCls)env->DeleteGlobalRef(textCls);
		textCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() domExpCls<"<<domExpCls<<"> ****")
		if(domExpCls)env->DeleteGlobalRef(domExpCls);
		domExpCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() rangeExpCls<"<<rangeExpCls<<"> ****")
		if(rangeExpCls)env->DeleteGlobalRef(rangeExpCls);
		rangeExpCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() rangeCls<"<<rangeCls<<"> ****")
		if(rangeCls)env->DeleteGlobalRef(rangeCls);
		rangeCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() docRangeCls<"<<docRangeCls<<"> ****")
		if(docRangeCls)env->DeleteGlobalRef(docRangeCls);
		docRangeCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() evtTargetCls<"<<evtTargetCls<<"> ****")
		if(evtTargetCls)env->DeleteGlobalRef(evtTargetCls);
		evtTargetCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() docEventCls<"<<docEventCls<<"> ****")
		if(docEventCls)env->DeleteGlobalRef(docEventCls);
		docEventCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() docTravCls<"<<docTravCls<<"> ****")
		if(docTravCls)env->DeleteGlobalRef(docTravCls);
		docTravCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() nodeItrCls<"<<nodeItrCls<<"> ****")
		if(nodeItrCls)env->DeleteGlobalRef(nodeItrCls);
		nodeItrCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() treeWkrCls<"<<treeWkrCls<<"> ****")
		if(treeWkrCls)env->DeleteGlobalRef(treeWkrCls);
		treeWkrCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() evtExpCls<"<<evtExpCls<<"> ****")
		if(evtExpCls)env->DeleteGlobalRef(evtExpCls);
		evtExpCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() domEventCls<"<<domEventCls<<"> ****")
		if(domEventCls)env->DeleteGlobalRef(domEventCls);
		domEventCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() domUIEventCls<"<<domUIEventCls<<"> ****")
		if(domUIEventCls)env->DeleteGlobalRef(domUIEventCls);
		domUIEventCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() domMouseEventCls<"<<domMouseEventCls<<"> ****")
		if(domMouseEventCls)env->DeleteGlobalRef(domMouseEventCls);
		domMouseEventCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() domMutEventCls<"<<domMutEventCls<<"> ****")
		if(domMutEventCls)env->DeleteGlobalRef(domMutEventCls);
		domMutEventCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() abstractViewCls<"<<abstractViewCls<<"> ****")
		if(abstractViewCls)env->DeleteGlobalRef(abstractViewCls);
		abstractViewCls=NULL;
		if (env->ExceptionOccurred())goto clean;

		JREX_LOGLN("**** UnIntialize() documentViewCls<"<<documentViewCls<<"> ****")
		if(documentViewCls)env->DeleteGlobalRef(documentViewCls);
		documentViewCls=NULL;
		if (env->ExceptionOccurred())goto clean;
		return;
	clean:
		env->ExceptionDescribe();
		env->ExceptionClear();
	}

	jobject JRexDOMGlobals::CreateNodeByType(JNIEnv* env, nsIDOMNode *node){
		return CreateNodeByType(env, node, PR_TRUE);
	}

	jobject JRexDOMGlobals::CreateNodeByType(JNIEnv* env, nsIDOMNode *node, PRBool addRef){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateNodeByType env<"<<env<<"> node<"<<node<<"> ****")
  		if (IS_NULL(node) || env->EnsureLocalCapacity(1))return NULL;

  		PRUint16 nodeType = 0;
  		nsresult rv= node->GetNodeType(&nodeType);
  		JREX_LOGLN("**** CreateNodeByType GetNodeType rv<"<<rv<<"> nodeType<"<<nodeType<<"> ****")

		jclass cls=NULL;
		switch (nodeType) {
			case nsIDOMNode::ATTRIBUTE_NODE:
				cls = attrCls;
				break;

			case nsIDOMNode::CDATA_SECTION_NODE:
				cls = cDATASectionCls;
				break;

			case nsIDOMNode::COMMENT_NODE:
				cls = commentCls;
				break;

			case nsIDOMNode::DOCUMENT_FRAGMENT_NODE:
				cls = documentFragmentCls;
				break;

			case nsIDOMNode::DOCUMENT_NODE:
				cls = documentCls;
				break;

			case nsIDOMNode::DOCUMENT_TYPE_NODE:
				cls = documentTypeCls;
				break;

			case nsIDOMNode::ELEMENT_NODE:
				cls = elementCls;
				break;

			case nsIDOMNode::ENTITY_NODE:
				cls = entityCls;
				break;

			case nsIDOMNode::ENTITY_REFERENCE_NODE:
				cls = entityRefCls;
				break;

			case nsIDOMNode::NOTATION_NODE:
				cls = notationCls;
				break;

			case nsIDOMNode::PROCESSING_INSTRUCTION_NODE:
				cls = processingInstCls;
				break;

			case nsIDOMNode::TEXT_NODE:
				cls = textCls;
				break;

			default:
				cls=nodeCls;
		}
		JREX_LOGLN("**** CreateNodeByType() cls<"<<cls<<"> ****")

		jobject jdomNode = env->NewObject(cls,nodeCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jdomNode)){
			JREX_LOGLN("**** CreateNodeByType() jdomNode<"<<jdomNode<<"> nodePeerID<"<<NS_PTR_TO_INT32(node)<<"> ****")
			env->SetIntField(jdomNode, nodePeerID,(jint)NS_PTR_TO_INT32(node));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateNodeByType()--> ***jdomNode Creation done ****")
				if(addRef)
					NS_ADDREF(node);
				return jdomNode;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateNodeByType() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateNodeByType()--> **** jdomNode Creation Failed !!! ****")
		return NULL;
	}


	jobject JRexDOMGlobals::CreateNodeMap(JNIEnv* env, nsIDOMNamedNodeMap *nodeMap){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateNodeMap env<"<<env<<"> nodeMap<"<<nodeMap<<"> ****")
  		if (IS_NULL(nodeMap) || env->EnsureLocalCapacity(1))return NULL;

		jobject jdomNodeMap = env->NewObject(nodeMapCls,nodeMapCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jdomNodeMap)){
			JREX_LOGLN("**** CreateNodeMap() jdomNodeMap<"<<jdomNodeMap<<"> nodeMapPeerID<"<<NS_PTR_TO_INT32(nodeMap)<<"> ****")
			env->SetIntField(jdomNodeMap, nodeMapPeerID,(jint)NS_PTR_TO_INT32(nodeMap));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateNodeMap()--> ***jdomNodeMap Creation done ****")
				NS_ADDREF(nodeMap);
				return jdomNodeMap;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateNodeMap() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}

		JREX_LOGLN("CreateNodeMap()--> **** jdomNodeMap Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateNodeList(JNIEnv* env, nsIDOMNodeList *nodeList){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateNodeList env<"<<env<<"> nodeList<"<<nodeList<<"> ****")
  		if (IS_NULL(nodeList) || env->EnsureLocalCapacity(1))return NULL;

		jobject jdomNodeList = env->NewObject(nodeListCls,nodeListCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jdomNodeList)){
			JREX_LOGLN("**** CreateNodeList() jdomNodeList<"<<jdomNodeList<<"> nodeListPeerID<"<<NS_PTR_TO_INT32(nodeList)<<"> ****")
			env->SetIntField(jdomNodeList, nodeListPeerID,(jint)NS_PTR_TO_INT32(nodeList));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateNodeList()--> ***jdomNodeList Creation done ****")
				NS_ADDREF(nodeList);
				return jdomNodeList;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateNodeList() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateNodeList()--> **** jdomNodeList Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateDOMImpl(JNIEnv* env, nsIDOMDOMImplementation *domImpl){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateDOMImpl env<"<<env<<"> domImpl<"<<domImpl<<"> ****")
  		if (IS_NULL(domImpl) || env->EnsureLocalCapacity(1))return NULL;

		jobject jdomImpl = env->NewObject(domImplCls,domImplCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jdomImpl)){
			JREX_LOGLN("**** CreateDOMImpl() jdomImpl<"<<jdomImpl<<"> domImplPeerID<"<<NS_PTR_TO_INT32(domImpl)<<"> ****")
			env->SetIntField(jdomImpl, domImplPeerID,(jint)NS_PTR_TO_INT32(domImpl));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateDOMImpl()--> ***jdomImpl Creation done ****")
				NS_ADDREF(domImpl);
				return jdomImpl;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateDOMImpl() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateDOMImpl()--> **** jdomImpl Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateRange(JNIEnv* env, nsIDOMRange *range){
		return CreateRange(env, range, PR_TRUE);
	}

	jobject JRexDOMGlobals::CreateRange(JNIEnv* env, nsIDOMRange *range, PRBool addRef){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateRange env<"<<env<<"> range<"<<range<<"> ****")
  		if (IS_NULL(range) || env->EnsureLocalCapacity(1))return NULL;

		jobject jrange = env->NewObject(rangeCls,rangeCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jrange)){
			JREX_LOGLN("**** CreateRange() jrange<"<<jrange<<"> rangePeerID<"<<NS_PTR_TO_INT32(range)<<"> ****")
			env->SetIntField(jrange, rangePeerID, (jint)NS_PTR_TO_INT32(range));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateRange()--> ***jrange Creation done ****")
				if(addRef)
					NS_ADDREF(range);
				return jrange;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateRange() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateRange()--> **** jrange Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateDocumentRange(JNIEnv* env, nsIDOMDocumentRange *docRange){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateDocumentRange env<"<<env<<"> docRange<"<<docRange<<"> ****")
  		if (IS_NULL(docRange) || env->EnsureLocalCapacity(1))return NULL;

		jobject jdocRange = env->NewObject(docRangeCls,docRangeCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jdocRange)){
			JREX_LOGLN("**** CreateDocumentRange() jdocRange<"<<jdocRange<<"> docRangePeerID<"<<NS_PTR_TO_INT32(docRange)<<"> ****")
			env->SetIntField(jdocRange, docRangePeerID, (jint)NS_PTR_TO_INT32(docRange));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateDocumentRange()--> ***jdocRange Creation done ****")
				NS_ADDREF(docRange);
				return jdocRange;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateDocumentRange() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateDocumentRange()--> **** jdocRange Creation Failed !!! ****")
		return NULL;
	}


	jobject JRexDOMGlobals::CreateEventTarget(JNIEnv* env, nsIDOMEventTarget *evtTarget){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateEventTarget env<"<<env<<"> evtTarget<"<<evtTarget<<"> ****")
  		if (IS_NULL(evtTarget) || env->EnsureLocalCapacity(1))return NULL;

		jobject jevtTarget = env->NewObject(evtTargetCls,evtTargetCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jevtTarget)){
			JREX_LOGLN("**** CreateEventTarget() jevtTarget<"<<jevtTarget<<"> evtTargetPeerID<"<<NS_PTR_TO_INT32(evtTarget)<<"> ****")
			env->SetIntField(jevtTarget, evtTargetPeerID, (jint)NS_PTR_TO_INT32(evtTarget));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateEventTarget()--> ***jevtTarget Creation done ****")
				NS_ADDREF(evtTarget);
				return jevtTarget;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateEventTarget() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateEventTarget()--> **** jevtTarget Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateDocumentEvent(JNIEnv* env, nsIDOMDocumentEvent *docEvent){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateDocumentEvent env<"<<env<<"> docEvent<"<<docEvent<<"> ****")
  		if (IS_NULL(docEvent) || env->EnsureLocalCapacity(1))return NULL;

		jobject jdocEvent = env->NewObject(docEventCls,docEventCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jdocEvent)){
			JREX_LOGLN("**** CreateDocumentEvent() jdocEvent<"<<jdocEvent<<"> docEventPeerID<"<<NS_PTR_TO_INT32(docEvent)<<"> ****")
			env->SetIntField(jdocEvent, docEventPeerID, (jint)NS_PTR_TO_INT32(docEvent));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateDocumentEvent()--> ***jevtDoc Creation done ****")
				NS_ADDREF(docEvent);
				return jdocEvent;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateDocumentEvent() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateDocumentEvent()--> **** jdocEvent Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateDocumentTraversal(JNIEnv* env, nsIDOMDocumentTraversal *docTrav){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateDocumentTraversal env<"<<env<<"> docTrav<"<<docTrav<<"> ****")
  		if (IS_NULL(docTrav) || env->EnsureLocalCapacity(1))return NULL;

		jobject jdocTrav = env->NewObject(docTravCls,docTravCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jdocTrav)){
			JREX_LOGLN("**** CreateDocumentTraversal() jdocTrav<"<<jdocTrav<<"> docTravPeerID<"<<NS_PTR_TO_INT32(docTrav)<<"> ****")
			env->SetIntField(jdocTrav, docTravPeerID, (jint)NS_PTR_TO_INT32(docTrav));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateDocumentTraversal()--> ***jevtDoc Creation done ****")
				NS_ADDREF(docTrav);
				return jdocTrav;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateDocumentTraversal() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateDocumentTraversal()--> **** jdocTrav Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateDocumentView(JNIEnv* env, nsIDOMDocumentView *docView){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateDocumentView env<"<<env<<"> docView<"<<docView<<"> ****")
  		if (IS_NULL(docView) || env->EnsureLocalCapacity(1))return NULL;

		jobject jdocView = env->NewObject(documentViewCls,documentViewCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jdocView)){
			JREX_LOGLN("**** CreateDocumentView() jdocView<"<<jdocView<<"> documentViewPeerID<"<<NS_PTR_TO_INT32(docView)<<"> ****")
			env->SetIntField(jdocView, documentViewPeerID, (jint)NS_PTR_TO_INT32(docView));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateDocumentView()--> ***jevtDoc Creation done ****")
				NS_ADDREF(docView);
				return jdocView;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateDocumentView() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateDocumentView()--> **** jdocView Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateDOMEvent(JNIEnv* env, nsIDOMEvent *event){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateDOMEvent env<"<<env<<"> event<"<<event<<"> ****")
  		if (IS_NULL(event) || env->EnsureLocalCapacity(1))return NULL;

		jobject jdomEvent=NULL;
		nsString eventType(NS_LITERAL_STRING("Events"));
		nsresult rv=event->GetType(eventType);
		JREX_LOGLN("**** CreateDOMEvent() GetType rv<"<<rv<<"> ****")

		if(eventType.Equals(NS_LITERAL_STRING("UIEvents"))){
			JREX_LOGLN("**** CreateDOMEvent() UIEvents ****")
			jdomEvent = env->NewObject(domUIEventCls,domEventCID);
		}else
		if(eventType.Equals(NS_LITERAL_STRING("MouseEvents"))){
			JREX_LOGLN("**** CreateDOMEvent() MouseEvents ****")
			jdomEvent = env->NewObject(domMouseEventCls,domEventCID);
		}else
		if(eventType.Equals(NS_LITERAL_STRING("MutationEvents"))){
			JREX_LOGLN("**** CreateDOMEvent() MutationEvents ****")
			jdomEvent = env->NewObject(domMutEventCls,domEventCID);
		}else{
			JREX_LOGLN("**** CreateDOMEvent() Normal Events ****")
			jdomEvent = env->NewObject(domEventCls,domEventCID);
		}

		if(!env->ExceptionOccurred() && NOT_NULL(jdomEvent)){
			JREX_LOGLN("**** CreateDOMEvent() jdomEvent<"<<jdomEvent<<"> domEventPeerID<"<<NS_PTR_TO_INT32(event)<<"> ****")
			env->SetIntField(jdomEvent, domEventPeerID, (jint)NS_PTR_TO_INT32(event));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateDOMEvent()--> ***jdomEvent Creation done ****")
				NS_ADDREF(event);
				return jdomEvent;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateDOMEvent() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateDOMEvent()--> **** jdomEvent Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateNodeIterator(JNIEnv* env, nsIDOMNodeIterator *nodeItr){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateNodeIterator env<"<<env<<"> nodeItr<"<<nodeItr<<"> ****")
  		if (IS_NULL(nodeItr) || env->EnsureLocalCapacity(1))return NULL;

		jobject jnodeItr = env->NewObject(nodeItrCls,nodeItrCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jnodeItr)){
			JREX_LOGLN("**** CreateNodeIterator() jnodeItr<"<<jnodeItr<<"> nodeItrPeerID<"<<NS_PTR_TO_INT32(nodeItr)<<"> ****")
			env->SetIntField(jnodeItr, nodeItrPeerID, (jint)NS_PTR_TO_INT32(nodeItr));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateNodeIterator()--> ***jnodeItr Creation done ****")
				NS_ADDREF(nodeItr);
				return jnodeItr;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateNodeIterator() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateNodeIterator()--> **** jnodeItr Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateTreeWalker(JNIEnv* env, nsIDOMTreeWalker *treeWkr){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateTreeWalker env<"<<env<<"> treeWkr<"<<treeWkr<<"> ****")
  		if (IS_NULL(treeWkr) || env->EnsureLocalCapacity(1))return NULL;

		jobject jtreeWkr = env->NewObject(treeWkrCls,treeWkrCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jtreeWkr)){
			JREX_LOGLN("**** CreateTreeWalker() jtreeWkr<"<<jtreeWkr<<"> treeWkrPeerID<"<<NS_PTR_TO_INT32(treeWkr)<<"> ****")
			env->SetIntField(jtreeWkr, treeWkrPeerID, (jint)NS_PTR_TO_INT32(treeWkr));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateTreeWalker()--> ***jtreeWkr Creation done ****")
				NS_ADDREF(treeWkr);
				return jtreeWkr;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateTreeWalker() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateTreeWalker()--> **** jtreeWkr Creation Failed !!! ****")
		return NULL;
	}

	jobject JRexDOMGlobals::CreateAbstractView(JNIEnv* env, nsIDOMAbstractView *view){
		if(IS_NULL(env))env=JRex_GetEnv(0);
		JREX_LOGLN("**** CreateAbstractView env<"<<env<<"> view<"<<view<<"> ****")
  		if (IS_NULL(view) || env->EnsureLocalCapacity(1))return NULL;

		jobject jabstractView = env->NewObject(abstractViewCls,abstractViewCID);
		if(!env->ExceptionOccurred() && NOT_NULL(jabstractView)){
			JREX_LOGLN("**** CreateAbstractView() jabstractView<"<<jabstractView<<"> abstractViewPeerID<"<<NS_PTR_TO_INT32(view)<<"> ****")
			env->SetIntField(jabstractView, abstractViewPeerID, (jint)NS_PTR_TO_INT32(view));
			if (!env->ExceptionOccurred()){
				JREX_LOGLN("CreateAbstractView()--> ***jabstractView Creation done ****")
				NS_ADDREF(view);
				return jabstractView;
			}
		}
		if (env->ExceptionOccurred()){
			JREX_LOGLN("**** CreateAbstractView() Exception Occured ****")
			env->ExceptionDescribe();
			env->ExceptionClear();
		}
		JREX_LOGLN("CreateAbstractView()--> **** jabstractView Creation Failed !!! ****")
		return NULL;
	}

	/** A utility function to throw w3c DOM excepiton */
	void JRexDOMGlobals::ThrowDOMException(JNIEnv *env, nsresult errorCode){
		JREX_LOGLN("******* ThrowDOMException errorCode <"<<errorCode<<"> ****")
		PRUint32 nsErrCode=NS_ERROR_GET_CODE(errorCode);
		if(nsErrCode>15)nsErrCode=0;

		if (env->EnsureLocalCapacity(1) < 0) {
			JREX_LOGLN("******* ThrowDOMException EnsureLocalCapacity Failed ****")
			return;
		}

		jstring jexpMsg=env->NewStringUTF(DOM_EXP_CODE_MESSAGE[nsErrCode]);
		jthrowable domException = (jthrowable)env->NewObject(domExpCls,domExpCID,nsErrCode,jexpMsg);
		if(NOT_NULL(domException))
			env->Throw(domException);
	}

	/** A utility function to throw w3c DOM Range excepiton */
	void JRexDOMGlobals::ThrowRangeException(JNIEnv *env, nsresult errorCode){
		JREX_LOGLN("******* ThrowRangeException errorCode <"<<errorCode<<"> ****")
		PRUint32 nsErrCode=NS_ERROR_GET_CODE(errorCode);
		if(nsErrCode>2)nsErrCode=0;

		if (env->EnsureLocalCapacity(1) < 0) {
			JREX_LOGLN("******* ThrowRangeException EnsureLocalCapacity Failed ****")
			return;
		}

		jstring jexpMsg=env->NewStringUTF(RANGE_EXP_CODE_MESSAGE[nsErrCode]);
		jthrowable rangeException = (jthrowable)env->NewObject(rangeExpCls,rangeExpCID,nsErrCode,jexpMsg);
		if(NOT_NULL(rangeException))
			env->Throw(rangeException);
	}

	/** A utility function to throw w3c DOM Event excepiton */
	void JRexDOMGlobals::ThrowEventException(JNIEnv *env, nsresult errorCode){
		JREX_LOGLN("******* ThrowEventException errorCode <"<<errorCode<<"> ****")
		if (env->EnsureLocalCapacity(1) < 0) {
			JREX_LOGLN("******* ThrowRangeException EnsureLocalCapacity Failed ****")
			return;
		}
		jstring jexpMsg=env->NewStringUTF(EVENT_EXP_CODE_MESSAGE);
		jthrowable eventException = (jthrowable)env->NewObject(evtExpCls,evtExpCID,0,jexpMsg);
		if(NOT_NULL(eventException))
			env->Throw(eventException);
	}

	nsresult JRexDOMGlobals::ExecInEventQ(nsISupports* target, PRUint16 eventType,
											void* eventData, PRBool isSync,void** _result){
		JREX_LOGLN("JRexDOMGlobals::ExecInEventQ1()--> **** eventType<"<<eventType<<">  eventData<"<<eventData<<">****")
		return ExecInEventQ(target, eventType, eventData, isSync,
				JRexDOMGlobals::HandleJRexDOMEvent, JRexDOMGlobals::DestroyJRexDOMEvent ,_result);
	}

	nsresult JRexDOMGlobals::ExecInEventQ(nsISupports* target, PRUint16 eventType,void* eventData, PRBool isSync,
								PLHandleEventProc handler, PLDestroyEventProc destructor, void** _result){
		JREX_LOGLN("JRexDOMGlobals::ExecInEventQ()--> **** eventType<"<<eventType<<">  eventData<"<<eventData<<">****")
		if(isSync)
			NS_ENSURE_ARG_POINTER(_result);

		JRexBasicDOMEvent* event = new JRexBasicDOMEvent;
		nsresult rv;
		if (event) {
			JREX_LOGLN("JRexDOMGlobals::ExecInEventQ()--> **** gEventQ JRexBasicDOMEvent Created ****")
			rv=gEventQ->InitEvent(NS_REINTERPRET_CAST(PLEvent*, event),
										nsnull,handler,destructor);
			JREX_LOGLN("JRexDOMGlobals::ExecInEventQ()--> **** gEventQ InitEvent rv<"<<rv<<">  ****")
			if(NS_FAILED(rv))
				return rv;
			event->target=target;
			event->eventType=eventType;
			event->eventData=eventData;
			rv = gEventQ->EnterMonitor();
			if (NS_SUCCEEDED(rv)){
				if(isSync){
					void* rVal;
					rv = gEventQ->PostSynchronousEvent(NS_REINTERPRET_CAST(PLEvent*, event),&rVal);
					JREX_LOGLN("JRexDOMGlobals::ExecInEventQ()--> **** gEventQ  PostSynchronousEvent rv<"<<rv<<"> rVal<"<<rVal<<"> ****")
					if(NS_SUCCEEDED(rv))
						*_result=rVal;
				}else{
					rv = gEventQ->PostEvent(NS_REINTERPRET_CAST(PLEvent*, event));
					JREX_LOGLN("JRexDOMGlobals::ExecInEventQ()--> **** gEventQ  PostEvent rv<"<<rv<<"> ****")
				}
			}
			gEventQ->ExitMonitor();
			if (NS_FAILED(rv)){
				JREX_LOGLN("JRexDOMGlobals::ExecInEventQ()--> **** POSTING EVENT FAILED rv<"<<rv<<"> ****")
				PR_DELETE(event);
			}
		}else
			rv=NS_ERROR_OUT_OF_MEMORY;
		JREX_LOGLN("JRexDOMGlobals::ExecInEventQ()--> **** returning rv<"<<rv<<"> ****")
		return rv;
	}

	void* PR_CALLBACK JRexDOMGlobals::HandleJRexDOMEvent(PLEvent* aEvent){
		JRexBasicDOMEvent* event = NS_REINTERPRET_CAST(JRexBasicDOMEvent*, aEvent);
		nsresult rv=NS_OK;
		JREX_LOGLN("HandleJRexDOMEvent()--> **** target <"<<event->target<<"> ****")
		switch(event->eventType){
			case JREX_RELEASE:
			{
				JREX_LOGLN("HandleJRexDOMEvent JREX_RELEASE EVENT!!!****")
				NS_IF_RELEASE(event->target);
				break;
			}
			case JREX_DISPATCH_EVENT:
			{
				JREX_LOGLN("HandleJRexDOMEvent JREX_DISPATCH_EVENT EVENT!!!****")
				nsCOMPtr<nsIDOMEventTarget> thisEvtTarget(do_QueryInterface(event->target));
				if (thisEvtTarget){
					nsIDOMEvent* domEvent = NS_REINTERPRET_CAST(nsIDOMEvent*, event->eventData);
					JREX_LOGLN("HandleJRexDOMEvent()--> **** GOT  thisEvtTarget<"<<thisEvtTarget<<"> domEvent<"<<domEvent<<"> ****")
					PRBool boolRet=PR_FALSE;
					nsresult rv =thisEvtTarget->DispatchEvent(domEvent,&boolRet);
					return (void*)boolRet;
				}
				JREX_LOGLN("HandleJRexDOMEvent()--> **** Getting thisEvtTarget Failed!!! ****")
				break;
			}
			default:
			{
				JREX_LOGLN("HandleJRexDOMEvent()--> **** EVENT TYPE<"<<event->eventType<<"> not handled!!! ****")
			}
		}
		JREX_LOGLN("HandleJRexDOMEvent()--> **** returning rv<"<<rv<<"> ****")
		return (void*)rv;
	}

	void PR_CALLBACK JRexDOMGlobals::DestroyJRexDOMEvent(PLEvent* aEvent){
		JRexBasicDOMEvent* event = NS_REINTERPRET_CAST(JRexBasicDOMEvent*, aEvent);
		JREX_LOGLN("DestroyJRexDOMEvent()--> **** target <"<<event->target<<"> ****")
		delete event;
	}
