/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

	#ifndef JRexDOMGlobals_h_
	#define JRexDOMGlobals_h_

	#include "JRexIncludes.h"
	#include "JRex_JNI_util.h"

	using namespace JREX_JNI_UTIL;

	#define DOM_EXP_NAME				"org/w3c/dom/DOMException"
	#define RANGE_EXP_NAME				"org/w3c/dom/ranges/RangeException"
	#define EVENT_EXP_NAME				"org/w3c/dom/events/EventException"

	class JRexDOMGlobals{
		public :
			static jclass attrCls;
			static jclass cDATASectionCls;
			//static jclass characterDataCls; //no object used
			static jclass commentCls;
			static jclass documentFragmentCls;
			static jclass documentCls;
			static jclass documentTypeCls;
			static jclass domImplCls;
			static jclass elementCls;
			static jclass entityCls;
			static jclass entityRefCls;
			static jclass nodeMapCls;
			static jclass nodeCls;
			static jclass nodeListCls;
			static jclass notationCls;
			static jclass processingInstCls;
			static jclass textCls;
			static jclass domExpCls;
			static jclass rangeCls;
			static jclass rangeExpCls;
			static jclass docRangeCls;
			static jclass evtExpCls;
			static jclass evtTargetCls;
			static jclass docEventCls;
			static jclass domEventCls;
			static jclass domUIEventCls;
			static jclass domMouseEventCls;
			static jclass domMutEventCls;
			static jclass abstractViewCls;
			static jclass documentViewCls;
			static jclass docTravCls;
			static jclass nodeItrCls;
			static jclass treeWkrCls;

			static jmethodID nodeCID;
			static jmethodID nodeMapCID;
			static jmethodID nodeListCID;
			static jmethodID domImplCID;
			static jmethodID domExpCID;
			static jmethodID rangeExpCID;
			static jmethodID rangeCID;
			static jmethodID docRangeCID;
			static jmethodID evtExpCID;
			static jmethodID evtTargetCID;
			static jmethodID docEventCID;
			static jmethodID domEventCID;
			static jmethodID evtListnHndlEvtMID;
			static jmethodID abstractViewCID;
			static jmethodID documentViewCID;
			static jmethodID docTravCID;
			static jmethodID nodeItrCID;
			static jmethodID treeWkrCID;
			static jmethodID nodeFilterAcptMID;

			static jfieldID nodePeerID;
			static jfieldID nodeListPeerID;
			static jfieldID nodeMapPeerID;
			static jfieldID domImplPeerID;
			static jfieldID rangePeerID;
			static jfieldID docRangePeerID;
			static jfieldID evtTargetPeerID;
			static jfieldID docEventPeerID;
			static jfieldID domEventPeerID;
			static jfieldID abstractViewPeerID;
			static jfieldID documentViewPeerID;
			static jfieldID docTravPeerID;
			static jfieldID nodeItrPeerID;
			static jfieldID treeWkrPeerID;

			static PRBool sIntialized;

			static jboolean Intialize(JNIEnv*);
			static void UnIntialize(JNIEnv*);
			static jobject CreateNodeByType(JNIEnv*, nsIDOMNode *node);
			static jobject CreateNodeByType(JNIEnv*, nsIDOMNode *node, PRBool addRef);
			static jobject CreateNodeMap(JNIEnv* env, nsIDOMNamedNodeMap *nodeMap);
			static jobject CreateNodeList(JNIEnv* env, nsIDOMNodeList *nodeList);
			static jobject CreateDOMImpl(JNIEnv* env, nsIDOMDOMImplementation *domImpl);
			static jobject CreateDocumentRange(JNIEnv* env,  nsIDOMDocumentRange *docRange);
			static jobject CreateRange(JNIEnv* env, nsIDOMRange *range);
			static jobject CreateRange(JNIEnv* env, nsIDOMRange *range, PRBool addRef);
			static jobject CreateEventTarget(JNIEnv* env, nsIDOMEventTarget *evtTarget);
			static jobject CreateDocumentEvent(JNIEnv* env, nsIDOMDocumentEvent *docEvent);
			static jobject CreateDOMEvent(JNIEnv* env, nsIDOMEvent *event);
			static jobject CreateAbstractView(JNIEnv* env, nsIDOMAbstractView *view);
			static jobject CreateDocumentView(JNIEnv* env, nsIDOMDocumentView *view);
			static jobject CreateDocumentTraversal(JNIEnv* env, nsIDOMDocumentTraversal *docTrav);
			static jobject CreateNodeIterator(JNIEnv* env, nsIDOMNodeIterator *nodeItr);
			static jobject CreateTreeWalker(JNIEnv* env, nsIDOMTreeWalker *treeWkr);
			static void ThrowDOMException(JNIEnv *env, nsresult errorCode);
			static void ThrowRangeException(JNIEnv *env, nsresult errorCode);
			static void ThrowEventException(JNIEnv *env, nsresult errorCode);

			//event types for JRexDOM
			enum JRexDOMEventTypes{	JREX_RELEASE=0U,
									JREX_DISPATCH_EVENT};


			struct JRexBasicDOMEvent : PLEvent{
				nsISupports* target;
				PRUint16 eventType;
				void* eventData;
			};

			struct JRexCommonJRV{
				jobject jobj;
				nsresult rv;
			};

			static void* PR_CALLBACK HandleJRexDOMEvent(PLEvent* aEvent);
			static void PR_CALLBACK DestroyJRexDOMEvent(PLEvent* aEvent);

			static nsresult ExecInEventQ(nsISupports* target, PRUint16 eventType,
											void* eventData, PRBool isSync,void** _result);

			static nsresult ExecInEventQ(nsISupports* target, PRUint16 eventType,void* eventData, PRBool isSync,
											PLHandleEventProc handler, PLDestroyEventProc destructor, void** _result);

		private :
			static const char* const DOM_EXP_CODE_MESSAGE[];
			static const char* const RANGE_EXP_CODE_MESSAGE[];
			static const char* const EVENT_EXP_CODE_MESSAGE;
	};

	#define SAFE_RELEASE(obj)		  if(IS_EQT) \
										NS_IF_RELEASE(obj); \
									  else \
										JRexDOMGlobals::ExecInEventQ(obj, JRexDOMGlobals::JREX_RELEASE, nsnull, PR_FALSE, nsnull);

	#endif//#define JRexDOMGlobals_h_
