/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


#include "org_mozilla_jrex_dom_events_JRexEventTargetImpl.h"
#include "JRexDOMGlobals.h"
#include "JRexDOMEventListener.h"

/*
 * Class:     org_mozilla_jrex_dom_events_JRexEventTargetImpl
 * Method:    AddEventListener
 * Signature: (Ljava/lang/String;Lorg/w3c/dom/events/EventListener;Z)V
 */
JNIEXPORT jint JNICALL Java_org_mozilla_jrex_dom_events_JRexEventTargetImpl_AddEventListener
  (JNIEnv * env, jobject jevtTarget, jstring jtype, jobject jeventLis, jboolean juseCapture){

	if(!JRexDOMGlobals::sIntialized)return 0;
	JREX_TRY
	nsIDOMEventTarget* thisEvtTarget=(nsIDOMEventTarget*)NS_INT32_TO_PTR(env->GetIntField(jevtTarget, JRexDOMGlobals::evtTargetPeerID));
	JREX_LOGLN("AddEventListener()--> **** thisEvtTarget <"<<thisEvtTarget<<"> ****")
	if(IS_NULL(thisEvtTarget) || IS_NULL(jeventLis) || IS_NULL(jtype)){
		JREX_LOGLN("AddEventListener()--> **** thisEvtTarget/jeventLis/jtype DOES NOT EXIST!!! ****");
		return 0;
	}
	nsIDOMEventListener* domListn=new JRexDOMEventListener(jeventLis);
	if(IS_NULL(domListn)){
		ThrowJRexException(env, "**** nsIDOMEventListener creation  Failed ****",0);
		return 0;
	}

	jboolean isUriCopy=JNI_FALSE;
	const char* type=NOT_NULL(jtype)?env->GetStringUTFChars(jtype,&isUriCopy):nsnull;
	JREX_LOGLN("AddEventListener()--> **** type<"<<(PRUint32)type<<"> isUriCopy<"<<(isUriCopy==JNI_TRUE)<<"> ***")

	nsresult rv =thisEvtTarget->AddEventListener(NS_ConvertASCIItoUCS2(type),domListn,(juseCapture==JNI_TRUE?PR_TRUE:PR_FALSE));
	JREX_LOGLN("AddEventListener()--> **** AddEventListener rv<"<<rv<<"> ****")
	env->ReleaseStringUTFChars(jtype,type);
	if(NS_FAILED(rv)){
		JREX_LOGLN("AddEventListener()--> **** AddEventListener NON-DOM ERROR OCCURED !!!****")
		ThrowJRexException(env, "**** AddEventListener Failed ****",rv);
		return 0;
	}
	return NS_PTR_TO_INT32(domListn);
	JREX_CATCH(env)
	return 0;
}

/*
 * Class:     org_mozilla_jrex_dom_events_JRexEventTargetImpl
 * Method:    RemoveEventListener
 * Signature: (Ljava/lang/String;Lorg/w3c/dom/events/EventListener;Z)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_events_JRexEventTargetImpl_RemoveEventListener
  (JNIEnv * env, jobject jevtTarget, jstring jtype, jint jeventLisPeer, jboolean juseCapture){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMEventTarget* thisEvtTarget=(nsIDOMEventTarget*)NS_INT32_TO_PTR(env->GetIntField(jevtTarget, JRexDOMGlobals::evtTargetPeerID));
	nsIDOMEventListener* domListn=(nsIDOMEventListener*)NS_INT32_TO_PTR(jeventLisPeer);
	JREX_LOGLN("RemoveEventListener()--> **** thisEvtTarget <"<<thisEvtTarget<<"> domListn<"<<domListn<<"> ****")
	if(IS_NULL(thisEvtTarget) || IS_NULL(domListn) || IS_NULL(jtype)){
		JREX_LOGLN("RemoveEventListener()--> **** thisEvtTarget/domListn/jtype DOES NOT EXIST!!! ****");
		return;
	}

	jboolean isUriCopy=JNI_FALSE;
	const char* type=NOT_NULL(jtype)?env->GetStringUTFChars(jtype,&isUriCopy):nsnull;
	JREX_LOGLN("RemoveEventListener()--> **** type<"<<(PRUint32)type<<"> isUriCopy<"<<(isUriCopy==JNI_TRUE)<<"> ***")

	nsresult rv =thisEvtTarget->RemoveEventListener(NS_ConvertASCIItoUCS2(type),domListn,(juseCapture==JNI_TRUE?PR_TRUE:PR_FALSE));
	JREX_LOGLN("RemoveEventListener()--> **** RemoveEventListener rv<"<<rv<<"> ****")
	env->ReleaseStringUTFChars(jtype,type);
	if(NS_FAILED(rv)){
		JREX_LOGLN("RemoveEventListener()--> **** RemoveEventListener NON-DOM ERROR OCCURED !!!****")
		ThrowJRexException(env, "**** RemoveEventListener Failed ****",rv);
	}
	JREX_CATCH(env)
	return;
}

/*
 * Class:     org_mozilla_jrex_dom_events_JRexEventTargetImpl
 * Method:    DispatchEvent
 * Signature: (Lorg/w3c/dom/events/Event;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_dom_events_JRexEventTargetImpl_DispatchEvent
  (JNIEnv * env, jobject jevtTarget, jobject jevent){

	if(!JRexDOMGlobals::sIntialized)return JNI_FALSE;
	JREX_TRY
	nsIDOMEventTarget* thisEvtTarget=(nsIDOMEventTarget*)NS_INT32_TO_PTR(env->GetIntField(jevtTarget, JRexDOMGlobals::evtTargetPeerID));
	nsIDOMEvent* domEvent=(nsIDOMEvent*)NS_INT32_TO_PTR(env->GetIntField(jevent, JRexDOMGlobals::domEventPeerID));

	JREX_LOGLN("DispatchEvent()--> **** thisEvtTarget <"<<thisEvtTarget<<"> domEvent <"<<domEvent<<"> ****")
	if(IS_NULL(thisEvtTarget) || IS_NULL(domEvent)){
		JREX_LOGLN("DispatchEvent()--> **** thisEvtTarget/domEvent DOES NOT EXIST!!! ****");
		return JNI_FALSE;
	}

	PRBool boolRet=PR_FALSE;
	nsresult rv;
	if(IS_EQT){
		JREX_LOGLN("DispatchEvent()--> **** IN EVT Q THREAD ****")
		rv =thisEvtTarget->DispatchEvent(domEvent,&boolRet);
	}else{
		//we can't use sync disptach as it leads to deadloack
		rv= JRexDOMGlobals::ExecInEventQ(thisEvtTarget, JRexDOMGlobals::JREX_DISPATCH_EVENT, domEvent, PR_FALSE, nsnull);
		PRBool boolRet=NS_SUCCEEDED(rv);
		JREX_LOGLN("DispatchEvent()--> **** ExecInEventQ rv<"<<rv<<"> boolRet<"<<boolRet<<"> ****")
	}
	if(NS_FAILED(rv)){
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){//Should be EVENT but mozilla raises DOM
			JREX_LOGLN("DispatchEvent()--> **** DispatchEvent DOM EVENT ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowEventException(env, rv);
		}else{
			JREX_LOGLN("DispatchEvent()--> **** DispatchEvent NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** DispatchEvent Failed ****",rv);
		}
		return JNI_FALSE;
	}
	return boolRet==PR_TRUE?JNI_TRUE:JNI_FALSE;
	JREX_CATCH(env)
	return JNI_FALSE;
}

/*
 * Class:     org_mozilla_jrex_dom_events_JRexEventTargetImpl
 * Method:    Finalize
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_events_JRexEventTargetImpl_Finalize
  (JNIEnv * env, jobject jevtTarget){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMEventTarget* thisEvtTarget=(nsIDOMEventTarget*)NS_INT32_TO_PTR(env->GetIntField(jevtTarget, JRexDOMGlobals::evtTargetPeerID));
	JREX_LOGLN("JRexEventTargetImpl Finalize()--> **** thisEvtTarget <"<<thisEvtTarget<<"> ****")
	if(IS_NULL(thisEvtTarget)){
		JREX_LOGLN("JRexEventTargetImpl Finalize()--> **** thisEvtTarget DOES NOT EXIST!!! ****");
		return;
	}
	SAFE_RELEASE(thisEvtTarget)
	JREX_CATCH(env)
}
