/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


#include "org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl.h"
#include "JRexDOMGlobals.h"

//event types for JRexDOMRange
enum JRexDOMRangeEventTypes{	JREX_GET_START_CONT=0U,
								JREX_GET_END_CONT,
								JREX_GET_COM_CONT,
								JREX_EXT_CONT,
								JREX_CLONE_CONT,
								JREX_CLONE_RANGE};

static void* PR_CALLBACK HandleJRexDOMRangeEvent(PLEvent* aEvent);
static void PR_CALLBACK DestroyJRexDOMRangeEvent(PLEvent* aEvent);

inline JRexDOMGlobals::JRexCommonJRV*
	JRexDOMRangeImpl_GetStartContainerInternal(JNIEnv *env, nsIDOMRange* range){
	JRexDOMGlobals::JRexCommonJRV *jrv=new JRexDOMGlobals::JRexCommonJRV;
	if(IS_NULL(jrv))return NULL;
	jobject jval=NULL;
	nsresult rv=NS_ERROR_FAILURE;
	if (range){
		nsCOMPtr<nsIDOMNode> tmpNode;
		rv = range->GetStartContainer(getter_AddRefs(tmpNode));
		JREX_LOGLN("JRexDOMRangeImpl_GetStartContainerInternal()--> **** GetStartContainer rv<"<<rv<<"> ****")
		if(tmpNode)
			jval=JRexDOMGlobals::CreateNodeByType(env, tmpNode.get());
	}
	jrv->jobj=jval;
	jrv->rv=rv;
	return jrv;
}

inline JRexDOMGlobals::JRexCommonJRV*
	JRexDOMRangeImpl_GetEndContainerInternal(JNIEnv *env, nsIDOMRange* range){
	JRexDOMGlobals::JRexCommonJRV *jrv=new JRexDOMGlobals::JRexCommonJRV;
	if(IS_NULL(jrv))return NULL;
	jobject jval=NULL;
	nsresult rv=NS_ERROR_FAILURE;
	if (range){
		nsCOMPtr<nsIDOMNode> tmpNode;
		rv = range->GetEndContainer(getter_AddRefs(tmpNode));
		JREX_LOGLN("JRexDOMRangeImpl_GetEndContainerInternal()--> **** GetEndContainer rv<"<<rv<<"> ****")
		if(tmpNode)
			jval=JRexDOMGlobals::CreateNodeByType(env, tmpNode.get());
	}
	jrv->jobj=jval;
	jrv->rv=rv;
	return jrv;
}

inline JRexDOMGlobals::JRexCommonJRV*
	JRexDOMRangeImpl_GetCommonAncestorContainerInternal(JNIEnv *env, nsIDOMRange* range){
	JRexDOMGlobals::JRexCommonJRV *jrv=new JRexDOMGlobals::JRexCommonJRV;
	if(IS_NULL(jrv))return NULL;
	jobject jval=NULL;
	nsresult rv=NS_ERROR_FAILURE;
	if (range){
		nsCOMPtr<nsIDOMNode> tmpNode;
		rv = range->GetCommonAncestorContainer(getter_AddRefs(tmpNode));
		JREX_LOGLN("JRexDOMRangeImpl_GetCommonAncestorContainerInternal()--> **** GetCommonAncestorContainer rv<"<<rv<<"> ****")
		if(tmpNode)
			jval=JRexDOMGlobals::CreateNodeByType(env, tmpNode.get());
	}
	jrv->jobj=jval;
	jrv->rv=rv;
	return jrv;
}

inline JRexDOMGlobals::JRexCommonJRV*
	JRexDOMRangeImpl_ExtractContentsInternal(JNIEnv *env, nsIDOMRange* range){
	JRexDOMGlobals::JRexCommonJRV *jrv=new JRexDOMGlobals::JRexCommonJRV;
	if(IS_NULL(jrv))return NULL;
	jobject jval=NULL;
	nsresult rv=NS_ERROR_FAILURE;
	if (range){
		nsCOMPtr<nsIDOMDocumentFragment> tmpDocFrag;
		rv = range->ExtractContents(getter_AddRefs(tmpDocFrag));
		JREX_LOGLN("JRexDOMRangeImpl_ExtractContentsInternal()--> **** ExtractContents rv<"<<rv<<"> ****")
		if(tmpDocFrag)
			jval=JRexDOMGlobals::CreateNodeByType(env, tmpDocFrag.get());
	}
	jrv->jobj=jval;
	jrv->rv=rv;
	return jrv;
}

inline JRexDOMGlobals::JRexCommonJRV*
	JRexDOMRangeImpl_CloneContentsInternal(JNIEnv *env, nsIDOMRange* range){
	JRexDOMGlobals::JRexCommonJRV *jrv=new JRexDOMGlobals::JRexCommonJRV;
	if(IS_NULL(jrv))return NULL;
	jobject jval=NULL;
	nsresult rv=NS_ERROR_FAILURE;
	if (range){
		nsCOMPtr<nsIDOMDocumentFragment> tmpDocFrag;
		rv = range->CloneContents(getter_AddRefs(tmpDocFrag));
		JREX_LOGLN("JRexDOMRangeImpl_CloneContentsInternal()--> **** CloneContents rv<"<<rv<<"> ****")
		if(tmpDocFrag)
			jval=JRexDOMGlobals::CreateNodeByType(env, tmpDocFrag.get());
	}
	jrv->jobj=jval;
	jrv->rv=rv;
	return jrv;
}

inline JRexDOMGlobals::JRexCommonJRV*
	JRexDOMRangeImpl_CloneRangeInternal(JNIEnv *env, nsIDOMRange* range){
	JRexDOMGlobals::JRexCommonJRV *jrv=new JRexDOMGlobals::JRexCommonJRV;
	if(IS_NULL(jrv))return NULL;
	jobject jval=NULL;
	nsresult rv=NS_ERROR_FAILURE;
	if (range){
		nsCOMPtr<nsIDOMRange> tmpRange;
		rv = range->CloneRange(getter_AddRefs(tmpRange));
		JREX_LOGLN("JRexDOMRangeImpl_CloneRangeInternal()--> **** CloneRange rv<"<<rv<<"> ****")
		if(tmpRange)
			jval=JRexDOMGlobals::CreateRange(env, tmpRange.get());
	}
	jrv->jobj=jval;
	jrv->rv=rv;
	return jrv;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    GetStartContainer
 * Signature: ()Lorg/w3c/dom/Node;
 */
JNIEXPORT jobject JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_GetStartContainer
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return NULL;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("GetStartContainer()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "GetStartContainer()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return NULL;
	}

	JRexDOMGlobals::JRexCommonJRV *jrv=NULL;
	if(IS_EQT){
		JREX_LOGLN("GetStartContainer()--> **** IN EVT Q THREAD ****")
		jrv=JRexDOMRangeImpl_GetStartContainerInternal(env, thisRange);
	}else{
		nsresult rv=JRexDOMGlobals::ExecInEventQ(thisRange, JREX_GET_START_CONT, nsnull, PR_TRUE, HandleJRexDOMRangeEvent, DestroyJRexDOMRangeEvent, (void**)&jrv);
		JREX_LOGLN("GetStartContainer()--> **** ExecInEventQ rv<"<<rv<<"> ****")
	}
	JREX_LOGLN("GetStartContainer()--> **** jrv<"<<jrv<<"> ****")
	if(NOT_NULL(jrv)){
		nsresult rv=jrv->rv;
		jobject jobj=jrv->jobj;
		delete jrv;
		if (NS_FAILED(rv)) {
			if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
				JREX_LOGLN("GetStartContainer()--> **** GetStartContainer DOM ERROR OCCURED !!!****")
				JRexDOMGlobals::ThrowDOMException(env, rv);
			}else{
				JREX_LOGLN("GetStartContainer()--> **** GetStartContainer NON-DOM ERROR OCCURED !!!****")
				ThrowJRexException(env, "**** GetStartContainer Failed ****",rv);
			}
			return NULL;
		}
		return jobj;
	}

	JREX_CATCH(env)
	return NULL;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    GetStartOffset
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_GetStartOffset
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return -1;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("GetStartOffset()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "GetStartOffset()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return -1;
	}

	PRInt32 startOffSet=0;
	nsresult rv = thisRange->GetStartOffset(&startOffSet);
	JREX_LOGLN("GetStartOffset()--> **** GetStartOffset rv<"<<rv<<"> startOffSet<"<<startOffSet<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("GetStartOffset()--> **** GetStartOffset DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else{
			JREX_LOGLN("GetStartOffset()--> **** GetStartOffset NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** GetStartOffset Failed ****",rv);
		}
		return -1;
	}
	return (jint)startOffSet;
	JREX_CATCH(env)
	return -1;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    GetEndContainer
 * Signature: ()Lorg/w3c/dom/Node;
 */
JNIEXPORT jobject JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_GetEndContainer
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return NULL;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("GetEndContainer()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "GetEndContainer()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return NULL;
	}

	JRexDOMGlobals::JRexCommonJRV *jrv=NULL;
	if(IS_EQT){
		JREX_LOGLN("GetEndContainer()--> **** IN EVT Q THREAD ****")
		jrv=JRexDOMRangeImpl_GetEndContainerInternal(env, thisRange);
	}else{
		nsresult rv=JRexDOMGlobals::ExecInEventQ(thisRange, JREX_GET_END_CONT, nsnull, PR_TRUE, HandleJRexDOMRangeEvent, DestroyJRexDOMRangeEvent, (void**)&jrv);
		JREX_LOGLN("GetEndContainer()--> **** ExecInEventQ rv<"<<rv<<"> ****")
	}
	JREX_LOGLN("GetEndContainer()--> **** jrv<"<<jrv<<"> ****")
	if(NOT_NULL(jrv)){
		nsresult rv=jrv->rv;
		jobject jobj=jrv->jobj;
		delete jrv;
		if (NS_FAILED(rv)) {
			if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
				JREX_LOGLN("GetEndContainer()--> **** GetEndContainer DOM ERROR OCCURED !!!****")
				JRexDOMGlobals::ThrowDOMException(env, rv);
			}else{
				JREX_LOGLN("GetEndContainer()--> **** GetEndContainer NON-DOM ERROR OCCURED !!!****")
				ThrowJRexException(env, "**** GetEndContainer Failed ****",rv);
			}
			return NULL;
		}
		return jobj;
	}

	JREX_CATCH(env)
	return NULL;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    GetEndOffset
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_GetEndOffset
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return -1;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("GetEndOffset()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "GetEndOffset()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return -1;
	}

	PRInt32 endOffSet=0;
	nsresult rv = thisRange->GetEndOffset(&endOffSet);
	JREX_LOGLN("GetEndOffset()--> **** GetEndOffset rv<"<<rv<<"> endOffSet<"<<endOffSet<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("GetEndOffset()--> **** GetEndOffset DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else{
			JREX_LOGLN("GetEndOffset()--> **** GetEndOffset NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** GetEndOffset Failed ****",rv);
		}
		return -1;
	}
	return (jint)endOffSet;
	JREX_CATCH(env)
	return -1;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    GetCollapsed
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_GetCollapsed
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return JNI_FALSE;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("GetCollapsed()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "GetCollapsed()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return JNI_FALSE;
	}
	PRBool retBool = PR_FALSE;
	nsresult rv = thisRange->GetCollapsed(&retBool);
	JREX_LOGLN("GetCollapsed()--> **** GetCollapsed rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("GetCollapsed()--> **** GetCollapsed DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else{
			JREX_LOGLN("GetCollapsed()--> **** GetCollapsed NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** GetCollapsed Failed ****",rv);
		}
		return JNI_FALSE;
	}
	return retBool==PR_FALSE?JNI_FALSE:JNI_TRUE;
	JREX_CATCH(env)
	return JNI_FALSE;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    GetCommonAncestorContainer
 * Signature: ()Lorg/w3c/dom/Node;
 */
JNIEXPORT jobject JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_GetCommonAncestorContainer
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return NULL;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("GetCommonAncestorContainer()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "GetCommonAncestorContainer()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return NULL;
	}

	JRexDOMGlobals::JRexCommonJRV *jrv=NULL;
	if(IS_EQT){
		JREX_LOGLN("GetCommonAncestorContainer()--> **** IN EVT Q THREAD ****")
		jrv=JRexDOMRangeImpl_GetCommonAncestorContainerInternal(env, thisRange);
	}else{
		nsresult rv=JRexDOMGlobals::ExecInEventQ(thisRange, JREX_GET_COM_CONT, nsnull, PR_TRUE, HandleJRexDOMRangeEvent, DestroyJRexDOMRangeEvent, (void**)&jrv);
		JREX_LOGLN("GetCommonAncestorContainer()--> **** ExecInEventQ rv<"<<rv<<"> ****")
	}
	JREX_LOGLN("GetCommonAncestorContainer()--> **** jrv<"<<jrv<<"> ****")
	if(NOT_NULL(jrv)){
		nsresult rv=jrv->rv;
		jobject jobj=jrv->jobj;
		delete jrv;
		if (NS_FAILED(rv)) {
			if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
				JREX_LOGLN("GetCommonAncestorContainer()--> **** GetCommonAncestorContainer DOM ERROR OCCURED !!!****")
				JRexDOMGlobals::ThrowDOMException(env, rv);
			}else{
				JREX_LOGLN("GetCommonAncestorContainer()--> **** GetCommonAncestorContainer NON-DOM ERROR OCCURED !!!****")
				ThrowJRexException(env, "**** GetCommonAncestorContainer Failed ****",rv);
			}
			return NULL;
		}
		return jobj;
	}

	JREX_CATCH(env)
	return NULL;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    SetStart
 * Signature: (Lorg/w3c/dom/Node;I)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_SetStart
  (JNIEnv * env, jobject jrangeImpl, jobject jnode, jint joffSet){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("SetStart()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("SetStart()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** SetStart()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->SetStart(refNode, (PRUint32)joffSet);
	JREX_LOGLN("SetStart()--> **** SetStart rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("SetStart()--> **** SetStart DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("SetStart()--> **** SetStart RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("SetStart()--> **** SetStart NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** SetStart Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    SetEnd
 * Signature: (Lorg/w3c/dom/Node;I)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_SetEnd
  (JNIEnv * env, jobject jrangeImpl, jobject jnode, jint joffSet){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("SetEnd()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("SetEnd()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** SetEnd()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->SetEnd(refNode, (PRUint32)joffSet);
	JREX_LOGLN("SetEnd()--> **** SetEnd rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("SetEnd()--> **** SetEnd DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("SetEnd()--> **** SetEnd RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("SetEnd()--> **** SetEnd NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** SetEnd Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    SetStartBefore
 * Signature: (Lorg/w3c/dom/Node;)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_SetStartBefore
  (JNIEnv * env, jobject jrangeImpl, jobject jnode){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("SetStartBefore()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("SetStartBefore()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** SetStartBefore()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->SetStartBefore(refNode);
	JREX_LOGLN("SetStartBefore()--> **** SetStartBefore rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("SetStartBefore()--> **** SetStartBefore DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("SetStartBefore()--> **** SetStartBefore RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("SetStartBefore()--> **** SetStartBefore NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** SetStartBefore Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    SetStartAfter
 * Signature: (Lorg/w3c/dom/Node;)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_SetStartAfter
  (JNIEnv * env, jobject jrangeImpl, jobject jnode){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("SetStartAfter()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("SetStartAfter()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** SetStartAfter()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->SetStartAfter(refNode);
	JREX_LOGLN("SetStartAfter()--> **** SetStartAfter rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("SetStartAfter()--> **** SetStartAfter DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("SetStartAfter()--> **** SetStartAfter RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("SetStartAfter()--> **** SetStartAfter NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** SetStartAfter Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    SetEndBefore
 * Signature: (Lorg/w3c/dom/Node;)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_SetEndBefore
  (JNIEnv * env, jobject jrangeImpl, jobject jnode){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("SetEndBefore()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("SetEndBefore()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** SetEndBefore()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->SetEndBefore(refNode);
	JREX_LOGLN("SetEndBefore()--> **** SetEndBefore rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("SetEndBefore()--> **** SetEndBefore DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("SetEndBefore()--> **** SetEndBefore RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("SetEndBefore()--> **** SetEndBefore NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** SetEndBefore Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    SetEndAfter
 * Signature: (Lorg/w3c/dom/Node;)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_SetEndAfter
  (JNIEnv * env, jobject jrangeImpl, jobject jnode){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("SetEndAfter()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("SetEndAfter()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** SetEndAfter()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->SetEndAfter(refNode);
	JREX_LOGLN("SetEndAfter()--> **** SetEndAfter rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("SetEndAfter()--> **** SetEndAfter DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("SetEndAfter()--> **** SetEndAfter RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("SetEndAfter()--> **** SetEndAfter NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** SetEndAfter Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    Collapse
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_Collapse
  (JNIEnv * env, jobject jrangeImpl, jboolean jtoStart){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("Collapse()--> **** thisRange <"<<thisRange<<"> ****")

	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "**** Collapse()--> thisRange DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->Collapse((jtoStart==JNI_TRUE?PR_TRUE:PR_FALSE));
	JREX_LOGLN("Collapse()--> **** Collapse rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("Collapse()--> **** Collapse DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else{
			JREX_LOGLN("Collapse()--> **** Collapse NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** Collapse Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    SelectNode
 * Signature: (Lorg/w3c/dom/Node;)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_SelectNode
  (JNIEnv * env, jobject jrangeImpl, jobject jnode){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("SelectNode()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("SelectNode()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** SelectNode()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->SelectNode(refNode);
	JREX_LOGLN("SelectNode()--> **** SelectNode rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("SelectNode()--> **** SelectNode DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("SelectNode()--> **** SelectNode RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("SelectNode()--> **** SelectNode NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** SelectNode Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    SelectNodeContents
 * Signature: (Lorg/w3c/dom/Node;)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_SelectNodeContents
  (JNIEnv * env, jobject jrangeImpl, jobject jnode){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("SelectNodeContents()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("SelectNodeContents()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** SelectNodeContents()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->SelectNodeContents(refNode);
	JREX_LOGLN("SelectNodeContents()--> **** SelectNodeContents rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("SelectNodeContents()--> **** SelectNodeContents DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("SelectNodeContents()--> **** SelectNodeContents RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("SelectNodeContents()--> **** SelectNodeContents NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** SelectNodeContents Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    CompareBoundaryPoints
 * Signature: (ILorg/mozilla/jrex/dom/JRexDOMRange;)I
 */
JNIEXPORT jshort JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_CompareBoundaryPoints
  (JNIEnv * env, jobject jrangeImpl, jint cmptype, jobject jsrcRange){

	if(!JRexDOMGlobals::sIntialized)return 0;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("CompareBoundaryPoints()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMRange* srcRange=nsnull;
	if(NOT_NULL(jsrcRange))
		srcRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jsrcRange, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("CompareBoundaryPoints()--> **** srcRange <"<<srcRange<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(srcRange)){
		ThrowJRexException(env, "**** CompareBoundaryPoints()--> thisRange/srcRange DOES NOT EXIST!!! ****",0);
		return 0;
	}
	PRInt16 rVal=0;
	nsresult rv = thisRange->CompareBoundaryPoints((PRUint16)cmptype,srcRange,&rVal);
	JREX_LOGLN("CompareBoundaryPoints()--> **** CompareBoundaryPoints rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("CompareBoundaryPoints()--> **** CompareBoundaryPoints DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else{
			JREX_LOGLN("CompareBoundaryPoints()--> **** CompareBoundaryPoints NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** CompareBoundaryPoints Failed ****",rv);
		}
		return 0;
	}
	return (jshort)rVal;
	JREX_CATCH(env)
	return 0;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    DeleteContents
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_DeleteContents
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("DeleteContents()--> **** thisRange <"<<thisRange<<"> ****")

	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "**** DeleteContents()--> thisRange DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->DeleteContents();
	JREX_LOGLN("DeleteContents()--> **** DeleteContents rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("DeleteContents()--> **** DeleteContents DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else{
			JREX_LOGLN("DeleteContents()--> **** DeleteContents NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** DeleteContents Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    ExtractContents
 * Signature: ()Lorg/w3c/dom/DocumentFragment;
 */
JNIEXPORT jobject JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_ExtractContents
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return NULL;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("ExtractContents()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "ExtractContents()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return NULL;
	}

	JRexDOMGlobals::JRexCommonJRV *jrv=NULL;
	if(IS_EQT){
		JREX_LOGLN("ExtractContents()--> **** IN EVT Q THREAD ****")
		jrv=JRexDOMRangeImpl_ExtractContentsInternal(env, thisRange);
	}else{
		nsresult rv=JRexDOMGlobals::ExecInEventQ(thisRange, JREX_EXT_CONT, nsnull, PR_TRUE, HandleJRexDOMRangeEvent, DestroyJRexDOMRangeEvent, (void**)&jrv);
		JREX_LOGLN("ExtractContents()--> **** ExecInEventQ rv<"<<rv<<"> ****")
	}
	JREX_LOGLN("ExtractContents()--> **** jrv<"<<jrv<<"> ****")
	if(NOT_NULL(jrv)){
		nsresult rv=jrv->rv;
		jobject jobj=jrv->jobj;
		delete jrv;
		if (NS_FAILED(rv)) {
			if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
				JREX_LOGLN("ExtractContents()--> **** ExtractContents DOM ERROR OCCURED !!!****")
				JRexDOMGlobals::ThrowDOMException(env, rv);
			}else{
				JREX_LOGLN("ExtractContents()--> **** ExtractContents NON-DOM ERROR OCCURED !!!****")
				ThrowJRexException(env, "**** ExtractContents Failed ****",rv);
			}
			return NULL;
		}
		return jobj;
	}
	JREX_CATCH(env)
	return NULL;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    CloneContents
 * Signature: ()Lorg/w3c/dom/DocumentFragment;
 */
JNIEXPORT jobject JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_CloneContents
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return NULL;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("CloneContents()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "CloneContents()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return NULL;
	}

	JRexDOMGlobals::JRexCommonJRV *jrv=NULL;
	if(IS_EQT){
		JREX_LOGLN("CloneContents()--> **** IN EVT Q THREAD ****")
		jrv=JRexDOMRangeImpl_CloneContentsInternal(env, thisRange);
	}else{
		nsresult rv=JRexDOMGlobals::ExecInEventQ(thisRange, JREX_CLONE_CONT, nsnull, PR_TRUE, HandleJRexDOMRangeEvent, DestroyJRexDOMRangeEvent, (void**)&jrv);
		JREX_LOGLN("CloneContents()--> **** ExecInEventQ rv<"<<rv<<"> ****")
	}
	JREX_LOGLN("CloneContents()--> **** jrv<"<<jrv<<"> ****")
	if(NOT_NULL(jrv)){
		nsresult rv=jrv->rv;
		jobject jobj=jrv->jobj;
		delete jrv;
		if (NS_FAILED(rv)) {
			if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
				JREX_LOGLN("CloneContents()--> **** CloneContents DOM ERROR OCCURED !!!****")
				JRexDOMGlobals::ThrowDOMException(env, rv);
			}else{
				JREX_LOGLN("CloneContents()--> **** CloneContents NON-DOM ERROR OCCURED !!!****")
				ThrowJRexException(env, "**** CloneContents Failed ****",rv);
			}
			return NULL;
		}
		return jobj;
	}

	JREX_CATCH(env)
	return NULL;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    InsertNode
 * Signature: (Lorg/w3c/dom/Node;)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_InsertNode
  (JNIEnv * env, jobject jrangeImpl, jobject jnode){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("InsertNode()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("InsertNode()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** InsertNode()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->InsertNode(refNode);
	JREX_LOGLN("InsertNode()--> **** InsertNode rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("InsertNode()--> **** InsertNode DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("InsertNode()--> **** InsertNode RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("InsertNode()--> **** InsertNode NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** InsertNode Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    SurroundContents
 * Signature: (Lorg/w3c/dom/Node;)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_SurroundContents
  (JNIEnv * env, jobject jrangeImpl, jobject jnode){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("SurroundContents()--> **** thisRange <"<<thisRange<<"> ****")

	nsIDOMNode* refNode=nsnull;
	if(NOT_NULL(jnode))
		refNode=(nsIDOMNode*)NS_INT32_TO_PTR(env->GetIntField(jnode, JRexDOMGlobals::nodePeerID));
	JREX_LOGLN("SurroundContents()--> **** refNode <"<<refNode<<"> ****")

	if(IS_NULL(thisRange) || IS_NULL(refNode)){
		ThrowJRexException(env, "**** SurroundContents()--> thisRange/refNode DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->SurroundContents(refNode);
	JREX_LOGLN("SurroundContents()--> **** SurroundContents rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("SurroundContents()--> **** SurroundContents DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else
		if(NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM_RANGE){
			JREX_LOGLN("SurroundContents()--> **** SurroundContents RANGE ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowRangeException(env, rv);
		}else{
			JREX_LOGLN("SurroundContents()--> **** SurroundContents NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** SurroundContents Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    CloneRange
 * Signature: ()Lorg/mozilla/jrex/dom/JRexDOMRange;
 */
JNIEXPORT jobject JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_CloneRange
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return NULL;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("CloneRange()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "CloneRange()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return NULL;
	}

	JRexDOMGlobals::JRexCommonJRV *jrv=NULL;
	if(IS_EQT){
		JREX_LOGLN("CloneRange()--> **** IN EVT Q THREAD ****")
		jrv=JRexDOMRangeImpl_CloneRangeInternal(env, thisRange);
	}else{
		nsresult rv=JRexDOMGlobals::ExecInEventQ(thisRange, JREX_CLONE_RANGE, nsnull, PR_TRUE, HandleJRexDOMRangeEvent, DestroyJRexDOMRangeEvent, (void**)&jrv);
		JREX_LOGLN("CloneRange()--> **** ExecInEventQ rv<"<<rv<<"> ****")
	}
	JREX_LOGLN("CloneRange()--> **** jrv<"<<jrv<<"> ****")
	if(NOT_NULL(jrv)){
		nsresult rv=jrv->rv;
		jobject jobj=jrv->jobj;
		delete jrv;
		if (NS_FAILED(rv)) {
			if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
				JREX_LOGLN("CloneRange()--> **** CloneRange DOM ERROR OCCURED !!!****")
				JRexDOMGlobals::ThrowDOMException(env, rv);
			}else{
				JREX_LOGLN("CloneRange()--> **** CloneRange NON-DOM ERROR OCCURED !!!****")
				ThrowJRexException(env, "**** CloneRange Failed ****",rv);
			}
			return NULL;
		}
		return jobj;
	}

	JREX_CATCH(env)
	return NULL;
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    ToString
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_ToString
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return NULL;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("ToString()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "ToString()--> **** thisRange DOES NOT EXIST!!! ****",0);
		return NULL;
	}
	nsString retString;
	nsresult rv = thisRange->ToString(retString);
	JREX_LOGLN("ToString()--> **** ToString rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("ToString()--> **** ToString DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else{
			JREX_LOGLN("ToString()--> **** ToString NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** ToString Failed ****",rv);
		}
		return NULL;
	}
	return env->NewStringUTF(ToNewCString(retString));
	JREX_CATCH(env)
	return NULL;

}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    Detach
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_Detach
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("Detach()--> **** thisRange <"<<thisRange<<"> ****")

	if(IS_NULL(thisRange)){
		ThrowJRexException(env, "**** Detach()--> thisRange DOES NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv = thisRange->Detach();
	JREX_LOGLN("Detach()--> **** Detach rv<"<<rv<<"> ****")
	if (NS_FAILED(rv)) {
		if (NS_ERROR_GET_MODULE(rv) == NS_ERROR_MODULE_DOM){
			JREX_LOGLN("Detach()--> **** Detach DOM ERROR OCCURED !!!****")
			JRexDOMGlobals::ThrowDOMException(env, rv);
		}else{
			JREX_LOGLN("Detach()--> **** Detach NON-DOM ERROR OCCURED !!!****")
			ThrowJRexException(env, "**** Detach Failed ****",rv);
		}
	}
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl
 * Method:    Finalize
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_dom_ranges_JRexDOMRangeImpl_Finalize
  (JNIEnv * env, jobject jrangeImpl){

	if(!JRexDOMGlobals::sIntialized)return;
	JREX_TRY
	nsIDOMRange* thisRange=(nsIDOMRange*)NS_INT32_TO_PTR(env->GetIntField(jrangeImpl, JRexDOMGlobals::rangePeerID));
	JREX_LOGLN("JRexDOMRangeImpl Finalize()--> **** thisRange <"<<thisRange<<"> ****")
	if(IS_NULL(thisRange)){
		JREX_LOGLN("JRexDOMRangeImpl Finalize()--> **** thisRange DOES NOT EXIST!!! ****");
		return;
	}
	nsresult rv=thisRange->Detach();
	JREX_LOGLN("JRexDOMRangeImpl Finalize()--> **** Detach rv<"<<rv<<"> ****")
	SAFE_RELEASE(thisRange)
	JREX_CATCH(env)
}


void* PR_CALLBACK HandleJRexDOMRangeEvent(PLEvent* aEvent){
	JRexDOMGlobals::JRexBasicDOMEvent* event = NS_REINTERPRET_CAST(JRexDOMGlobals::JRexBasicDOMEvent*, aEvent);
	nsresult rv=NS_OK;
	JREX_LOGLN("HandleJRexDOMRangeEvent()--> **** target <"<<event->target<<"> ****")
	switch(event->eventType){
		case JREX_GET_START_CONT:
		{
			JREX_LOGLN("HandleJRexDOMRangeEvent JREX_GET_ROOT EVENT!!!****")
			nsCOMPtr<nsIDOMRange> range(do_QueryInterface(event->target));
			return (void*)JRexDOMRangeImpl_GetStartContainerInternal(nsnull, range.get());
		}
		case JREX_GET_END_CONT:
		{
			JREX_LOGLN("HandleJRexDOMRangeEvent JREX_GET_END_CONT EVENT!!!****")
			nsCOMPtr<nsIDOMRange> range(do_QueryInterface(event->target));
			return (void*)JRexDOMRangeImpl_GetEndContainerInternal(nsnull, range.get());
		}
		case JREX_EXT_CONT:
		{
			JREX_LOGLN("HandleJRexDOMRangeEvent JREX_EXT_CONT EVENT!!!****")
			nsCOMPtr<nsIDOMRange> range(do_QueryInterface(event->target));
			return (void*)JRexDOMRangeImpl_ExtractContentsInternal(nsnull, range.get());
		}
		case JREX_CLONE_CONT:
		{
			JREX_LOGLN("HandleJRexDOMRangeEvent JREX_CLONE_CONT EVENT!!!****")
			nsCOMPtr<nsIDOMRange> range(do_QueryInterface(event->target));
			return (void*)JRexDOMRangeImpl_CloneContentsInternal(nsnull, range.get());
		}
		case JREX_CLONE_RANGE:
		{
			JREX_LOGLN("HandleJRexDOMRangeEvent JREX_CLONE_RANGE EVENT!!!****")
			nsCOMPtr<nsIDOMRange> range(do_QueryInterface(event->target));
			return (void*)JRexDOMRangeImpl_CloneRangeInternal(nsnull, range.get());
		}
		default:
		{
			JREX_LOGLN("HandleJRexDOMRangeEvent()--> **** EVENT TYPE<"<<event->eventType<<"> not handled!!! ****")
		}
	}
	JREX_LOGLN("HandleJRexDOMRangeEvent()--> **** returning rv<"<<rv<<"> ****")
	return (void*)rv;
}

void PR_CALLBACK DestroyJRexDOMRangeEvent(PLEvent* aEvent){
	JRexDOMGlobals::JRexBasicDOMEvent* event = NS_REINTERPRET_CAST( JRexDOMGlobals::JRexBasicDOMEvent*, aEvent);
	JREX_LOGLN("DestroyJRexDOMRangeEvent()--> **** target <"<<event->target<<"> ****")
	delete event;
}