/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "org_mozilla_jrex_io_JRexInputStream.h"
#include "JRex_JNI_util.h"
using namespace JREX_JNI_UTIL;

/*
 * Class:     org_mozilla_jrex_io_JRexInputStream
 * Method:    Init
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_io_JRexInputStream_Init
  (JNIEnv *env, jobject jinput){
	JREX_TRY
    jfieldID streamPeerID= env->GetFieldID(env->GetObjectClass(jinput),"streamPeer","J");
    JREX_LOGLN("JRexInputStream_Init()--> **** streamPeerID <"<<streamPeerID<<"> ****")
    nsIInputStream *in = (nsIInputStream*)NS_INT32_TO_PTR(env->GetIntField(jinput, streamPeerID));
    JREX_LOGLN("JRexInputStream_Init()--> **** in <"<<in<<"> ****")
	if (!in){
		ThrowJRexException(env, "**** JRexInputStream_Init Native Stream is Invalid!!!!****",0);
	    return;
	}
	NS_ADDREF(in);
    JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_io_JRexInputStream
 * Method:    Available
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_mozilla_jrex_io_JRexInputStream_Available
  (JNIEnv *env, jobject jinput){
	JREX_TRY
	jfieldID streamPeerID= env->GetFieldID(env->GetObjectClass(jinput),"streamPeer","J");
    nsIInputStream * in = (nsIInputStream*)NS_INT32_TO_PTR(env->GetIntField(jinput, streamPeerID));
    JREX_LOGLN("JRexInputStream_Available()--> **** in <"<<in<<"> ****")
	if (!in){
		ThrowJRexException(env, "**** JRexInputStream_Available Native Stream is Invalid!!!!****",0);
	    return 0;
	}
    PRUint32 avail=0;
	nsresult rv=in->Available(&avail);
	JREX_LOGLN("JRexInputStream_Available()--> **** rv <"<<rv<<">  avail <"<<avail<<"> ****")
    return (jint)avail;
    JREX_CATCH(env)
    return 0;
}

/*
 * Class:     org_mozilla_jrex_io_JRexInputStream
 * Method:    Read
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_mozilla_jrex_io_JRexInputStream_Read__
  (JNIEnv *env, jobject jinput){
	JREX_TRY
	jfieldID streamPeerID= env->GetFieldID(env->GetObjectClass(jinput),"streamPeer","J");
    nsIInputStream * in = (nsIInputStream*)NS_INT32_TO_PTR(env->GetIntField(jinput, streamPeerID));
    JREX_LOGLN("JRexInputStream_Read__()--> **** in <"<<in<<"> ****")
	if (!in){
		ThrowJRexException(env, "**** JRexInputStream_Read__ Native Stream is Invalid!!!!****",0);
	    return -1;
	}

    jbyte *buff = (jbyte*)malloc(sizeof(jbyte));
    if (!buff) {
		ThrowJRexException(env, "**** JRexInputStream_Read__ Out Of Memory!!!!****",0);
		return -1;
    }

	PRUint32 bytesRead=0;
    nsresult rv = in->Read((char*)buff,1,&bytesRead);
    JREX_LOGLN("JRexInputStream_Read___3BII()--> **** Read rv <"<<rv<<"> bytesRead<"<<bytesRead<<"> ****")
    if (NS_FAILED(rv)) {
		free(buff);
		ThrowJRexException(env, "**** JRexInputStream_Read__ Native Stream Read failed !!!!****",rv);
		return -1;
	}
	jint jrv=(jint)bytesRead>0?buff[0]:-1;
	free(buff);
	return jrv;
    JREX_CATCH(env)
    return -1;
}

/*
 * Class:     org_mozilla_jrex_io_JRexInputStream
 * Method:    Read
 * Signature: ([BII)I
 */
JNIEXPORT jint JNICALL Java_org_mozilla_jrex_io_JRexInputStream_Read___3BII
  (JNIEnv *env, jobject jinput, jbyteArray jbyteArry, jint off, jint len){
	JREX_TRY
	jfieldID streamPeerID= env->GetFieldID(env->GetObjectClass(jinput),"streamPeer","J");
    nsIInputStream * in = (nsIInputStream*)NS_INT32_TO_PTR(env->GetIntField(jinput, streamPeerID));
    JREX_LOGLN("JRexInputStream_Read___3BII()--> **** in <"<<in<<"> ****")
	if (!in){
		ThrowJRexException(env, "**** JRexInputStream_Read___3BII Native Stream is Invalid!!!!****",0);
	    return -1;
	}
    jbyte *buff = (jbyte*)malloc(sizeof(jbyte)*len);
    if (!buff) {
		ThrowJRexException(env, "**** JRexInputStream_Read___3BII Out Of Memory!!!!****",0);
		return -1;
    }

	PRUint32 bytesRead=0;
    nsresult rv = in->Read((char*)buff ,(PRUint32)len, &bytesRead);
    JREX_LOGLN("JRexInputStream_Read___3BII()--> **** Read rv <"<<rv<<"> bytesRead<"<<bytesRead<<"> ****")
    if (NS_FAILED(rv)) {
		free(buff);
		ThrowJRexException(env, "**** JRexInputStream_Read__ Native Stream Read failed !!!!****",rv);
		return -1;
	}
    env->SetByteArrayRegion(jbyteArry,off,(jint)bytesRead,buff);
    free(buff);
	return (jint)bytesRead;
    JREX_CATCH(env)
    return -1;

}

/*
 * Class:     org_mozilla_jrex_io_JRexInputStream
 * Method:    Close
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_io_JRexInputStream_Close
  (JNIEnv *env, jobject jinput){
	JREX_TRY
	jfieldID streamPeerID= env->GetFieldID(env->GetObjectClass(jinput),"streamPeer","J");
    nsIInputStream * in = (nsIInputStream*)NS_INT32_TO_PTR(env->GetIntField(jinput, streamPeerID));
    JREX_LOGLN("JRexInputStream_Close()--> **** in <"<<in<<"> ****")
	if (!in){
		ThrowJRexException(env, "**** JRexInputStream_Close Native Stream is Invalid!!!!****",0);
	    return;
	}
	nsresult rv=in->Close();
	JREX_LOGLN("JRexInputStream_Close()--> **** Close rv <"<<rv<<"> ****")
	NS_RELEASE(in);
	env->SetIntField(jinput, streamPeerID,0);
	JREX_CATCH(env)
}

