/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.event.context;

import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.w3c.dom.Node;

public class ContextMenuEvent {
    private static final String className = ContextMenuEvent.class.getName();
    private int jrexPeer;
    private int contextFlags;
    private int cX;
    private int cY;
    private Node targetNode;
    private int nodeType;
    private String uri;
    private String imgUri;

    public ContextMenuEvent(int jrexPeer, int contextFlags, int cX, int cY, Node targetNode, int nodeType, String uri, String imgUri) {
        if (JRexL.on) {
            JRexL.log(className, "**** ContextMenuEvent()-->jrexPeer<" + jrexPeer + ">contextFlags<" + contextFlags + "> cX<" + cX + ">cY<" + cY + "> targetNode<" + targetNode + "> nodeType<" + nodeType + "> uri<" + uri + "> imgUri<" + imgUri + "> ****");
        }
        this.jrexPeer = jrexPeer;
        this.contextFlags = contextFlags;
        this.cX = cX;
        this.cY = cY;
        this.targetNode = targetNode;
        this.nodeType = nodeType;
        this.uri = uri;
        this.imgUri = imgUri;
    }

    public int getJRexPeer() {
        return this.jrexPeer;
    }

    public int getContextFlags() {
        return this.contextFlags;
    }

    public int getClientX() {
        return this.cX;
    }

    public int getClientY() {
        return this.cY;
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public String getURI() {
        return this.uri;
    }

    public String getImageURI() {
        return this.imgUri;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(512);
        buf.append("\njrexPeer <").append(this.jrexPeer).append(">\n").append("contextFlags <").append(this.contextFlags).append(">\n").append("cX <").append(this.cX).append(">\n").append("cY <").append(this.cY).append(">\n").append("targetNode <").append(this.targetNode).append(">\n").append("nodeType <").append(this.nodeType).append(">\n").append("uri <").append(this.uri).append(">\n").append("imgUri <").append(this.imgUri).append(">\n");
        return buf.toString();
    }

    private static native void initIDs() throws JRexException;

    static {
        try {
            ContextMenuEvent.initIDs();
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new RuntimeException(ex);
        }
    }
}

