/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.dom;

import org.mozilla.jrex.JRexFactory;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class JRexDOMImplementationImpl
implements DOMImplementation {
    private static final String className = (class$org$mozilla$jrex$dom$JRexDOMImplementationImpl == null ? (class$org$mozilla$jrex$dom$JRexDOMImplementationImpl = JRexDOMImplementationImpl.class$("org.mozilla.jrex.dom.JRexDOMImplementationImpl")) : class$org$mozilla$jrex$dom$JRexDOMImplementationImpl).getName();
    private static JRexDOMImplementationImpl inst;
    private int peerDOMImpl = 0;
    static /* synthetic */ Class class$org$mozilla$jrex$dom$JRexDOMImplementationImpl;

    private JRexDOMImplementationImpl() {
        if (JRexL.on) {
            JRexL.log(className, "**** JRexDOMImplementationImpl ****");
        }
    }

    public static boolean initialize() {
        if (JRexL.on) {
            JRexL.log(className, "**** initialize isDOMEnabled<" + JRexFactory.getInstance().isDOMEnabled() + "> ****");
        }
        if (!JRexFactory.getInstance().isDOMEnabled()) {
            return false;
        }
        try {
            JRexDOMImplementationImpl.Initialize();
            return true;
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            return false;
        }
    }

    public static void unInitialize() {
        if (JRexL.on) {
            JRexL.log(className, "**** unInitialize isDOMEnabled<" + JRexFactory.getInstance().isDOMEnabled() + "> ****");
        }
        if (!JRexFactory.getInstance().isDOMEnabled()) {
            return;
        }
        try {
            JRexDOMImplementationImpl.UnInitialize();
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public static synchronized DOMImplementation getInstance() {
        if (JRexL.on) {
            JRexL.log(className, "**** getInstance isDOMEnabled<" + JRexFactory.getInstance().isDOMEnabled() + "> ****");
        }
        if (!JRexFactory.getInstance().isDOMEnabled()) {
            return null;
        }
        if (inst == null) {
            inst = new JRexDOMImplementationImpl();
            try {
                inst.CreateInstance();
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
        return inst;
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        if (JRexL.on) {
            JRexL.log(className, "**** createDocument namespaceURI<" + namespaceURI + "> qualifiedName<" + qualifiedName + ">  doctype<" + doctype + ">****");
        }
        Document doc = null;
        try {
            doc = this.CreateDocument(namespaceURI, qualifiedName, doctype);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** createDocument doc<" + doc + "> ****");
        }
        return doc;
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        if (JRexL.on) {
            JRexL.log(className, "**** createDocumentType qualifiedName<" + qualifiedName + "> publicId<" + publicId + ">  systemId<" + systemId + ">****");
        }
        DocumentType docType = null;
        try {
            docType = this.CreateDocumentType(qualifiedName, publicId, systemId);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** createDocumentType docType<" + docType + "> ****");
        }
        return docType;
    }

    public boolean hasFeature(String feature, String version) {
        if (JRexL.on) {
            JRexL.log(className, "**** hasFeature feature<" + feature + "> version<" + version + "> ****");
        }
        boolean hasFeature = false;
        try {
            hasFeature = this.HasFeature(feature, version);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** hasFeature hasFeature<" + hasFeature + "> ****");
        }
        return hasFeature;
    }

    public boolean equals(Object obj) {
        if (JRexL.on) {
            JRexL.log(className, "**** equals obj<" + obj + "> ****");
        }
        if (!(obj instanceof JRexDOMImplementationImpl)) {
            return false;
        }
        return ((JRexDOMImplementationImpl)obj).peerDOMImpl == this.peerDOMImpl;
    }

    public int hashCode() {
        if (JRexL.on) {
            JRexL.log(className, "**** hashCode ****");
        }
        return this.peerDOMImpl;
    }

    protected void finalize() {
        if (JRexL.on) {
            JRexL.log(className, "**** finalize ****");
        }
        try {
            this.Finalize();
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    private static native void Initialize() throws JRexException;

    private static native void UnInitialize() throws JRexException;

    private native void CreateInstance() throws JRexException;

    private native Document CreateDocument(String var1, String var2, DocumentType var3) throws DOMException, JRexException;

    private native DocumentType CreateDocumentType(String var1, String var2, String var3) throws DOMException, JRexException;

    private native boolean HasFeature(String var1, String var2) throws JRexException;

    private native void Finalize() throws JRexException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

