/*
 * Decompiled with CFR 0.152.
 */
package test.liveconnect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import netscape.javascript.JSObject;
import netscape.javascript.JSUtil;
import org.mozilla.jrex.JRexFactory;
import org.mozilla.jrex.event.progress.ProgressEvent;
import org.mozilla.jrex.event.progress.ProgressListener;
import org.mozilla.jrex.event.window.WindowListener;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.liveconnect.JRexLiveConnectSession;
import org.mozilla.jrex.liveconnect.JRexLiveConnectSessionImpl;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.window.JRexWindowManager;
import test.liveconnect.LCTestClass;

public class JRexLiveConnectSessionUnitTest
implements WindowListener,
ProgressListener {
    private JRexWindowManager winManager;
    private String testFile;
    private JRexLiveConnectSession lcSession;
    private JRexCanvas browser;
    private JFrame main;
    private JCheckBox goBox = new JCheckBox("Ok to test");
    private PrintStream testOut;
    static final String testReportFileName = "lcTests.txt";

    static void debug(String msg) {
        System.out.print("JRexLiveConnectSessionUnitTest::");
        System.out.println(msg);
    }

    public void initJRex(String testFile) throws JRexException {
        System.setProperty("javaplugin.outputfiles.path", "c:\\tmp\\plugin");
        System.setProperty("javaplugin.trace", "true");
        System.setProperty("javaplugin.automation", "true");
        this.testFile = testFile;
        this.main = new JFrame("MAIN");
        JPanel panel = new JPanel(new BorderLayout());
        this.main.getContentPane().setLayout(new BorderLayout());
        this.main.getContentPane().add((Component)panel, "Center");
        this.main.getContentPane().add((Component)this.goBox, "South");
        this.main.setVisible(true);
        this.goBox.setSelected(true);
        JRexFactory.getInstance().startEngine();
        this.winManager = (JRexWindowManager)JRexFactory.getInstance().getImplInstance("WindowManager");
        this.winManager.create(2);
        this.winManager.addJRexWindowListener(this);
        this.winManager.init(panel);
    }

    public static void main(String[] s) throws Exception {
        if (s.length != 1) {
            System.err.println("Usage: java JRexLiveConnectSessionExample <testFile>");
            System.exit(-1);
        }
        new JRexLiveConnectSessionUnitTest().initJRex(s[0]);
    }

    public void windowCreated(int jrexPeerID) {
        System.err.println(" windowCreated ##################### jrexPeerID <" + jrexPeerID + ">#####################");
        if (this.goBox.isSelected()) {
            this.browser = this.winManager.getBrowser(jrexPeerID);
            this.browser.addProgressListener(this);
            JRexLiveConnectSessionUnitTest.debug("Loading sample javascript app");
            try {
                this.browser.getNavigator().loadURI("file:///" + new File(this.testFile).getCanonicalPath().replace('\\', '/'), 0, null, null, null);
            }
            catch (Exception e) {
                System.err.println("ERROR: Failed to load testFile: \"" + this.testFile + "\"");
                e.printStackTrace();
            }
        }
    }

    public void windowDisposing(int jrexPeerID) {
        System.err.println("windowDisposing ##################### jrexPeerID <" + jrexPeerID + ">#####################");
    }

    public void onStateChange(ProgressEvent event) {
        if (this.goBox.isSelected() && !event.isLoadingDocument()) {
            this.goBox.setSelected(false);
            new Thread(new Runnable(){

                public void run() {
                    JRexLiveConnectSessionUnitTest.debug("Document is loaded");
                    JRexLiveConnectSessionUnitTest.this.runTests();
                }
            }).start();
        }
    }

    String invokeStringMethod(String funcName, String arg) throws JRexException {
        String ret = this.lcSession.invokeStringMethod("testStringFunction", "Hello, World!");
        JRexLiveConnectSessionUnitTest.debug("invokeStringMethod: funcName<" + funcName + "> arg<" + arg + "> ret<" + ret + ">");
        return ret;
    }

    public void onProgressChange(ProgressEvent event) {
    }

    public void onLocationChange(ProgressEvent event) {
    }

    public void onStatusChange(ProgressEvent event) {
    }

    public void onSecurityChange(ProgressEvent event) {
    }

    public void onLinkStatusChange(ProgressEvent event) {
    }

    void test_debug(String msg) throws Exception {
        JRexLiveConnectSessionUnitTest.debug(msg);
        this.testOut.println(msg);
        this.testOut.flush();
    }

    void assertTrue(boolean condition) throws Exception {
        if (!condition) {
            String msg = "Assertion failure. Current Stack:\n" + JSUtil.getStackTrace(new RuntimeException());
            this.test_debug(msg);
            throw new RuntimeException(msg);
        }
    }

    void runTests() {
        final File reportFile = new File(testReportFileName);
        try {
            this.testOut = new PrintStream(new FileOutputStream(reportFile));
            this.test_debug("RUNNING LIVECONNECT UNIT TESTS  " + new Date());
            this.test_debug("REPORT FILE = lcTests.txt");
            this.lcSession = new JRexLiveConnectSessionImpl(this.browser);
            this.lcSession.grantBrowserAccessToJVM();
            this.testInvokeStringMethod();
            this.testEvalUntrusted1();
            this.testEvalUntrusted2();
            this.testGetJSObject();
            this.testEval1();
            this.testEval2();
            this.testCall1();
            this.testCall2();
            this.testCreateListInJavascript1();
            this.testCreateListInJavascript2();
            this.testCreateLCTestClassInJavascript();
            this.testGetMember();
            this.test_debug("ALL TESTS PASSED");
            this.testOut.close();
        }
        catch (Throwable e) {
            try {
                this.test_debug("TESTS FAILED:\n" + JSUtil.getStackTrace(e));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.testOut.close();
        }
        new Thread(new Runnable(){

            public void run() {
                try {
                    JRexLiveConnectSessionUnitTest.this.browser.getNavigator().loadURI("file:///" + reportFile.getCanonicalPath(), 0, null, null, null);
                    JRexLiveConnectSessionUnitTest.this.main.setSize(800, 800);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    void testInvokeStringMethod() throws Exception {
        String ret = this.invokeStringMethod("testStringFunction", "Hello, World!");
        this.test_debug("invokeStringMethod: function<testStringFunction> arg<\"Hello, World!\"> res_class<" + (ret != null ? ret.getClass().getName() : "NULL") + "> ret<" + ret + ">");
        this.assertTrue(ret != null && ret.equals("Hello, World!_test"));
    }

    void checkEvalUntrusted(String toEval, String expected) throws Exception {
        String res = this.lcSession.evalUntrusted(toEval);
        this.testCmp("testEvalUntrusted", toEval, expected, res);
    }

    void testEvalUntrusted1() throws Exception {
        this.checkEvalUntrusted("(1+2+5-3)/2", "2.5");
    }

    void testEvalUntrusted2() throws Exception {
        this.checkEvalUntrusted("testStringFunction('Hi there')", "Hi there_test");
    }

    void testGetJSObject() throws Exception {
        JSObject obj = this.lcSession.getJSWindow();
        this.assertTrue(obj != null);
    }

    void testCmp(String testName, String dataStr, Object expected, Object res) throws Exception {
        Class<?> expectedClass = expected.getClass();
        this.test_debug(testName + ": data<" + dataStr + "> result<" + res + "> res_class<" + (res != null ? res.getClass().getName() : "NULL") + "> expected<" + expected + "> expectedClass<" + expectedClass.getName() + ">");
        this.assertTrue(res != null);
        this.assertTrue(expected.equals(res));
    }

    void checkEval(String toEval, Object expected) throws Exception {
        Object res = this.lcSession.getJSWindow().eval(toEval);
        this.testCmp("testEval", toEval, expected, res);
    }

    void testEval1() throws Exception {
        this.checkEval("(1+2+5-3)/2", new Double(2.5));
    }

    void testEval2() throws Exception {
        this.checkEval("testStringFunction('Hi there')", "Hi there_test");
    }

    void checkCall(String funcName, Object[] args, Object expected) throws Exception {
        Object res = this.lcSession.getJSWindow().call(funcName, args);
        this.testCmp("testCall", Arrays.asList(args).toString(), expected, res);
    }

    void testCall1() throws Exception {
        this.checkCall("testStringFunction", new Object[]{"This is a test str"}, "This is a test str_test");
    }

    void testGetMember() throws Exception {
        Object document = this.lcSession.getJSWindow().getMember("document");
        this.test_debug("Got document member = " + document + ", class = " + (document != null ? document.getClass().getName() : "NULL"));
        this.assertTrue(document instanceof JSObject);
        this.assertTrue(document.toString().startsWith("[object HTMLDocument"));
    }

    public String getSampleString() {
        return "Sample string from java";
    }

    void testCall2() throws Exception {
        this.checkCall("testCallToJava", new Object[]{this}, this.getSampleString());
    }

    void checkCreateListInJavascript_cmp(Vector v, int indx, Object expected) throws Exception {
        Object obj = v.get(indx);
        this.test_debug("    indx<" + indx + "> obj<" + obj + "> obj_class<" + (obj != null ? obj.getClass().getName() : "NULL") + "> expected<" + expected + "> expected_class<" + expected.getClass().getName() + ">");
    }

    void checkCreateListInJavascript(Object res) throws Exception {
        this.test_debug("testCreateListInJavascript res<" + res + ">");
        this.assertTrue(res instanceof Vector);
        Vector v = (Vector)res;
        this.test_debug("testCreateListInJavascript res.size()<" + v.size() + ">");
        this.assertTrue(v.size() == 8);
        this.checkCreateListInJavascript_cmp(v, 0, "one");
        this.checkCreateListInJavascript_cmp(v, 1, "two");
        this.checkCreateListInJavascript_cmp(v, 2, "three");
        this.checkCreateListInJavascript_cmp(v, 3, "four");
        this.checkCreateListInJavascript_cmp(v, 4, "five");
        this.checkCreateListInJavascript_cmp(v, 5, "six");
        this.checkCreateListInJavascript_cmp(v, 6, new Double(7.0));
        this.checkCreateListInJavascript_cmp(v, 7, new Double(4.5));
    }

    void testCreateListInJavascript1() throws Exception {
        this.checkCreateListInJavascript(this.lcSession.getJSWindow().call("testCreateList", new Object[0]));
    }

    void testCreateListInJavascript2() throws Exception {
        this.checkCreateListInJavascript(this.lcSession.getJSWindow().eval("testCreateList()"));
    }

    void testCreateLCTestClassInJavascript_cmp(Object obj, Object expected) throws Exception {
        this.test_debug("    obj<" + obj + "> obj_class<" + (obj != null ? obj.getClass().getName() : "NULL") + "> expected<" + expected + "> expected_class<" + expected.getClass().getName() + ">");
    }

    void testCreateLCTestClassInJavascript() throws Exception {
        Object res = this.lcSession.getJSWindow().eval("testCreateLCTestClass()");
        this.assertTrue(res != null);
        this.assertTrue(res instanceof LCTestClass);
        LCTestClass testCls = (LCTestClass)res;
        this.assertTrue(testCls.getTestDataMap().get("fromjavascript.window") != null);
        this.assertTrue(testCls.getTestDataMap().get("fromjavascript.document") != null);
        this.test_debug("testCls.getTestDataMap().get(\"fromjavascript.window\") class<" + testCls.getTestDataMap().get("fromjavascript.window").getClass().getName() + ">");
        this.test_debug("testCls.getTestDataMap().get(\"fromjavascript.document\") class<" + testCls.getTestDataMap().get("fromjavascript.document").getClass().getName() + ">");
        this.assertTrue(testCls.getTestDataMap().get("fromjavascript.window") instanceof JSObject);
        this.assertTrue(testCls.getTestDataMap().get("fromjavascript.document") instanceof JSObject);
        this.test_debug("testCreateLCTestClassInJavascript testCls_props<" + testCls.getTestDataMap() + ">");
        this.testCreateLCTestClassInJavascript_cmp(testCls.getTestString(), "Hello, World!");
        this.testCreateLCTestClassInJavascript_cmp(new Integer(testCls.getTestInt()), new Integer(50));
        this.testCreateLCTestClassInJavascript_cmp(new Float(testCls.getTestFloat()), new Float(15.5));
        this.testCreateLCTestClassInJavascript_cmp(new Double(testCls.getTestDouble()), new Double(42.5));
        this.testCreateLCTestClassInJavascript_cmp(new Long(testCls.getTestLong()), new Long(123456789L));
    }

    static {
        testReportFileName = testReportFileName;
    }
}

