/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.xpcom;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.xpcom.JRexXPCOM;

public class JRexXPCOMImpl
implements JRexXPCOM {
    private static final String className = (class$org$mozilla$jrex$xpcom$JRexXPCOMImpl == null ? (class$org$mozilla$jrex$xpcom$JRexXPCOMImpl = JRexXPCOMImpl.class$("org.mozilla.jrex.xpcom.JRexXPCOMImpl")) : class$org$mozilla$jrex$xpcom$JRexXPCOMImpl).getName();
    private static final String DEFAULT_PROFILE = ".JRex";
    private Thread xpcomThread = null;
    private int xpcomInitRV = 0;
    private static final JRexXPCOM xpcomInst;
    static /* synthetic */ Class class$org$mozilla$jrex$xpcom$JRexXPCOMImpl;

    private JRexXPCOMImpl() {
    }

    public static JRexXPCOM getInstance() throws JRexException {
        return xpcomInst;
    }

    private static final void loadLibraries(String greDir) {
        try {
            InputStream in = (class$org$mozilla$jrex$xpcom$JRexXPCOMImpl == null ? (class$org$mozilla$jrex$xpcom$JRexXPCOMImpl = JRexXPCOMImpl.class$("org.mozilla.jrex.xpcom.JRexXPCOMImpl")) : class$org$mozilla$jrex$xpcom$JRexXPCOMImpl).getClassLoader().getResourceAsStream("jrex.lib");
            if (in != null) {
                BufferedReader bin = new BufferedReader(new InputStreamReader(in));
                if (JRexL.on) {
                    JRexL.log(className, "loadLibraries()--> **** Loading library list... ****");
                }
                String temp = null;
                while ((temp = bin.readLine()) != null) {
                    temp = temp.trim();
                    if (JRexL.on) {
                        JRexL.log(className, "loadLibraries()--> **** Library to load<" + temp + ">****");
                    }
                    if (temp == "" || temp.startsWith("#")) continue;
                    File tempFile = new File(greDir, temp = System.mapLibraryName(temp));
                    if (!tempFile.exists()) {
                        if (!JRexL.on) continue;
                        JRexL.log(className, "loadLibraries()--> **** Library <" + tempFile + "> does not exsist!!!****");
                        continue;
                    }
                    String libPath = tempFile.getCanonicalPath();
                    if (JRexL.on) {
                        JRexL.log(className, "loadLibraries()--> **** Loading library <" + libPath + ">...****");
                    }
                    try {
                        System.load(libPath);
                        if (!JRexL.on) continue;
                        JRexL.log(className, "loadLibraries()--> **** Loading library <" + libPath + "> done!!!****");
                    }
                    catch (UnsatisfiedLinkError error) {
                        if (!JRexL.on) continue;
                        JRexL.log(className, "loadLibraries()--> **** Loading library <" + libPath + "> FAILED!!! ****");
                    }
                }
                bin.close();
            }
        }
        catch (Exception ex) {
            JRexL.printStackTrace(ex);
        }
        System.loadLibrary("jawt");
    }

    public synchronized void startXPCOM() throws JRexException {
        JRexException jrexExp;
        block6: {
            if (this.xpcomThread != null) {
                if (JRexL.on) {
                    JRexL.log(className, "startXPCOM()--> **** XPCOM ALL READY INSTANCIATED BY THREAD <" + this.xpcomThread + "> ****");
                }
                return;
            }
            jrexExp = new JRexException();
            this.xpcomThread = new Thread(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public void run() {
                    block13: {
                        try {
                            String profileName;
                            boolean forceNoProfile;
                            String grePath;
                            block12: {
                                grePath = System.getProperty("jrex.gre.path");
                                if (!$assertionsDisabled && grePath == null) {
                                    throw new AssertionError();
                                }
                                File temp = new File(grePath);
                                if (!temp.exists() || !temp.isDirectory()) {
                                    throw new JRexException("startXPCOM()--> **** INVALID GRE-PATH SPECIFIED,GRE-PATH SHOULD BE SET TO VALID DIRECTORY ***");
                                }
                                try {
                                    grePath = temp.getCanonicalPath();
                                }
                                catch (IOException ioex) {
                                    if (!JRexL.on) break block12;
                                    JRexL.printStackTrace(ioex);
                                }
                            }
                            if (JRexL.on) {
                                JRexL.log(className, "startXPCOM()--> **** USING GRE_PATH <" + grePath + "> ***");
                            }
                            JRexXPCOMImpl.loadLibraries(grePath);
                            String noprofile = System.getProperty("jrex.force.noprofile");
                            boolean bl = forceNoProfile = noprofile == null ? false : noprofile.trim().equals("true");
                            if (JRexL.on) {
                                JRexL.log(className, "startXPCOM()--> **** USING forceNoProfile <" + forceNoProfile + "> ***");
                            }
                            if ((profileName = System.getProperty("jrex.profile.name")) == null) {
                                profileName = JRexXPCOMImpl.DEFAULT_PROFILE;
                            }
                            if (JRexL.on) {
                                JRexL.log(className, "startXPCOM()--> **** USING profileName <" + profileName + "> ***");
                            }
                            String profilePath = System.getProperty("jrex.profile.path");
                            if (profileName != null && profilePath == null) {
                                profilePath = System.getProperty("user.home");
                            }
                            if (JRexL.on) {
                                JRexL.log(className, "startXPCOM()--> **** USING profilePath <" + profilePath + "> ***");
                            }
                            JRexXPCOMImpl.this.InitXPCOM(grePath, forceNoProfile ? null : profileName, profilePath);
                        }
                        catch (Throwable exp) {
                            jrexExp.initCause(exp);
                            JRexXPCOMImpl.this.notifyXPCOMInited(-1);
                            if (!JRexL.on) break block13;
                            JRexL.log(className, "startXPCOM()--> **** XPCOM INIT FAILED <" + exp.getMessage() + ">");
                        }
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$mozilla$jrex$xpcom$JRexXPCOMImpl == null ? (class$org$mozilla$jrex$xpcom$JRexXPCOMImpl = JRexXPCOMImpl.class$("org.mozilla.jrex.xpcom.JRexXPCOMImpl")) : class$org$mozilla$jrex$xpcom$JRexXPCOMImpl).desiredAssertionStatus();
                }
            };
            this.xpcomThread.setPriority(6);
            this.xpcomThread.start();
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                if (!JRexL.on) break block6;
                JRexL.log(className, "startXPCOM()--> **** InterruptedException <" + ex.getMessage() + "> occured while wait");
            }
        }
        if (JRexL.on) {
            JRexL.log(className, "startXPCOM()--> **** xpcomInitRV <" + this.xpcomInitRV + ">");
        }
        if (this.xpcomInitRV != 1) {
            throw jrexExp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyXPCOMInited(int xpcomInitRV) {
        if (JRexL.on) {
            JRexL.log(className, "notifyXPCOMInited()--> **** xpcomInitRV<" + xpcomInitRV + ">***");
        }
        this.xpcomInitRV = xpcomInitRV;
        JRexXPCOMImpl jRexXPCOMImpl = this;
        synchronized (jRexXPCOMImpl) {
            this.notify();
        }
    }

    public synchronized void stopXPCOM() throws JRexException {
        block3: {
            if (JRexL.on) {
                JRexL.log(className, "stopXPCOM()--> **** xpcomThread<" + this.xpcomThread + ">***");
            }
            this.ShutDownXPCOM();
            try {
                this.xpcomThread.join();
            }
            catch (InterruptedException ex) {
                if (!JRexL.on) break block3;
                JRexL.log(className, "stopXPCOM()--> **** InterruptedException <" + ex.getMessage() + "> occured while join");
            }
        }
    }

    private native void InitXPCOM(String var1, String var2, String var3) throws JRexException;

    private native void ShutDownXPCOM() throws JRexException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_PROFILE = DEFAULT_PROFILE;
        xpcomInst = new JRexXPCOMImpl();
    }
}

