/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.classes.bug;

import java.util.*;
import org.mozdev.MacroTracker.classes.bug.Status;

import com.trfenv.rlk.Debug;
/**
 *This class manages the Status's of BugDatabases. It can also have other
 *uses.
 *
 *<p>The main reason for using this class in this type of format is so that
 *status's returned by the class can use == in if statements and return an
 *accurate result (because only one reference of each status is created).</p>
 *
 *@author R.J. Keller <rlk@trfenv.com>
 */
public class StatusManager
{
	private List mAllStatuses = new LinkedList();
	private int mCurrentStatus;
	
	public Status get(String aStatusName)
	{
		for (Iterator i = mAllStatuses.iterator(); i.hasNext();)
		{
			Status j = (Status)i.next();
			if (j.toString().equals(aStatusName))
				return j;
		}
		Debug.printException(new IllegalArgumentException("The status requested does not exist."));
		return null;
	}
	
	public void add(String aStatusName)
	{
		mAllStatuses.add(new Status(mCurrentStatus, aStatusName));
		mCurrentStatus++;
	}
}
