/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.main;

import org.mozdev.MacroTracker.ui.*;
import org.mozdev.MacroTracker.classes.*;

import com.trfenv.rlk.Debug;

import javax.swing.*;
import java.io.*;
import java.awt.*;

/**
 *This class contains general functions to be used wihtin the function and the
 *state of MacroTracker.
 *@author R.J. Keller <rlk@trfenv.com>
 */
public final class MacroTracker
{
	private static UIManager.LookAndFeelInfo looks[];

	/** What version of MacroTracker this is. */
	public static final double VERSION = 0.1;
	
	/** Whether or not this versino of MacroTracker is a BETA version.*/
	public static final boolean IN_BETA = true;

	/** The bug database that is loaded into the application.*/
	public static iBugDatabase gMasterBugDatabase;

	/** The Bug Database to use to open Bugs.*/
	public static BugDesktop gMasterBugDesktop;

	/**
	 *MAIN FUNCTION FOR MACROTRACKER
	 *
	 *This is where all the magic starts ;)
	 */
	public static void main(String[] args)
	{
		com.trfenv.rlk.Debug.turnOn();
//		com.trfenv.rlk.Debug.outputToConsole = true;

		looks = UIManager.getInstalledLookAndFeels();

		try
		{
			//0 = new steel look
			//1 = modaf look
			//2 = win32 look
			//3 = win32 look, but doesn't show XP theme on winXP
			UIManager.setLookAndFeel( looks[0].getClassName() );
		}
		catch (Exception ex)
		{
			//An exception will be thrown on Linux and MacOS because the
			//Win32 style is not available on non-win32 systems. In these
			//cases, Java defaults to the normal steel look, which is OK.
			Debug.printException(ex);
			
			try
			{
				UIManager.setLookAndFeel( looks[3].getClassName() );
			}
			catch (Exception exception)
			{
			}
		}

		if (MacroTracker.IN_BETA)
		{
			//Upload test database for debugging until the Database Creation form is up.
			//masterBugDatabase = org.mozdev.MacroTracker.general.Debug.getTestDatabase();
		}

		//create a new frmMainScreen object. This object will automatically set
		//the size and display itself on the screen.
		frmMainScreen temp = new frmMainScreen();
	}

	/** Saves the masterBugDatabase to a file.
	 *@param fileLocation the place where masterBugDatabase should be saved to.
	 */
	public static void saveDatabase(File fileLocation)
	{
		if (gMasterBugDatabase != null)
		{
			try
			{
				ObjectOutputStream out = new ObjectOutputStream(
				                         new FileOutputStream(fileLocation) );
				out.writeObject( gMasterBugDatabase );
			}
			catch (FileNotFoundException ex)
			{
				Debug.printException(ex);
			}
			catch (Exception ex)
			{
				Debug.printException(ex);

				JOptionPane.showMessageDialog(null, "An error has occured when saving your file.");
			}
		}
	}

	/**
	 *Sets the masterBugDatabase from a file.
	 */
	public static void loadDatabase(File fileLocation)
	{
		try
		{
			ObjectInputStream in = new ObjectInputStream(
				                   new FileInputStream(fileLocation));
			gMasterBugDatabase = (MacroTrackerDatabase)in.readObject();
		}
		catch (Exception ex)
		{
			Debug.printException(ex);
			JOptionPane.showMessageDialog( null, "An error has occured when opening the bug database. Make sure it is a valid MacroTracker Bug Database File.");
		}
	}
	
	/**
	 *Centers a JFrame to the middle of the screen.
	 */
	public static void centerFrame(JFrame frame)
	{
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation((d.width-frame.getWidth())/2, (d.height-frame.getHeight())/2);
	}
}
