/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.ui;

import org.mozdev.MacroTracker.ui.*;
import org.mozdev.MacroTracker.main.MacroTracker;
import org.mozdev.MacroTracker.toolkit.*;
import org.mozdev.MacroTracker.classes.*;
import org.mozdev.firebirdhelp.general.ToolbarButton;

import com.trfenv.rlk.Debug;

import javax.swing.*;
import javax.swing.filechooser.*;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.*;
import java.io.File;
import org.mozdev.MacroTracker.toolkit.MenuItem;

/**
 * The Main MacroTracker screen.
 *
 * @author  R.J. Keller <rlk@trfenv.com>
 * @version 0.1
 */
public class frmMainScreen extends JFrame implements ActionListener, MouseListener
{
	private JLabel lblMacroLabel;
	private JLabel lblGoToBug;
	private JButton btnLoadDatabase;
	private JButton btnOpenBug;
	private JComboBox cboBugList;

	private hyperlinkLabel lblAccountSettings;
	private hyperlinkLabel lblFileNewBug;
	private hyperlinkLabel lblQueryBug;
	private hyperlinkLabel lblDatabaseAdmin;

	private MenuItem mnuNewDatabase;
	private MenuItem mnuOpenDatabase;
	private MenuItem mnuSaveDatabase;
	private MenuItem mnuExit;
	private MenuItem mnuHelpContents;
	private MenuItem mnuAbout;

	private ToolbarButton btnNewDatabase;
	private ToolbarButton btnOpenDatabase;
	private ToolbarButton btnFindBug;
	private ToolbarButton btnDatabasePreferences;

	public frmMainScreen()
	{
		super( "MacroTracker Main Screen" );

		getContentPane().setLayout( new BorderLayout() );

		//Use another panel to hold the main content. This will make the
		//toolbar drag around the screen correctly.
		JPanel pnlMainContent = new JPanel();
		pnlMainContent.setLayout( new BorderLayout() );

		//-- BEGIN TOOLBAR --//
		ContextToolbar standardTlbr = new ContextToolbar();

		btnNewDatabase = new ToolbarButton("", "/images/New16.gif", "/images/New24.gif");
		btnNewDatabase.setText("New Database");
		Debug.createObject(btnNewDatabase);
		btnOpenDatabase = new ToolbarButton("Open Database", "/images/Open16.gif", "/images/Open24.gif");
		Debug.createObject(btnOpenDatabase);
		btnFindBug = new ToolbarButton("Find a Bug", "/images/Find16.gif", "/images/Find24.gif");
		Debug.createObject(btnFindBug);
		btnDatabasePreferences = new ToolbarButton("Preferences", "/images/Preferences16.gif", "/images/Preferences24.gif");
		Debug.createObject(btnDatabasePreferences);

		btnNewDatabase.addActionListener( this );
		btnOpenDatabase.addActionListener( this );

	    standardTlbr.add(btnNewDatabase);
	    standardTlbr.add(btnOpenDatabase);
	    standardTlbr.addSeparator();
	    standardTlbr.add(btnFindBug);
	    standardTlbr.add(btnDatabasePreferences);

	    standardTlbr.setToolbarButtonMode(ToolbarButton.IMAGE_ONLY);

		getContentPane().add( standardTlbr, BorderLayout.PAGE_START );

		//-- END TOOLBAR --//


		JMenuBar mnuBar = new JMenuBar();

		setJMenuBar( mnuBar );

		JMenu mnuFile = new JMenu( "File" );
		mnuFile.setMnemonic('F');
		mnuBar.add( mnuFile );

		mnuNewDatabase = new MenuItem("New Database", "/images/New16.gif");
		mnuNewDatabase.setMnemonic('N');
		mnuNewDatabase.addActionListener( this );
		mnuFile.add( mnuNewDatabase );

		mnuOpenDatabase = new MenuItem("Open Database...", "/images/Open16.gif");
		mnuOpenDatabase.setMnemonic('O');
		mnuOpenDatabase.addActionListener( this );
		mnuFile.add( mnuOpenDatabase );

		mnuSaveDatabase = new MenuItem("Save Database As...", "/images/Save16.gif");
		mnuSaveDatabase.setMnemonic('S');
		mnuSaveDatabase.addActionListener( this );
		mnuFile.add( mnuSaveDatabase );

		mnuFile.addSeparator();

		mnuExit = new MenuItem("Exit");
		mnuExit.setMnemonic('x');
		mnuExit.addActionListener( this );
		mnuFile.add(mnuExit);

		mnuBar.add(StandardComponents.generateHelpMenu());

		JPanel pnlTop = new JPanel();
		pnlTop.setLayout( new GridLayout(2, 1));
		lblMacroLabel = new JLabel( "MacroTracker: No Database Loaded" );
		lblMacroLabel.setFont( new Font("sans-serif", Font.BOLD, 16) );
		pnlTop.add( lblMacroLabel );

		JPanel pnlGoToBug = new JPanel();
		pnlGoToBug.setLayout( new FlowLayout() );

		btnLoadDatabase = new JButton( "Load Database" );
		pnlGoToBug.add( btnLoadDatabase );

		btnLoadDatabase.addActionListener( this );

	    setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );

		lblGoToBug = new JLabel( "Go To Bug:" );
		lblGoToBug.setVisible( false );
		pnlGoToBug.add( lblGoToBug );

		cboBugList = new JComboBox();
		cboBugList.setVisible(false);
		pnlGoToBug.add( cboBugList );

		btnOpenBug = new JButton( "Open" );
		btnOpenBug.setVisible( false );
		btnOpenBug.addActionListener( this );
		pnlGoToBug.add( btnOpenBug );

		pnlTop.add( pnlGoToBug );
		pnlMainContent.add( pnlTop, BorderLayout.NORTH );

		JPanel pnlButtons = new JPanel();

		lblQueryBug = new hyperlinkLabel( "Query a Bug" );
		JPanel pnlQuery = new JPanel( new FlowLayout(FlowLayout.LEFT) );
		pnlQuery.add(lblQueryBug);
		pnlButtons.add( pnlQuery );

		lblFileNewBug = new hyperlinkLabel( "File a new Bug" );
		JPanel pnlFileNewBug = new JPanel( new FlowLayout(FlowLayout.LEFT) );
		pnlFileNewBug.add( lblFileNewBug );
		pnlButtons.add(pnlFileNewBug);

		lblAccountSettings = new hyperlinkLabel( "Account Settings" );
		JPanel pnlAccountSettings = new JPanel( new FlowLayout(FlowLayout.LEFT) );
		pnlAccountSettings.add(lblAccountSettings);
		pnlButtons.add(lblAccountSettings);

		lblDatabaseAdmin = new hyperlinkLabel( "Database Admin" );
		JPanel pnlDatabaseAdmin = new JPanel( new FlowLayout(FlowLayout.LEFT) );
		pnlDatabaseAdmin.add(lblDatabaseAdmin);
		pnlButtons.add(pnlDatabaseAdmin);

		pnlButtons.setLayout( new GridLayout(2,1) );

		pnlMainContent.add( pnlButtons, BorderLayout.CENTER );

		JLabel lblBugPic;
		try
		{
			lblBugPic = new JLabel(new ImageIcon(getClass().getResource("/images/ant.jpg")));
		}
		catch (Exception ex)
		{
			Debug.printException(ex, "Cannot load ant.jpg because it does not exist.");
			lblBugPic = new JLabel();
		}
		lblBugPic.setSize( 329, 220 );
		pnlMainContent.add( lblBugPic, BorderLayout.SOUTH );

		getContentPane().add( pnlMainContent, BorderLayout.CENTER );

		//Initalize the database. If the database is null, then this function
		//will do nothing. This will allow a test database that might of been
		//loaded at run-time to boot up correctly.
		initalizeComponentsWithDatabase();

		setSize( 300, 450 );

		//Make the window be in the center of the screen.
		MacroTracker.centerFrame(this);
		setVisible(true);

		Debug.createObject(this);
	}

	public void actionPerformed( ActionEvent event )
	{
		Debug.println("Running click event: " + event.getSource().getClass());

		if (event.getSource() == btnOpenBug)
		//Click Event - btnOpenBug
		{
			frmBug bugForm = new frmBug( MacroTracker.gMasterBugDatabase.getBug(cboBugList.getSelectedIndex()) );

			if (MacroTracker.gMasterBugDesktop == null)
				MacroTracker.gMasterBugDesktop = new BugDesktop();

			MacroTracker.gMasterBugDesktop.addDesktopItem(new frmBug(
				MacroTracker.gMasterBugDatabase.getBug(cboBugList.getSelectedIndex())), "Bug " + cboBugList.getSelectedIndex());
			MacroTracker.gMasterBugDesktop.setVisible( true );
		}
		else if (event.getSource() == btnNewDatabase || event.getSource() == mnuNewDatabase)
		//Click Event - btnNewDatabase, mnuNewDatabase
		{
			frmDatabaseCreation newDatabase = new frmDatabaseCreation();
			newDatabase.setVisible( true );
		}
		else if (event.getSource() == btnLoadDatabase || event.getSource() == mnuOpenDatabase || event.getSource() == btnOpenDatabase)
		//Click Event - btnLoadDatabase, mnuOpenDatabase
		{
			JFileChooser fileChooser = new JFileChooser();
			fileChooser.setFileFilter( StandardComponents.generateFileFilter() );
			int chooserStatus = fileChooser.showOpenDialog( this );

			//if the user didn't hit the cancel button on the file chooser
			//dialog.
			if (chooserStatus == JFileChooser.APPROVE_OPTION)
			{
				//If the user didn't somehow select a file that doesn't exist.
				if (fileChooser.getSelectedFile().exists())
				{
					MacroTracker.loadDatabase( fileChooser.getSelectedFile() );

					initalizeComponentsWithDatabase();
				}
				else
				{
					JOptionPane.showInputDialog(this,"The file you choose does not exist.");
				}
			}
		}
		else if (event.getSource() == mnuExit)
		//Click Event - mnuExit
		{
			System.exit(0);
		}
		else if (event.getSource() == mnuSaveDatabase)
		//Click Event - mnuSaveDatabase
		{
			JFileChooser fileChooser = new JFileChooser();

			fileChooser.setFileFilter(StandardComponents.generateFileFilter());
			int chooserStatus = fileChooser.showSaveDialog( this );

			if (chooserStatus == JFileChooser.APPROVE_OPTION)
			{
				MacroTracker.saveDatabase(fileChooser.getSelectedFile());
			}
		}
		else if (event.getSource() == mnuHelpContents)
		//Click Event - mnuHelpContents
		{
		}
	}

	public void initalizeComponentsWithDatabase()
	{
		//Make sure we're not initalizing a null database.
		if (MacroTracker.gMasterBugDatabase == null)
			return;

		//Load the bug database and enable the UI.
		//MacroTracker.loadDatabase( fileChooser.getSelectedFile() );

		btnLoadDatabase.setVisible( false );

		lblGoToBug.setVisible(true);
		cboBugList.setVisible(true);
		btnOpenBug.setVisible(true);

		for (int i = 0; i < MacroTracker.gMasterBugDatabase.bugCount(); i++)
		{
			cboBugList.addItem("Bug " + i);
		}
	}

	public void mouseClicked( MouseEvent e )
	{
	}

	public void mouseEntered( MouseEvent e ){}
	public void mouseExited( MouseEvent e ){}
	public void mousePressed( MouseEvent e ){}
	public void mouseReleased( MouseEvent e ){}
}
