/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Help Viewer API in Java.
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package org.mozdev.firebirdhelp.HelpViewer;

import java.util.Iterator;
import javax.swing.tree.*;

import com.trfenv.rlk.Debug;

public class HelpContent
{
	private String mName;
	private iHelpTopic mContents;
	private iHelpTopic mIndex;
	private iHelpTopic mGlossary;

	public HelpContent(String aContentPackName)
	{
		this(aContentPackName, null);
	}

	public HelpContent(String aContentPackName,
					iHelpTopic aContents)
	{
		mName = aContentPackName;
		mContents = aContents;
	}
	
	public HelpContent(String aContentPackName,
						iHelpTopic aContents,
						iHelpTopic aIndex)
	{
		this(aContentPackName, aContents);
		mIndex = aIndex;
	}

	public HelpContent(String aContentPackName,
					iHelpTopic aContents, 
					iHelpTopic aIndex, 
					iHelpTopic aGlossary)
	{
		Debug.println("CONTENT PACK => " + aContents + "\n\t" + aIndex + "\n\t" + aGlossary + "\n\t" + aGlossary.topicIterator());

		mName = aContentPackName;
		mContents = aContents;
		mGlossary = aGlossary;
		mIndex = aIndex;
		
		//remove all the sub-topics of the glossary items because the
		//glossary cannot have sub-topics.
		for (Iterator i = mGlossary.topicIterator(); i.hasNext(); )
		{
			iHelpTopic curTopic = (iHelpTopic)i.next();
			curTopic.removeSubTopics();
		}
		
		mGlossary = aGlossary;
	}
	
	public String getName()
	{
		return mName;
	}
	
	public iHelpTopic getTOC()
	{
		return mContents;
	}
	
	public iHelpTopic getIndex()
	{
		return mIndex;
	}
	
	public String getURL(String topicName)
	{
		Debug.println("LOADING A URL");
		
		if (mContents.name().equals(topicName))
		{
			Debug.println(mContents + " was found in this content pack. Returning " + mContents.url());
			return mContents.url();
		}
		else
		{
			for (Iterator i = mContents.topicIterator(); i.hasNext(); )
			{
				iHelpTopic curTopic = (iHelpTopic)i.next();
				
				if (curTopic.name().equals(topicName))
				{
					Debug.println(topicName + " was found in this content pack. Returning " + mContents.url());
					return mContents.url();
				}
			}
		}

		Debug.printException(new IllegalArgumentException("The topic " + topicName + " couldn't be found in the Help Content Pack."));
		return "";
	}
	
	public iHelpTopic getGlossary()
	{
		return mGlossary;
	}
}
