/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Help Viewer API in Java.
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package org.mozdev.firebirdhelp.HelpViewer;

import javax.swing.*;
import java.awt.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.io.IOException;
import org.mozdev.firebirdhelp.HelpViewer.*;
import org.mozdev.firebirdhelp.general.*;

import com.trfenv.rlk.Debug;

public class HelpViewer
{
	private JFrame helpViewer;
	private JEditorPane mContentsArea;

	private JTree helpToc;
	private JTree helpIndex;
	private JTree helpGlossary;
	
	private HelpContent mCP;
	
	private ToolbarButton btnBack;
	private ToolbarButton btnForward;
	private ToolbarButton btnHome;
	private ToolbarButton btnPrint;
	
	public HelpViewer(HelpContent contentPack)
	{
		mCP = contentPack;
		
		mContentsArea = new JEditorPane();
		mContentsArea.setEditable( false );
		mContentsArea.addHyperlinkListener(new HyperlinkListener()
	    {
	      public void hyperlinkUpdate( HyperlinkEvent event )
		  {		  
		  if ( event.getEventType() == HyperlinkEvent.EventType.ACTIVATED )
		    loadURL( event.getURL().toString() );
		  }
	    });

		helpViewer = new JFrame("MacroTracker Help");
		helpViewer.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		Container content = helpViewer.getContentPane();
		content.setLayout(new BorderLayout());
		
		JToolBar tlbr = new JToolBar();

		btnBack = new ToolbarButton("Back", "/images/Back16.gif", "/images/Back24.gif");
		btnForward = new ToolbarButton("Forward", "/images/Forward16.gif", "/images/Forward24.gif");
		btnHome = new ToolbarButton("Home", "/images/Home16.gif", "/images/Home24.gif");
		btnPrint = new ToolbarButton("Print", "/images/Print16.gif", "/images/Print24.gif");
		
		tlbr.add(btnBack);
		tlbr.add(btnForward);
		tlbr.addSeparator();
		tlbr.add(btnHome);
		tlbr.add(btnPrint);

		content.add(tlbr, BorderLayout.NORTH);

		JSplitPane splitpane = new JSplitPane();
		if (contentPack.getIndex().getTreeNode() != null)
			helpIndex = new JTree(contentPack.getIndex().getTreeNode());
		else
			helpIndex = new JTree();
		
		if (contentPack.getGlossary().getTreeNode() != null)
			helpGlossary = new JTree(contentPack.getTOC().getTreeNode());
		else
			helpGlossary = new JTree();
		
		if (contentPack.getTOC().getTreeNode() != null)
			helpToc = new JTree(contentPack.getTOC().getTreeNode());
		else
			helpToc = new JTree();
		
		JTabbedPane tabs = new JTabbedPane();
		tabs.addTab("Contents", null, new JScrollPane(helpToc));
		tabs.addTab("Index", null, new JScrollPane(helpIndex));
		tabs.addTab("Glossary", null, new JScrollPane(helpGlossary));
		splitpane.setLeftComponent(tabs);
		splitpane.setRightComponent(new JScrollPane(mContentsArea));
		
		content.add(splitpane, BorderLayout.CENTER);

		helpViewer.setSize(500,600);
		helpViewer.setVisible(true);
		
		helpToc.addTreeSelectionListener( new TreeSelectionListener()
		{
			public void valueChanged(TreeSelectionEvent e)
			{
				String url = mCP.getURL(e.getPath().getLastPathComponent().toString());
				Debug.println("Our current URL is " + url);
				loadURL(url);
			}
		});
	}

  /**
   *Load a URL inside of the Help Viewer.
   *@param location The URL you want to load.
   */
  private void loadURL( String location )
  {
	Debug.println("Loading HelpViewer URL: " + location);

    try
    {
      mContentsArea.setPage( location );
    }
    catch (IOException ioException )
    {
    }
  }

	private static UIManager.LookAndFeelInfo looks[];
	
	public static void main(String[] arcs)
	{
		try
		{
		looks = UIManager.getInstalledLookAndFeels();

		try
		{
			//1 = modaf look
			//2 = win32 look
			//3 = steel look (default in Java)
			UIManager.setLookAndFeel( looks[2].getClassName() );
		}
		catch (Exception ex)
		{
			//An exception will be thrown on Linux and MacOS because the
			//Win32 style is not available on non-win32 systems. In these
			//cases, Java defaults to the normal steel look, which is OK.
			Debug.printException(ex);
		}

		/** RUNNING HELP VIEWER TEST **/
		iHelpTopic indexA = new HelpTree("A", "");
		indexA.addSubTopic(new HelpTree("addCommand(ActionListener, String, String)", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#addCommand(java.awt.event.ActionListener,%20java.lang.String,%20java.lang.String"));

		iHelpTopic indexC = new HelpTree("C", "");
		indexC.addSubTopic(new HelpTree("com.trfenv.rlk", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/package-summary.html"));

		iHelpTopic indexD = new HelpTree("D", "");
		indexD.addSubTopic(new HelpTree("Debug", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html"));
		indexD.addSubTopic(new HelpTree("Debug()", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#Debug()"));

		iHelpTopic indexE = new HelpTree("E", "");
		indexE.addSubTopic(new HelpTree("exCount()", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#exCount()"));
		
		iHelpTopic indexP = new HelpTree("P", "");
		indexP.addSubTopic(new HelpTree("print(String)", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#print(java.lang.String)"));
		indexP.addSubTopic(new HelpTree("printException(Exception, String)", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#printException(java.lang.Exception,%20java.lang.String)"));
		indexP.addSubTopic(new HelpTree("printException(Exception)", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#printException(java.lang.Exception)"));
		indexP.addSubTopic(new HelpTree("println(String)", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#println(java.lang.String)"));

		iHelpTopic indexR = new HelpTree("R", "");
		indexR.addSubTopic(new HelpTree("reprintException(int)", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#reprintException(int)"));
		
		iHelpTopic indexS = new HelpTree("S", "");
		indexS.addSubTopic(new HelpTree("setLevels(int)", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#setLevels(int)"));

		iHelpTopic indexT = new HelpTree("T", "");
		indexT.addSubTopic(new HelpTree("turnOff()", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#turnOff()"));
		indexT.addSubTopic(new HelpTree("turnOn()", "file:///D:/Documents%20and%20Settings/Administrator/Desktop/rlkDebug/com/trfenv/rlk/Debug.html#turnOn()"));		

		iHelpTopic index = new HelpTree("", "");
		index.addSubTopic(indexA);
		index.addSubTopic(indexC);
		index.addSubTopic(indexD);
		index.addSubTopic(indexE);
		index.addSubTopic(indexP);
		index.addSubTopic(indexR);
		index.addSubTopic(indexS);
		index.addSubTopic(indexT);

		com.trfenv.rlk.Debug.turnOn();

		HelpContent contentPack = new HelpContent("MacroTracker Help", null, index);

		HelpViewer viewer = new HelpViewer(contentPack);
		}
		catch (Exception ex)
		{
			Debug.printException(ex);
		}
	}
}