//@line 36 "/cygdrive/e/builds/tinderbox/thunderbird-trunk/WINNT_5.0_Depend/mozilla/mail/components/preferences/advanced.js"

var gAdvancedPane = {
  mPane: null,
  mInitialized: false,

  init: function ()
  {
    this.mPane = document.getElementById("paneAdvanced");
    this.updateMarkAsReadTextbox(false);

    var preference = document.getElementById("mail.preferences.advanced.selectedTabIndex");
    if (preference.value)
      document.getElementById("advancedPrefs").selectedIndex = preference.value;
    this.mInitialized = true;
  },

  tabSelectionChanged: function ()
  {
    if (this.mInitialized)
    {
      var preference = document.getElementById("mail.preferences.advanced.selectedTabIndex");
      preference.valueFromPreferences = document.getElementById("advancedPrefs").selectedIndex;
    }
  },

  showConfigEdit: function()
  {
    document.documentElement.openWindow("Preferences:ConfigManager",
                                        "chrome://global/content/config.xul",
                                        "", null);
  },

  updateAppUpdateUI: function ()
  {
    var preference = document.getElementById("app.update.autoUpdateEnabled");
    var ids = ["enableAutoInstall", "autoInstallMode", "updateAnd"];
    if (!preference.value)
      for (var i = 0; i < ids.length; ++i)
        document.getElementById(ids[i]).disabled = true;
    else 
    {
      document.getElementById("enableAutoInstall").disabled = false;
      this.updateAutoInstallUI();
    }
    return undefined;
  },
  
  updateAutoInstallUI: function ()
  {
    var preference = document.getElementById("app.update.autoInstallEnabled");
    var ids = ["autoInstallMode", "updateAnd"];
    for (var i = 0; i < ids.length; ++i)
      document.getElementById(ids[i]).disabled = !preference.value;
    return undefined;
  },
  
  checkForUpdates: function (aType)
  {
    var updates = Components.classes["@mozilla.org/updates/update-service;1"]
                            .getService(Components.interfaces.nsIUpdateService);
    updates.checkForUpdates([], 0, aType, 
                            Components.interfaces.nsIUpdateService.SOURCE_EVENT_USER,
                            null);  
  },

  updateMarkAsReadTextbox: function(aFocusTextBox) 
  {
    var textbox = document.getElementById('markAsReadDelay'); 
    var checkbox = document.getElementById('markAsRead');
    textbox.disabled = !checkbox.checked;
    if (!textbox.disabled && aFocusTextBox)
        textbox.focus();
  },
};
