/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.isa2020.telem.decod;

import finanze.IDTE.isa2020.telem.decod.ParamsResultUtil;
import finanze.IDTE.isa2020.telem.decod.RecordDGN;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class GestoreMessaggioErrore {
    private static final String NOME_FILE_CODICE_ERRORE_VALIDAZIONE = "codiceerrorevalidazione.txt";
    private static final String PATH_BASE_RES_DECODER_JAR = "/finanze/IDTE/isa2020/telem/decod/resdj/";
    private static final String SUFFISSO_FILE_CONTROLLI_DECODER_JAR = "_decoderjar.txt";
    private static final String SPLITTING_REG_EX = "\\*";

    public static String[] interpretaRecordsDGN(String recordDGN, boolean isControlli) throws Exception {
        ArrayList<String> v_str = new ArrayList<String>();
        RecordDGN objRecordDGN = new RecordDGN(recordDGN);
        String tipoRecordAlleagato = objRecordDGN.getTipoRecordAllegato();
        String codiceModello = objRecordDGN.getCodiceModello();
        String codiceAttivita = objRecordDGN.getCodiceAttivita();
        String gravitaErrore = objRecordDGN.getGravitaErrore();
        int iGravitaErrore = Integer.parseInt(gravitaErrore);
        String codiceErrore = objRecordDGN.getCodiceErrore();
        List params = objRecordDGN.getParams();
        if (isControlli) {
            v_str.add(GestoreMessaggioErrore.getDescrizioneTelematica(iGravitaErrore));
        }
        v_str.add("Record tipo " + tipoRecordAlleagato);
        boolean flag = false;
        StringBuilder sb = new StringBuilder();
        if (codiceModello != null && codiceModello.trim().length() > 0) {
            flag = true;
            sb.append("ISA ");
            sb.append(codiceModello);
        }
        if (codiceAttivita != null && codiceAttivita.trim().length() > 0) {
            if (flag) {
                sb.append(" - ");
            }
            sb.append("Attivita' ");
            sb.append(codiceAttivita);
        }
        if (flag) {
            v_str.add(sb.toString());
        }
        if (codiceModello != null) {
            String messaggioControllo = GestoreMessaggioErrore.ottieniMessaggioErrore(codiceModello, codiceErrore);
            if (messaggioControllo == null && params != null) {
                messaggioControllo = GestoreMessaggioErrore.ottieniCodiceErroreValidazione(codiceErrore, params);
            }
            if (messaggioControllo != null) {
                v_str.add(messaggioControllo);
            }
        }
        v_str.add("\n");
        String[] arr_str = new String[v_str.size()];
        for (int i = 0; i < v_str.size(); ++i) {
            arr_str[i] = (String)v_str.get(i);
        }
        return arr_str;
    }

    private static String ottieniMessaggioErrore(String codiceModello, String codiceErrore) throws Exception {
        StringBuilder sbPathCodErrMsg = new StringBuilder();
        sbPathCodErrMsg.append(PATH_BASE_RES_DECODER_JAR);
        sbPathCodErrMsg.append(codiceModello.toLowerCase());
        sbPathCodErrMsg.append(SUFFISSO_FILE_CONTROLLI_DECODER_JAR);
        String messaggioControllo = GestoreMessaggioErrore.cercaMessaggio(sbPathCodErrMsg.toString(), codiceErrore);
        return messaggioControllo;
    }

    private static String ottieniCodiceErroreValidazione(String codiceErrore, List params) throws Exception {
        StringBuilder sbPathCodErrMsg = new StringBuilder();
        sbPathCodErrMsg.append(PATH_BASE_RES_DECODER_JAR);
        sbPathCodErrMsg.append(NOME_FILE_CODICE_ERRORE_VALIDAZIONE);
        String messaggioControllo = GestoreMessaggioErrore.cercaMessaggio(sbPathCodErrMsg.toString(), codiceErrore);
        if (params != null) {
            messaggioControllo = ParamsResultUtil.sostituisciToken(messaggioControllo, params);
        }
        return messaggioControllo;
    }

    private static String cercaMessaggio(String path, String codiceErrore) throws Exception {
        InputStream isCodErrMsg = GestoreMessaggioErrore.class.getResourceAsStream(path);
        InputStreamReader isReader = new InputStreamReader(isCodErrMsg);
        BufferedReader reader = new BufferedReader(isReader);
        String messaggioControllo = null;
        String riga = reader.readLine();
        while (riga != null) {
            String[] tokens = riga.split(SPLITTING_REG_EX);
            String codiceErroreMessaggio = tokens[0];
            if (codiceErroreMessaggio.equals(codiceErrore)) {
                String messaggioErrore = tokens[1];
                return messaggioErrore;
            }
            riga = reader.readLine();
        }
        reader.close();
        return messaggioControllo;
    }

    private static String getDescrizioneTelematica(int gravitaErrore) {
        switch (gravitaErrore) {
            case 0: {
                return "";
            }
            case 4: {
                return "(*)";
            }
            case 8: {
                return "(**)";
            }
            case 14: {
                return "(***C)";
            }
            case 16: {
                return "(****)";
            }
        }
        return "";
    }
}

