/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import org.w3c.dom.DOMStringList;

public class DOMStringListImpl
implements DOMStringList {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;

    DOMStringListImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static DOMStringList create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        return new DOMStringListImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(DOMStringList arg) {
        return arg == null ? 0L : ((DOMStringListImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof DOMStringListImpl && this.peer == ((DOMStringListImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static DOMStringList getImpl(long peer, long contextPeer, long rootPeer) {
        return DOMStringListImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public int getLength() {
        return DOMStringListImpl.getLengthImpl(this.getPeer());
    }

    static native int getLengthImpl(long var0);

    @Override
    public String item(int index) {
        return DOMStringListImpl.itemImpl(this.getPeer(), index);
    }

    static native String itemImpl(long var0, int var2);

    @Override
    public boolean contains(String string) {
        return DOMStringListImpl.containsImpl(this.getPeer(), string);
    }

    static native boolean containsImpl(long var0, String var2);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            DOMStringListImpl.dispose(this.peer);
        }
    }
}

