/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private volatile boolean removeOnCancel = false;
    private static final AtomicLong sequencer = new AtomicLong(0L);

    final long now() {
        return System.nanoTime();
    }

    boolean canRunInCurrentRunState(boolean bl) {
        return this.isRunningOrShutdown(bl ? this.continueExistingPeriodicTasksAfterShutdown : this.executeExistingDelayedTasksAfterShutdown);
    }

    private void delayedExecute(RunnableScheduledFuture<?> runnableScheduledFuture) {
        if (this.isShutdown()) {
            this.reject(runnableScheduledFuture);
        } else {
            super.getQueue().add(runnableScheduledFuture);
            if (this.isShutdown() && !this.canRunInCurrentRunState(runnableScheduledFuture.isPeriodic()) && this.remove(runnableScheduledFuture)) {
                runnableScheduledFuture.cancel(false);
            } else {
                this.ensurePrestart();
            }
        }
    }

    void reExecutePeriodic(RunnableScheduledFuture<?> runnableScheduledFuture) {
        if (this.canRunInCurrentRunState(true)) {
            super.getQueue().add(runnableScheduledFuture);
            if (!this.canRunInCurrentRunState(true) && this.remove(runnableScheduledFuture)) {
                runnableScheduledFuture.cancel(false);
            } else {
                this.ensurePrestart();
            }
        }
    }

    @Override
    void onShutdown() {
        BlockingQueue<Runnable> blockingQueue = super.getQueue();
        boolean bl = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean bl2 = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!bl && !bl2) {
            for (Object object : blockingQueue.toArray()) {
                if (!(object instanceof RunnableScheduledFuture)) continue;
                ((RunnableScheduledFuture)object).cancel(false);
            }
            blockingQueue.clear();
        } else {
            for (Object object : blockingQueue.toArray()) {
                RunnableScheduledFuture runnableScheduledFuture;
                if (!(object instanceof RunnableScheduledFuture) || !(!(runnableScheduledFuture = (RunnableScheduledFuture)object).isPeriodic() ? !bl : !bl2) && !runnableScheduledFuture.isCancelled() || !blockingQueue.remove(runnableScheduledFuture)) continue;
                runnableScheduledFuture.cancel(false);
            }
        }
        this.tryTerminate();
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    public ScheduledThreadPoolExecutor(int n) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
    }

    public ScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), threadFactory);
    }

    public ScheduledThreadPoolExecutor(int n, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), rejectedExecutionHandler);
    }

    public ScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, rejectedExecutionHandler);
    }

    private long triggerTime(long l, TimeUnit timeUnit) {
        return this.triggerTime(timeUnit.toNanos(l < 0L ? 0L : l));
    }

    long triggerTime(long l) {
        return this.now() + (l < 0x3FFFFFFFFFFFFFFFL ? l : this.overflowFree(l));
    }

    private long overflowFree(long l) {
        long l2;
        Delayed delayed = (Delayed)super.getQueue().peek();
        if (delayed != null && (l2 = delayed.getDelay(TimeUnit.NANOSECONDS)) < 0L && l - l2 < 0L) {
            l = Long.MAX_VALUE + l2;
        }
        return l;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<Object> runnableScheduledFuture = this.decorateTask(runnable, new ScheduledFutureTask<Object>(runnable, null, this.triggerTime(l, timeUnit)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        if (callable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<V> runnableScheduledFuture = this.decorateTask(callable, new ScheduledFutureTask<V>(callable, this.triggerTime(l, timeUnit)));
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> scheduledFutureTask = new ScheduledFutureTask<Object>(runnable, null, this.triggerTime(l, timeUnit), timeUnit.toNanos(l2));
        RunnableScheduledFuture<Object> runnableScheduledFuture = this.decorateTask(runnable, scheduledFutureTask);
        scheduledFutureTask.outerTask = runnableScheduledFuture;
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> scheduledFutureTask = new ScheduledFutureTask<Object>(runnable, null, this.triggerTime(l, timeUnit), timeUnit.toNanos(-l2));
        RunnableScheduledFuture<Object> runnableScheduledFuture = this.decorateTask(runnable, scheduledFutureTask);
        scheduledFutureTask.outerTask = runnableScheduledFuture;
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public void execute(Runnable runnable) {
        this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.schedule(Executors.callable(runnable, t), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.schedule(callable, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean bl) {
        this.continueExistingPeriodicTasksAfterShutdown = bl;
        if (!bl && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean bl) {
        this.executeExistingDelayedTasksAfterShutdown = bl;
        if (!bl && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void setRemoveOnCancelPolicy(boolean bl) {
        this.removeOnCancel = bl;
    }

    public boolean getRemoveOnCancelPolicy() {
        return this.removeOnCancel;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return super.getQueue();
    }

    static class DelayedWorkQueue
    extends AbstractQueue<Runnable>
    implements BlockingQueue<Runnable> {
        private static final int INITIAL_CAPACITY = 16;
        private RunnableScheduledFuture[] queue = new RunnableScheduledFuture[16];
        private final ReentrantLock lock = new ReentrantLock();
        private int size = 0;
        private Thread leader = null;
        private final Condition available = this.lock.newCondition();

        DelayedWorkQueue() {
        }

        private void setIndex(RunnableScheduledFuture runnableScheduledFuture, int n) {
            if (runnableScheduledFuture instanceof ScheduledFutureTask) {
                ((ScheduledFutureTask)runnableScheduledFuture).heapIndex = n;
            }
        }

        private void siftUp(int n, RunnableScheduledFuture runnableScheduledFuture) {
            int n2;
            RunnableScheduledFuture runnableScheduledFuture2;
            while (n > 0 && runnableScheduledFuture.compareTo(runnableScheduledFuture2 = this.queue[n2 = n - 1 >>> 1]) < 0) {
                this.queue[n] = runnableScheduledFuture2;
                this.setIndex(runnableScheduledFuture2, n);
                n = n2;
            }
            this.queue[n] = runnableScheduledFuture;
            this.setIndex(runnableScheduledFuture, n);
        }

        private void siftDown(int n, RunnableScheduledFuture runnableScheduledFuture) {
            int n2 = this.size >>> 1;
            while (n < n2) {
                int n3 = (n << 1) + 1;
                RunnableScheduledFuture runnableScheduledFuture2 = this.queue[n3];
                int n4 = n3 + 1;
                if (n4 < this.size && runnableScheduledFuture2.compareTo(this.queue[n4]) > 0) {
                    n3 = n4;
                    runnableScheduledFuture2 = this.queue[n3];
                }
                if (runnableScheduledFuture.compareTo(runnableScheduledFuture2) <= 0) break;
                this.queue[n] = runnableScheduledFuture2;
                this.setIndex(runnableScheduledFuture2, n);
                n = n3;
            }
            this.queue[n] = runnableScheduledFuture;
            this.setIndex(runnableScheduledFuture, n);
        }

        private void grow() {
            int n = this.queue.length;
            int n2 = n + (n >> 1);
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            }
            this.queue = Arrays.copyOf(this.queue, n2);
        }

        private int indexOf(Object object) {
            if (object != null) {
                if (object instanceof ScheduledFutureTask) {
                    int n = ((ScheduledFutureTask)object).heapIndex;
                    if (n >= 0 && n < this.size && this.queue[n] == object) {
                        return n;
                    }
                } else {
                    for (int i = 0; i < this.size; ++i) {
                        if (!object.equals(this.queue[i])) continue;
                        return i;
                    }
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean bl = this.indexOf(object) != -1;
                return bl;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                int n = this.indexOf(object);
                if (n < 0) {
                    boolean bl = false;
                    return bl;
                }
                this.setIndex(this.queue[n], -1);
                int n2 = --this.size;
                RunnableScheduledFuture runnableScheduledFuture = this.queue[n2];
                this.queue[n2] = null;
                if (n2 != n) {
                    this.siftDown(n, runnableScheduledFuture);
                    if (this.queue[n] == runnableScheduledFuture) {
                        this.siftUp(n, runnableScheduledFuture);
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                int n = this.size;
                return n;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RunnableScheduledFuture peek() {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                RunnableScheduledFuture runnableScheduledFuture = this.queue[0];
                return runnableScheduledFuture;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            RunnableScheduledFuture runnableScheduledFuture = (RunnableScheduledFuture)runnable;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                int n = this.size;
                if (n >= this.queue.length) {
                    this.grow();
                }
                this.size = n + 1;
                if (n == 0) {
                    this.queue[0] = runnableScheduledFuture;
                    this.setIndex(runnableScheduledFuture, 0);
                } else {
                    this.siftUp(n, runnableScheduledFuture);
                }
                if (this.queue[0] == runnableScheduledFuture) {
                    this.leader = null;
                    this.available.signal();
                }
            }
            finally {
                reentrantLock.unlock();
            }
            return true;
        }

        @Override
        public void put(Runnable runnable) {
            this.offer(runnable);
        }

        @Override
        public boolean add(Runnable runnable) {
            return this.offer(runnable);
        }

        @Override
        public boolean offer(Runnable runnable, long l, TimeUnit timeUnit) {
            return this.offer(runnable);
        }

        private RunnableScheduledFuture finishPoll(RunnableScheduledFuture runnableScheduledFuture) {
            int n = --this.size;
            RunnableScheduledFuture runnableScheduledFuture2 = this.queue[n];
            this.queue[n] = null;
            if (n != 0) {
                this.siftDown(0, runnableScheduledFuture2);
            }
            this.setIndex(runnableScheduledFuture, -1);
            return runnableScheduledFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RunnableScheduledFuture poll() {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                RunnableScheduledFuture runnableScheduledFuture = this.queue[0];
                if (runnableScheduledFuture == null || runnableScheduledFuture.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                    RunnableScheduledFuture runnableScheduledFuture2 = null;
                    return runnableScheduledFuture2;
                }
                RunnableScheduledFuture runnableScheduledFuture3 = this.finishPoll(runnableScheduledFuture);
                return runnableScheduledFuture3;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public RunnableScheduledFuture take() throws InterruptedException {
            var1_1 = this.lock;
            var1_1.lockInterruptibly();
            block7: while (true) {
                while (true) lbl-1000:
                // 4 sources

                {
                    if ((var2_2 = this.queue[0]) == null) {
                        this.available.await();
                        continue block7;
                    }
                    var3_3 = var2_2.getDelay(TimeUnit.NANOSECONDS);
                    if (var3_3 <= 0L) {
                        var5_4 /* !! */  = this.finishPoll(var2_2);
                        return var5_4 /* !! */ ;
                    }
                    if (this.leader != null) {
                        this.available.await();
                        continue;
                    }
                    var5_4 /* !! */  = Thread.currentThread();
                    this.leader = var5_4 /* !! */ ;
                    try {
                        this.available.awaitNanos(var3_3);
                    }
                    finally {
                        if (this.leader != var5_4 /* !! */ ) continue;
                        this.leader = null;
                        continue;
                    }
                    break;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (this.leader == null && this.queue[0] != null) {
                    this.available.signal();
                }
                var1_1.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public RunnableScheduledFuture poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
            var4_3 = var3_2.toNanos(var1_1);
            var6_4 = this.lock;
            var6_4.lockInterruptibly();
            while (true) lbl-1000:
            // 5 sources

            {
                if ((var7_5 = this.queue[0]) == null) {
                    if (var4_3 <= 0L) {
                        var8_7 = null;
                        return var8_7;
                    }
                    var4_3 = this.available.awaitNanos(var4_3);
                    continue;
                }
                var8_6 = var7_5.getDelay(TimeUnit.NANOSECONDS);
                if (var8_6 <= 0L) {
                    var10_8 /* !! */  = this.finishPoll(var7_5);
                    return var10_8 /* !! */ ;
                }
                if (var4_3 <= 0L) {
                    var10_8 /* !! */  = null;
                    return var10_8 /* !! */ ;
                }
                if (var4_3 < var8_6 || this.leader != null) {
                    var4_3 = this.available.awaitNanos(var4_3);
                    continue;
                }
                var10_8 /* !! */  = Thread.currentThread();
                this.leader = var10_8 /* !! */ ;
                try {
                    var11_9 = this.available.awaitNanos(var8_6);
                    var4_3 -= var8_6 - var11_9;
                }
                finally {
                    if (this.leader != var10_8 /* !! */ ) continue;
                    this.leader = null;
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (this.leader == null && this.queue[0] != null) {
                    this.available.signal();
                }
                var6_4.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                for (int i = 0; i < this.size; ++i) {
                    RunnableScheduledFuture runnableScheduledFuture = this.queue[i];
                    if (runnableScheduledFuture == null) continue;
                    this.queue[i] = null;
                    this.setIndex(runnableScheduledFuture, -1);
                }
                this.size = 0;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        private RunnableScheduledFuture pollExpired() {
            RunnableScheduledFuture runnableScheduledFuture = this.queue[0];
            if (runnableScheduledFuture == null || runnableScheduledFuture.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                return null;
            }
            return this.finishPoll(runnableScheduledFuture);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super Runnable> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            if (collection == this) {
                throw new IllegalArgumentException();
            }
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                RunnableScheduledFuture runnableScheduledFuture;
                int n = 0;
                while ((runnableScheduledFuture = this.pollExpired()) != null) {
                    collection.add(runnableScheduledFuture);
                    ++n;
                }
                int n2 = n;
                return n2;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super Runnable> collection, int n) {
            if (collection == null) {
                throw new NullPointerException();
            }
            if (collection == this) {
                throw new IllegalArgumentException();
            }
            if (n <= 0) {
                return 0;
            }
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                RunnableScheduledFuture runnableScheduledFuture;
                int n2;
                for (n2 = 0; n2 < n && (runnableScheduledFuture = this.pollExpired()) != null; ++n2) {
                    collection.add(runnableScheduledFuture);
                }
                int n3 = n2;
                return n3;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                Object[] objectArray = Arrays.copyOf(this.queue, this.size, Object[].class);
                return objectArray;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                if (TArray.length < this.size) {
                    T[] TArray2 = Arrays.copyOf(this.queue, this.size, TArray.getClass());
                    return TArray2;
                }
                System.arraycopy(this.queue, 0, TArray, 0, this.size);
                if (TArray.length > this.size) {
                    TArray[this.size] = null;
                }
                T[] TArray3 = TArray;
                return TArray3;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Itr(Arrays.copyOf(this.queue, this.size));
        }

        private class Itr
        implements Iterator<Runnable> {
            final RunnableScheduledFuture[] array;
            int cursor = 0;
            int lastRet = -1;

            Itr(RunnableScheduledFuture[] runnableScheduledFutureArray) {
                this.array = runnableScheduledFutureArray;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.array.length;
            }

            @Override
            public Runnable next() {
                if (this.cursor >= this.array.length) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.cursor;
                return this.array[this.cursor++];
            }

            @Override
            public void remove() {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                DelayedWorkQueue.this.remove(this.array[this.lastRet]);
                this.lastRet = -1;
            }
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;
        RunnableScheduledFuture<V> outerTask;
        int heapIndex;

        ScheduledFutureTask(Runnable runnable, V v, long l) {
            super(runnable, v);
            this.outerTask = this;
            this.time = l;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable runnable, V v, long l, long l2) {
            super(runnable, v);
            this.outerTask = this;
            this.time = l;
            this.period = l2;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long l) {
            super(callable);
            this.outerTask = this;
            this.time = l;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            if (delayed == this) {
                return 0;
            }
            if (delayed instanceof ScheduledFutureTask) {
                ScheduledFutureTask scheduledFutureTask = (ScheduledFutureTask)delayed;
                long l = this.time - scheduledFutureTask.time;
                if (l < 0L) {
                    return -1;
                }
                if (l > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < scheduledFutureTask.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long l = this.getDelay(TimeUnit.NANOSECONDS) - delayed.getDelay(TimeUnit.NANOSECONDS);
            return l == 0L ? 0 : (l < 0L ? -1 : 1);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long l = this.period;
            this.time = l > 0L ? (this.time += l) : ScheduledThreadPoolExecutor.this.triggerTime(-l);
        }

        @Override
        public boolean cancel(boolean bl) {
            boolean bl2 = super.cancel(bl);
            if (bl2 && ScheduledThreadPoolExecutor.this.removeOnCancel && this.heapIndex >= 0) {
                ScheduledThreadPoolExecutor.this.remove(this);
            }
            return bl2;
        }

        @Override
        public void run() {
            boolean bl = this.isPeriodic();
            if (!ScheduledThreadPoolExecutor.this.canRunInCurrentRunState(bl)) {
                this.cancel(false);
            } else if (!bl) {
                ScheduledFutureTask.super.run();
            } else if (ScheduledFutureTask.super.runAndReset()) {
                this.setNextRunTime();
                ScheduledThreadPoolExecutor.this.reExecutePeriodic(this.outerTask);
            }
        }
    }
}

