/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.security.dsa.DSAParams;
import iaik.security.md.SHA;
import iaik.security.random.SecRandom;
import iaik.utils.NumberTheory;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int b = -1;
    private SecureRandom a = null;
    private MessageDigest c = new SHA();
    private static final boolean e = false;
    private static final boolean d = false;

    private DSAParams b(int n2) {
        BigInteger[] bigIntegerArray = this.a((n2 - 512) / 64);
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        BigInteger bigInteger3 = this.a(bigInteger, bigInteger2);
        return new DSAParams(bigInteger, bigInteger2, bigInteger3);
    }

    private synchronized BigInteger[] a(int n2) {
        int n3 = 512 + 64 * n2;
        int n4 = (n3 - 1) / 160;
        int n5 = (n3 - 1) % 160;
        BigInteger bigInteger = NumberTheory.TWO.pow(159);
        BigInteger bigInteger2 = NumberTheory.TWO.pow(160);
        this.c.reset();
        while (true) {
            BigInteger bigInteger3;
            BigInteger bigInteger4 = new BigInteger(160, this.a);
            BigInteger bigInteger5 = bigInteger4.or(bigInteger);
            BigInteger bigInteger6 = bigInteger5.add(NumberTheory.ONE).mod(bigInteger2);
            BigInteger[] bigIntegerArray = new BigInteger(1, this.c.digest(bigInteger5.toByteArray()));
            BigInteger bigInteger7 = bigIntegerArray.xor(bigInteger3 = new BigInteger(1, this.c.digest(bigInteger6.toByteArray())));
            BigInteger bigInteger8 = bigInteger7.or(bigInteger).or(NumberTheory.ONE);
            if (!NumberTheory.isProbablePrime(bigInteger8)) continue;
            int n6 = 0;
            int n7 = 2;
            do {
                BigInteger bigInteger9;
                BigInteger bigInteger10;
                bigIntegerArray = new BigInteger[n4 + 1];
                bigInteger3 = BigInteger.valueOf(n7);
                int n8 = 0;
                while (n8 <= n4) {
                    bigInteger10 = BigInteger.valueOf(n8);
                    bigIntegerArray[n8] = new BigInteger(1, this.c.digest(bigInteger5.add(bigInteger3).add(bigInteger10).mod(bigInteger2).toByteArray()));
                    ++n8;
                }
                bigIntegerArray[n4] = bigIntegerArray[n4].mod(NumberTheory.TWO.pow(n5));
                bigInteger10 = NumberTheory.ZERO;
                int n9 = 0;
                int n10 = 0;
                while (n10 <= n4) {
                    bigInteger10 = bigInteger10.add(bigIntegerArray[n10].shiftLeft(n9));
                    n9 += 160;
                    ++n10;
                }
                BigInteger bigInteger11 = bigInteger10.add(NumberTheory.TWO.pow(n3 - 1));
                BigInteger bigInteger12 = bigInteger11.subtract((bigInteger9 = bigInteger11.mod(bigInteger8.shiftLeft(1))).subtract(NumberTheory.ONE));
                if (bigInteger12.compareTo(NumberTheory.TWO.pow(n3 - 1)) >= 0 && NumberTheory.isProbablePrime(bigInteger12)) {
                    BigInteger[] bigIntegerArray2 = new BigInteger[]{bigInteger12, bigInteger8};
                    return bigIntegerArray2;
                }
                n7 += n4 + 1;
            } while (++n6 < 4096);
        }
    }

    private BigInteger a(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4 = bigInteger.subtract(NumberTheory.ONE);
        BigInteger bigInteger5 = bigInteger4.divide(bigInteger2);
        BigInteger bigInteger6 = NumberTheory.ONE;
        do {
            bigInteger3 = bigInteger6.modPow(bigInteger5, bigInteger);
            bigInteger6 = bigInteger6.add(NumberTheory.ONE);
        } while (bigInteger3.equals(NumberTheory.ONE));
        return bigInteger3;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.a = secureRandom;
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameter must be null.");
        }
        this.a();
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.a = secureRandom;
        this.b = n2;
        this.a();
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.a == null) {
            this.a = SecRandom.getDefault();
        }
        if (this.b == -1) {
            this.b = 1024;
        }
        if (this.b < 512) {
            this.b = 512;
        }
        if (this.b > 4096) {
            this.b = 4096;
        }
        this.b &= 0xFFC0;
        DSAParams dSAParams = this.b(this.b);
        DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DSA", "IAIK");
            algorithmParameters.init(dSAParameterSpec);
            return algorithmParameters;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.toString());
        }
    }

    private void a() throws IllegalArgumentException {
        if (this.b < 512 || this.b > 4096 || this.b % 64 != 0) {
            throw new IllegalArgumentException("Prime must be at least 512, at most 4096, and a multiple of 64!");
        }
    }
}

