/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.attr.Holder;
import iaik.x509.attr.Target;
import iaik.x509.attr.TargetException;
import iaik.x509.attr.Targets;
import java.util.Enumeration;
import java.util.Vector;

public class ProxyInfo
extends V3Extension {
    private Holder b;
    private Vector a = new Vector();
    public static final ObjectID oid = new ObjectID("1.3.6.1.5.5.7.1.10", "ProxyInfo");

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.isEmpty()) {
            stringBuffer.append("This ProxyInfo does not contain any Targets.");
        } else {
            int n2 = this.a.size();
            if (bl) {
                stringBuffer.append("This ProxyInfo contains " + n2 + " Targets object(s):\n");
                int n3 = 1;
                Enumeration enumeration = this.a.elements();
                while (enumeration.hasMoreElements()) {
                    if (n3 > 1) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("Targets " + n3++ + ":\n");
                    Util.printIndented(((Targets)enumeration.nextElement()).toString(true), true, stringBuffer);
                }
            } else {
                stringBuffer.append("This ProxyInfo contains " + n2 + " Targets object(s).");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        Enumeration enumeration = this.a.elements();
        try {
            while (enumeration.hasMoreElements()) {
                sEQUENCE.addComponent(((Targets)enumeration.nextElement()).toASN1Object());
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Cannot create ASN.1 Targets: " + codingException.getMessage());
        }
        return sEQUENCE;
    }

    public void specifyHolder(Holder holder) {
        this.b = holder;
    }

    public void setTargets(Targets[] targetsArray) {
        this.a.removeAllElements();
        if (targetsArray != null) {
            int n2 = 0;
            while (n2 < targetsArray.length) {
                this.a.addElement(targetsArray[n2]);
                ++n2;
            }
        }
    }

    public boolean removeTargets(Targets targets) {
        return this.a.removeElement(targets);
    }

    public boolean removeTargetElement(Target target) {
        boolean bl = false;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Targets targets = (Targets)enumeration.nextElement();
            if (!targets.removeTarget(target)) continue;
            bl = true;
            if (targets.size() != 0) continue;
            this.a.removeElement(targets);
        }
        return bl;
    }

    public void removeAllTargets() {
        this.a.removeAllElements();
    }

    public int numberOfTargets() {
        return this.a.size();
    }

    public int numberOfTargetElements() {
        return this.getTargetElements().length;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new X509ExtensionException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getName() + ") of ProxyInfo extension; must be a SEQUENCE!");
        }
        this.a.removeAllElements();
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                this.a.addElement(new Targets(aSN1Object.getComponentAt(n2)));
                ++n2;
            }
            return;
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Error parsing Targets object: " + codingException.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public Targets getTargets(Object object) throws TargetException {
        Targets targets = null;
        if (this.a.size() > 0) {
            TargetException targetException = null;
            Enumeration enumeration = this.a.elements();
            while (enumeration.hasMoreElements()) {
                Targets targets2 = (Targets)enumeration.nextElement();
                try {
                    if (!targets2.isTargetFor(object)) continue;
                    targets = targets2;
                    break;
                }
                catch (TargetException targetException2) {
                    targetException = targetException2;
                }
            }
            if (targets == null && targetException != null) {
                throw targetException;
            }
        }
        return targets;
    }

    public Targets[] getTargets() {
        Object[] objectArray = new Targets[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public Target[] getTargetElements() {
        Object object;
        Vector<Target> vector = new Vector<Target>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            object = (Targets)enumeration.nextElement();
            Target[] targetArray = ((Targets)object).getTargets();
            int n2 = 0;
            while (n2 < targetArray.length) {
                vector.addElement(targetArray[n2]);
                ++n2;
            }
        }
        object = new Target[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public boolean containsTargetElement(Target target) {
        boolean bl = false;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Targets targets = (Targets)enumeration.nextElement();
            if (!targets.containsTarget(target)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean checkProxyChain(Target[] targetArray) throws TargetException {
        if (targetArray == null) {
            throw new NullPointerException("Cannot check null array of Target elements.");
        }
        if (targetArray.length == 0) {
            throw new NullPointerException("Cannot check empty array of Target elements.");
        }
        boolean bl = false;
        if (this.a.size() > 0) {
            Targets targets = this.getTargets(targetArray[0]);
            if (targets != null) {
                bl = true;
                int n2 = 1;
                while (n2 < targetArray.length) {
                    if (!targets.isTargetFor(targetArray[n2])) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            throw new TargetException("Cannot verify proxy chain since no Targets are included in this ProxyInfo extension.");
        }
        return bl;
    }

    public boolean checkProxy(Object object, Object object2) throws TargetException {
        boolean bl = false;
        if (object instanceof Holder) {
            if (this.b == null) {
                throw new NullPointerException("Cannot verify sender identity since AC holder not specified!");
            }
            bl = this.b.equals(object) && (this.a.size() == 0 || this.getTargets(object2) != null);
        } else {
            Targets targets;
            bl = this.a.size() == 0 ? true : ((targets = this.getTargets(object)) == null ? false : targets.isTargetFor(object2));
        }
        return bl;
    }

    public boolean addTargets(Targets targets) {
        boolean bl = true;
        if (this.a.contains(targets)) {
            bl = false;
        } else {
            this.a.addElement(targets);
        }
        return bl;
    }
}

