/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.ErrorWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusEntryFilter;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryWizard;
import org.eclipse.swt.widgets.Composite;

public final class RefactoringHistoryErrorPage
extends ErrorWizardPage {
    private RefactoringStatusEntryFilter fFilter = new RefactoringStatusEntryFilter();
    private boolean fNextPageDisabled = false;
    private Refactoring fRefactoring;

    public RefactoringHistoryErrorPage() {
        super(true);
        this.setTitle(RefactoringUIMessages.RefactoringHistoryOverviewPage_title);
        this.setDescription(Messages.format(RefactoringUIMessages.RefactoringHistoryErrorPage_description, new String[]{this.getLabelAsText(IDialogConstants.NEXT_LABEL), this.getLabelAsText(IDialogConstants.FINISH_LABEL)}));
    }

    public boolean canFlipToNextPage() {
        return !this.fNextPageDisabled;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.fViewer.setFilter(this.fFilter);
    }

    public IWizardPage getNextPage() {
        return this.getWizard().getNextPage((IWizardPage)this);
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPreviousPage((IWizardPage)this);
    }

    public Refactoring getRefactoring() {
        return this.fRefactoring;
    }

    protected RefactoringHistoryWizard getRefactoringHistoryWizard() {
        IWizard result = this.getWizard();
        if (result instanceof RefactoringHistoryWizard) {
            return (RefactoringHistoryWizard)result;
        }
        return null;
    }

    public boolean isNextPageDisabled() {
        return this.fNextPageDisabled;
    }

    protected boolean performFinish() {
        return true;
    }

    public void setFilter(RefactoringStatusEntryFilter filter) {
        Assert.isNotNull((Object)filter);
        this.fFilter = filter;
    }

    public void setNextPageDisabled(boolean disable) {
        this.fNextPageDisabled = disable;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(true);
    }

    public void setRefactoring(Refactoring refactoring) {
        this.fRefactoring = refactoring;
    }

    public void setStatus(RefactoringStatus status) {
        super.setStatus(status);
        if (status != null) {
            int severity = status.getSeverity();
            if (severity >= 4) {
                this.setDescription(RefactoringUIMessages.RefactoringHistoryErrorPage_fatal_error);
            } else if (severity >= 1) {
                this.setDescription(Messages.format(RefactoringUIMessages.RefactoringHistoryErrorPage_info_error, new String[]{this.getLabelAsText(IDialogConstants.NEXT_LABEL), this.getLabelAsText(IDialogConstants.FINISH_LABEL)}));
            }
        }
        if (this.fViewer != null) {
            this.fViewer.setStatus(status);
        }
    }

    public void setTitle(RefactoringDescriptorProxy descriptor, int current, int total) {
        String message = descriptor != null ? descriptor.getDescription() : RefactoringUIMessages.RefactoringHistoryOverviewPage_title;
        if (total > 1) {
            this.setTitle(Messages.format(RefactoringUIMessages.RefactoringHistoryPreviewPage_refactoring_pattern, new String[]{message, String.valueOf(current + 1), String.valueOf(total)}));
        } else {
            this.setTitle(message);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fViewer != null && this.fViewer.getStatus() != this.fStatus) {
                this.fViewer.setStatus(this.fStatus);
            }
        } else {
            this.setPageComplete(!this.fNextPageDisabled);
        }
        this.getControl().setVisible(visible);
    }

    public void setWizard(IWizard newWizard) {
        Assert.isTrue((boolean)(newWizard instanceof RefactoringHistoryWizard));
        super.setWizard(newWizard);
    }
}

